/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.oracle12;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.StringJoiner;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.locator.ClasspathSqlLocator;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Script;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.tc.JdbiTestcontainersExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Tag(value="slow")
@Testcontainers
@EnabledOnOs(architectures={"x86_64", "amd64"})
public class TestScript {
    static final String CONTAINER_VERSION = "gvenzl/oracle-xe:" + System.getProperty("oracle.container.version", "slim-faststart");
    @Container
    static OracleContainer oc = new OracleContainer(CONTAINER_VERSION);
    @RegisterExtension
    public JdbiExtension oracleExtension = JdbiTestcontainersExtension.instance((JdbcDatabaseContainer)oc);

    @Test
    void testStatementParsing() {
        Handle h = this.oracleExtension.getSharedHandle();
        String sql = ClasspathSqlLocator.removingComments().getResource("scripts/oracle-issue-2021.sql");
        try (Script script = new Script(h, sql);){
            List statements = script.getStatements();
            Assertions.assertThat((int)statements.size()).isEqualTo(3);
            for (String statement : statements) {
                Assertions.assertThat((String)statement).doesNotEndWithIgnoringCase((CharSequence)"end");
            }
        }
    }

    @Test
    void testIssue2021() {
        Handle h = this.oracleExtension.getSharedHandle();
        String sql = ClasspathSqlLocator.removingComments().getResource("scripts/oracle-issue-2021.sql");
        try (Script script = new Script(h, sql);){
            int[] outcome = script.execute();
            Assertions.assertThat((int[])outcome).hasSize(3).containsExactly(new int[]{0, 0, 0});
        }
        for (int i = 0; i < 10; ++i) {
            int rows = ((Update)h.createUpdate("INSERT INTO EXAMPLE (VALUE) VALUES (:value)").bind("value", "TEST" + i)).execute();
            Assertions.assertThat((int)rows).isOne();
        }
        try (Query q = h.createQuery("SELECT * FROM EXAMPLE ORDER BY ID");){
            List result = q.map((RowMapper)new ExampleMapper()).list();
            Assertions.assertThat((int)result.size()).isEqualTo(10);
            for (int i = 0; i < result.size(); ++i) {
                Example example = (Example)result.get(i);
                Assertions.assertThat((long)example.id()).isEqualTo((long)(i + 1));
                Assertions.assertThat((String)example.username()).isEqualToIgnoringCase((CharSequence)"SYSTEM");
                Assertions.assertThat((String)example.value()).isEqualTo("TEST" + i);
            }
        }
    }

    public static final class ExampleMapper
    implements RowMapper<Example> {
        public Example map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new Example(rs.getLong("id"), rs.getString("username"), rs.getString("value"));
        }
    }

    public static final class Example {
        private final long id;
        private final String username;
        private final String value;

        public Example(long id, String username, String value) {
            this.id = id;
            this.username = username;
            this.value = value;
        }

        public long id() {
            return this.id;
        }

        public String username() {
            return this.username;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return new StringJoiner(", ", Example.class.getSimpleName() + "[", "]").add("id=" + this.id).add("username='" + this.username + "'").add("value='" + this.value + "'").toString();
        }
    }
}

