/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.oracle12;

import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.tc.JdbiTestcontainersExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Tag(value="slow")
@Testcontainers
@EnabledOnOs(architectures={"x86_64", "amd64"})
public class TestOutparameterCursor {
    static final String CONTAINER_VERSION = "gvenzl/oracle-xe:" + System.getProperty("oracle.container.version", "slim-faststart");
    @Container
    static OracleContainer oc = new OracleContainer(CONTAINER_VERSION);
    @RegisterExtension
    JdbiExtension oracleExtension = JdbiTestcontainersExtension.instance((JdbcDatabaseContainer)oc).withInitializer((ds, h) -> {
        h.execute("CREATE TABLE USERS (ID INTEGER, NAME VARCHAR(255))", new Object[0]);
        h.execute("INSERT INTO USERS VALUES (1, 'Alice')", new Object[0]);
        h.execute("INSERT INTO USERS VALUES (2, 'Bob')", new Object[0]);
        h.execute("CREATE OR REPLACE PROCEDURE get_user_by_name(\np_name IN USERS.NAME%TYPE,\no_c_dbuser OUT SYS_REFCURSOR) AS\nBEGIN\nOPEN o_c_dbuser FOR\nSELECT * FROM USERS WHERE NAME LIKE p_name || '%';\nEND;", new Object[0]);
    });

    @Test
    public void someTest() throws Exception {
        RowMapper userMapper = ConstructorMapper.of(User.class);
        try (Call call = ((Call)this.oracleExtension.getSharedHandle().createCall("call get_user_by_name(:a,:b)").bind("a", "Alice")).registerOutParameter("b", 2012);){
            List result = (List)call.invoke(outParameters -> outParameters.getRowSet("b").map(userMapper).list());
            ((ListAssert)((ListAssert)Assertions.assertThat((List)result).isNotNull()).hasSize(1)).contains((Object[])new User[]{new User(1, "Alice")});
        }
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.id == user.id && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }
    }
}

