/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.oracle12;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.oracle12.OracleReturning;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.tc.JdbiTestcontainersExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Tag(value="slow")
@Testcontainers
@EnabledOnOs(architectures={"x86_64", "amd64"})
public class TestOracleReturning {
    static final String CONTAINER_VERSION = "gvenzl/oracle-xe:" + System.getProperty("oracle.container.version", "slim-faststart");
    @Container
    static OracleContainer oc = new OracleContainer(CONTAINER_VERSION);
    @RegisterExtension
    public JdbiExtension oracleExtension = JdbiTestcontainersExtension.instance((JdbcDatabaseContainer)oc).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @BeforeEach
    public void beforeEach() {
        Handle handle = this.oracleExtension.getSharedHandle();
        handle.execute("create sequence something_id_sequence INCREMENT BY 1 START WITH 100", new Object[0]);
        handle.execute("create table something (name varchar(200), id int, constraint something_id primary key (id))", new Object[0]);
    }

    @Test
    public void testReturningDmlPositionalParams() {
        Handle h = this.oracleExtension.getSharedHandle();
        try (Update update = h.createUpdate("insert into something(id, name) values (?, ?) returning id into ?");){
            List ids = ((ResultBearing)((Update)((Update)((Update)update.bind(0, 17)).bind(1, "Brian")).addCustomizer((StatementCustomizer)OracleReturning.returnParameters().register(2, 4))).execute(OracleReturning.returningDml())).mapTo(Integer.TYPE).list();
            Assertions.assertThat((List)ids).containsExactly((Object[])new Integer[]{17});
        }
    }

    @Test
    public void testReturningDmlNamedParams() {
        Handle h = this.oracleExtension.getSharedHandle();
        try (Update update = h.createUpdate("insert into something(id, name) values (:id, :name) returning id into :result");){
            List ids = ((ResultBearing)((Update)((Update)update.bindBean((Object)new Something(20, "Brian"))).addCustomizer((StatementCustomizer)OracleReturning.returnParameters().register("result", 4))).execute(OracleReturning.returningDml())).mapTo(Integer.TYPE).list();
            Assertions.assertThat((List)ids).containsExactly((Object[])new Integer[]{20});
        }
    }
}

