/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.oracle12;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.tc.JdbiTestcontainersExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Tag(value="slow")
@Testcontainers
@EnabledOnOs(architectures={"x86_64", "amd64"})
public class TestGetGeneratedKeysOracle {
    static final String CONTAINER_VERSION = "gvenzl/oracle-xe:" + System.getProperty("oracle.container.version", "slim-faststart");
    @Container
    static OracleContainer oc = new OracleContainer(CONTAINER_VERSION);
    @RegisterExtension
    public JdbiExtension oracleExtension = JdbiTestcontainersExtension.instance((JdbcDatabaseContainer)oc).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @BeforeEach
    public void beforeEach() {
        Handle handle = this.oracleExtension.getSharedHandle();
        handle.execute("create sequence something_id_sequence INCREMENT BY 1 START WITH 100", new Object[0]);
        handle.execute("create table something (name varchar(200), id int, constraint something_id primary key (id))", new Object[0]);
    }

    @Test
    public void testGetGeneratedKeys() throws Exception {
        this.oracleExtension.getJdbi().useExtension(DAO.class, dao -> {
            Long fooId = dao.insert("Foo");
            long barId = dao.insert("Bar");
            Assertions.assertThat((String)dao.findNameById(fooId)).isEqualTo("Foo");
            Assertions.assertThat((String)dao.findNameById(barId)).isEqualTo("Bar");
        });
    }

    public static interface DAO {
        @SqlUpdate(value="insert into something (name, id) values (:name, something_id_sequence.nextval)")
        @GetGeneratedKeys(value={"id"})
        public long insert(@Bind(value="name") String var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind long var1);
    }

    public static class OracleGeneratedKeyMapper
    implements RowMapper<Long> {
        public Long map(ResultSet r, StatementContext ctx) throws SQLException {
            return r.getLong(1);
        }
    }
}

