/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.rest.client.ModelsClientResource;
import org.flowable.ui.admin.service.engine.JobService;
import org.flowable.ui.admin.service.engine.ProcessDefinitionService;
import org.flowable.ui.admin.service.engine.ProcessInstanceService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelsClientResource.class);
    @Autowired
    protected ProcessDefinitionService clientService;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected JobService jobService;
    @Autowired
    protected ObjectMapper objectMapper;

    @GetMapping(value={"/rest/admin/process-definitions/{definitionId}"}, produces={"application/json"})
    public JsonNode getProcessDefinition(@PathVariable String definitionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.clientService.getProcessDefinition(serverConfig, definitionId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting process definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PutMapping(value={"/rest/admin/process-definitions/{definitionId}"}, produces={"application/json"})
    public JsonNode updateProcessDefinitionCategory(@PathVariable String definitionId, @RequestBody ObjectNode updateBody) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        if (updateBody.has("category")) {
            try {
                String category = null;
                if (!updateBody.get("category").isNull()) {
                    category = updateBody.get("category").asText();
                }
                return this.clientService.updateProcessDefinitionCategory(serverConfig, definitionId, category);
            }
            catch (FlowableServiceException e) {
                LOGGER.error("Error updating process definition category {}", (Object)definitionId, (Object)e);
                throw new BadRequestException(e.getMessage());
            }
        }
        LOGGER.error("No required category found in request body");
        throw new BadRequestException("Category is required in body");
    }

    @GetMapping(value={"/rest/admin/process-definitions/{definitionId}/process-instances"}, produces={"application/json"})
    public JsonNode getProcessInstances(@PathVariable String definitionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            ObjectNode bodyNode = this.objectMapper.createObjectNode();
            bodyNode.put("processDefinitionId", definitionId);
            return this.processInstanceService.listProcesInstancesForProcessDefinition(bodyNode, serverConfig);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting process instances for process definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/process-definitions/{definitionId}/jobs"}, produces={"application/json"})
    public JsonNode getJobs(@PathVariable String definitionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.jobService.listJobs(serverConfig, Collections.singletonMap("processDefinitionId", new String[]{definitionId}));
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting jobs for process definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/process-definitions/{definitionId}/batch-migrate"})
    @ResponseStatus(value=HttpStatus.OK)
    public void migrateInstancesOfProcessDefinition(@PathVariable String definitionId, @RequestBody String migrationDocument) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            this.clientService.migrateInstancesOfProcessDefinition(serverConfig, definitionId, migrationDocument);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error migrating instances of process definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

