/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.ModelService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/admin/models"})
public class ModelsClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelsClientResource.class);
    @Autowired
    protected ModelService clientService;

    @GetMapping(produces={"application/json"})
    public JsonNode listModels(HttpServletRequest request) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        try {
            return this.clientService.listModels(serverConfig, parameterMap);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting models", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

