/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.external.shared.format.model.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentracing.Scope;
import io.opentracing.util.GlobalTracer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.collections.api.list.MutableList;
import org.finos.legend.engine.external.shared.format.model.ExternalFormatExtension;
import org.finos.legend.engine.external.shared.format.model.ExternalFormatExtensionLoader;
import org.finos.legend.engine.external.shared.format.model.api.ExternalFormatDescription;
import org.finos.legend.engine.external.shared.format.model.api.GenerateModelInput;
import org.finos.legend.engine.external.shared.format.model.api.GenerateSchemaInput;
import org.finos.legend.engine.external.shared.format.model.transformation.fromModel.ExternalFormatSchemaGenerationExtension;
import org.finos.legend.engine.external.shared.format.model.transformation.fromModel.ModelToSchemaGenerator;
import org.finos.legend.engine.external.shared.format.model.transformation.toModel.ExternalFormatModelGenerationExtension;
import org.finos.legend.engine.external.shared.format.model.transformation.toModel.SchemaToModelGenerator;
import org.finos.legend.engine.language.pure.compiler.toPureGraph.PureModel;
import org.finos.legend.engine.language.pure.modelManager.ModelManager;
import org.finos.legend.engine.protocol.pure.v1.model.context.PureModelContext;
import org.finos.legend.engine.protocol.pure.v1.model.context.PureModelContextData;
import org.finos.legend.engine.shared.core.ObjectMapperFactory;
import org.finos.legend.engine.shared.core.api.result.ManageConstantResult;
import org.finos.legend.engine.shared.core.identity.Identity;
import org.finos.legend.engine.shared.core.kerberos.ProfileManagerHelper;
import org.finos.legend.engine.shared.core.operational.errorManagement.EngineException;
import org.finos.legend.engine.shared.core.operational.errorManagement.ExceptionTool;
import org.finos.legend.engine.shared.core.operational.logs.ILoggingEventType;
import org.finos.legend.engine.shared.core.operational.logs.LogInfo;
import org.finos.legend.engine.shared.core.operational.logs.LoggingEventType;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jax.rs.annotations.Pac4JProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"External - Format"})
@Path(value="pure/v1/external/format")
@Produces(value={"application/json"})
public class ExternalFormats {
    private static final ObjectMapper objectMapper = ObjectMapperFactory.getNewStandardObjectMapperWithPureProtocolExtensionSupports();
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalFormats.class);
    static final Map<String, ExternalFormatExtension<?>> extensions = ExternalFormatExtensionLoader.extensions();
    private final ModelManager modelManager;

    public ExternalFormats(ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    @GET
    @Path(value="availableFormats")
    @ApiOperation(value="Get all external formats available")
    @Consumes(value={"application/json"})
    public Response codeGenerationDescriptions() {
        try {
            PureModel pureModel = (PureModel)this.modelManager.loadModelAndData((PureModelContext)PureModelContextData.newPureModelContextData(), null, Identity.getAnonymousIdentity(), null).getTwo();
            List descriptions = extensions.values().stream().map(ext -> ExternalFormatDescription.newDescription(ext, pureModel)).collect(Collectors.toList());
            return ManageConstantResult.manageResult((String)Identity.getAnonymousIdentity().getName(), descriptions);
        }
        catch (Exception ex) {
            return ExceptionTool.exceptionManager((Exception)ex, (LoggingEventType)LoggingEventType.EXTERNAL_FORMAT_ERROR, null);
        }
    }

    @POST
    @Path(value="generateModel")
    @ApiOperation(value="Generates a model from a schema for the external format")
    @Consumes(value={"application/json", "application/zlib"})
    public Response generateModel(GenerateModelInput generateModelInput, @ApiParam(hidden=true) @Pac4JProfileManager ProfileManager<CommonProfile> pm) {
        Response response;
        block9: {
            MutableList profiles = ProfileManagerHelper.extractProfiles(pm);
            Identity identity = Identity.makeIdentity((Object)profiles);
            boolean interactive = generateModelInput.model instanceof PureModelContextData;
            Scope scope = GlobalTracer.get().buildSpan("Service: Generate Model From External Format Schema").startActive(true);
            try {
                long start = System.currentTimeMillis();
                LOGGER.info(new LogInfo(identity.getName(), (ILoggingEventType)(interactive ? LoggingEventType.GENERATE_EXTERNAL_FORMAT_MODEL_INTERACTIVE_START : LoggingEventType.GENERATE_EXTERNAL_FORMAT_MODEL_START)).toString());
                ExternalFormatExtension<?> extension = extensions.get(generateModelInput.config.format);
                if (!(extension instanceof ExternalFormatModelGenerationExtension)) {
                    throw new UnsupportedOperationException("Model generation not supported for " + extension.getFormat());
                }
                PureModel pureModel = this.modelManager.loadModel(generateModelInput.model, generateModelInput.clientVersion, identity, null);
                SchemaToModelGenerator generator = new SchemaToModelGenerator(pureModel, generateModelInput.clientVersion, extensions);
                PureModelContextData generated = generator.generate(generateModelInput.config, generateModelInput.sourceSchemaSet, generateModelInput.generateBinding, generateModelInput.targetBindingPath);
                LOGGER.info(new LogInfo(identity.getName(), (ILoggingEventType)(interactive ? LoggingEventType.GENERATE_EXTERNAL_FORMAT_MODEL_INTERACTIVE_STOP : LoggingEventType.GENERATE_EXTERNAL_FORMAT_MODEL_STOP), (double)System.currentTimeMillis() - (double)start).toString());
                response = ManageConstantResult.manageResult((String)identity.getName(), (Object)generated, (ObjectMapper)objectMapper);
                if (scope == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return ExceptionTool.exceptionManager((Exception)ex, (LoggingEventType)(interactive ? LoggingEventType.GENERATE_EXTERNAL_FORMAT_MODEL_INTERACTIVE_ERROR : LoggingEventType.GENERATE_EXTERNAL_FORMAT_MODEL_ERROR), (String)identity.getName());
                }
            }
            scope.close();
        }
        return response;
    }

    @POST
    @Path(value="generateSchema")
    @ApiOperation(value="Generates a schema in an external format from a model")
    @Consumes(value={"application/json", "application/zlib"})
    public Response generateSchema(GenerateSchemaInput generateSchemaInput, @ApiParam(hidden=true) @Pac4JProfileManager ProfileManager<CommonProfile> pm) {
        Response response;
        block12: {
            MutableList profiles = ProfileManagerHelper.extractProfiles(pm);
            Identity identity = Identity.makeIdentity((Object)profiles);
            boolean interactive = generateSchemaInput.model instanceof PureModelContextData;
            Scope scope = GlobalTracer.get().buildSpan("Service: Generate Model From External Format Schema").startActive(true);
            try {
                long start = System.currentTimeMillis();
                LOGGER.info(new LogInfo(identity.getName(), (ILoggingEventType)(interactive ? LoggingEventType.GENERATE_EXTERNAL_FORMAT_SCHEMA_INTERACTIVE_START : LoggingEventType.GENERATE_EXTERNAL_FORMAT_SCHEMA_START)).toString());
                if (generateSchemaInput.config == null || generateSchemaInput.config.format == null) {
                    throw new EngineException("Please provide a Format");
                }
                ExternalFormatExtension<?> extension = extensions.get(generateSchemaInput.config.format);
                if (extension == null) {
                    throw new UnsupportedOperationException("Can't find an extension supporting the external format " + generateSchemaInput.config.format);
                }
                if (!(extension instanceof ExternalFormatSchemaGenerationExtension)) {
                    throw new UnsupportedOperationException("Schema generation not supported for " + extension.getFormat());
                }
                if (generateSchemaInput.model == null) {
                    throw new UnsupportedOperationException("Please provide a PureModelContext");
                }
                PureModel pureModel = this.modelManager.loadModel(generateSchemaInput.model, generateSchemaInput.clientVersion, identity, null);
                ModelToSchemaGenerator generator = new ModelToSchemaGenerator(pureModel, extensions);
                PureModelContextData generated = generator.generate(generateSchemaInput.config, generateSchemaInput.sourceModelUnit, generateSchemaInput.generateBinding, generateSchemaInput.targetBindingPath);
                LOGGER.info(new LogInfo(identity.getName(), (ILoggingEventType)(interactive ? LoggingEventType.GENERATE_EXTERNAL_FORMAT_SCHEMA_INTERACTIVE_STOP : LoggingEventType.GENERATE_EXTERNAL_FORMAT_SCHEMA_STOP), (double)System.currentTimeMillis() - (double)start).toString());
                response = ManageConstantResult.manageResult((String)identity.getName(), (Object)generated, (ObjectMapper)objectMapper);
                if (scope == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return ExceptionTool.exceptionManager((Exception)ex, (LoggingEventType)(interactive ? LoggingEventType.GENERATE_EXTERNAL_FORMAT_SCHEMA_INTERACTIVE_ERROR : LoggingEventType.GENERATE_EXTERNAL_FORMAT_SCHEMA_ERROR), (String)identity.getName());
                }
            }
            scope.close();
        }
        return response;
    }
}

