/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.external.shared.format.model.api;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.collections.api.RichIterable;
import org.finos.legend.engine.external.shared.format.generations.description.GenerationParameter;
import org.finos.legend.engine.external.shared.format.generations.description.GenerationProperty;
import org.finos.legend.engine.external.shared.format.model.ExternalFormatExtension;
import org.finos.legend.engine.external.shared.format.model.transformation.fromModel.ExternalFormatSchemaGenerationExtension;
import org.finos.legend.engine.external.shared.format.model.transformation.toModel.ExternalFormatModelGenerationExtension;
import org.finos.legend.engine.language.pure.compiler.toPureGraph.PureModel;
import org.finos.legend.pure.generated.Root_meta_pure_generation_metamodel_GenerationParameter;

public class ExternalFormatDescription {
    public String name;
    public List<String> contentTypes;
    public boolean supportsSchemaGeneration;
    public List<GenerationProperty> schemaGenerationProperties;
    public boolean supportsModelGeneration;
    public List<GenerationProperty> modelGenerationProperties;
    public boolean supportsBinding;

    public static ExternalFormatDescription newDescription(ExternalFormatExtension<?> extension, PureModel pureModel) {
        ExternalFormatDescription result = new ExternalFormatDescription();
        result.name = extension.getFormat();
        result.contentTypes = Collections.unmodifiableList(extension.getContentTypes());
        result.supportsModelGeneration = extension instanceof ExternalFormatModelGenerationExtension;
        result.modelGenerationProperties = result.supportsModelGeneration ? ExternalFormatDescription.toGenerationProperties((RichIterable<? extends Root_meta_pure_generation_metamodel_GenerationParameter>)((ExternalFormatModelGenerationExtension)extension).getModelGenerationProperties(pureModel)) : Collections.emptyList();
        result.supportsSchemaGeneration = extension instanceof ExternalFormatSchemaGenerationExtension;
        result.schemaGenerationProperties = result.supportsSchemaGeneration ? ExternalFormatDescription.toGenerationProperties((RichIterable<? extends Root_meta_pure_generation_metamodel_GenerationParameter>)((ExternalFormatSchemaGenerationExtension)extension).getSchemaGenerationProperties(pureModel)) : Collections.emptyList();
        result.supportsBinding = extension.supportsBinding();
        return result;
    }

    public static List<GenerationProperty> toGenerationProperties(RichIterable<? extends Root_meta_pure_generation_metamodel_GenerationParameter> props) {
        return props == null ? Collections.emptyList() : Collections.unmodifiableList(props.toList().stream().map(GenerationParameter::new).collect(Collectors.toList()));
    }
}

