/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.danilopianini.centralpublisher.api


import org.danilopianini.centralpublisher.impl.infrastructure.*
import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.client.request.forms.formData
import io.ktor.client.engine.HttpClientEngine
import kotlinx.serialization.json.Json
import io.ktor.http.ParametersBuilder
import kotlinx.serialization.*
import kotlinx.serialization.descriptors.*
import kotlinx.serialization.encoding.*

open class PublishingApi : ApiClient {

    constructor(
        baseUrl: String = ApiClient.BASE_URL,
        httpClientEngine: HttpClientEngine? = null,
        httpClientConfig: ((HttpClientConfig<*>) -> Unit)? = null,
        jsonSerializer: Json = ApiClient.JSON_DEFAULT
    ) : super(baseUrl = baseUrl, httpClientEngine = httpClientEngine, httpClientConfig = httpClientConfig, jsonBlock = jsonSerializer)

    constructor(
        baseUrl: String,
        httpClient: HttpClient
    ): super(baseUrl = baseUrl, httpClient = httpClient)

    /**
     * 
     * Drop a deployment. Deployments can be dropped if they are in a &#x60;FAILED&#x60; or &#x60;VALIDATED&#x60; state. 
     * @param deploymentId The deployment identifier, which was obtained by a call to &#x60;/api/v1/publisher/upload&#x60;.
     * @return void
     */
    open suspend fun apiV1PublisherDeploymentDeploymentIdDelete(deploymentId: kotlin.String): HttpResponse<Unit> {

        val localVariableAuthNames = listOf<String>("BasicAuth", "BearerAuth")

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.DELETE,
            "/api/v1/publisher/deployment/{deploymentId}".replace("{" + "deploymentId" + "}", "$deploymentId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames
        ).wrap()
    }


    /**
     * 
     * Publish a deployment. Deployments can be published if they are in a &#x60;VALIDATED&#x60; state. 
     * @param deploymentId The deployment identifier, which was obtained by a call to &#x60;/api/v1/publisher/upload&#x60;.
     * @return void
     */
    open suspend fun apiV1PublisherDeploymentDeploymentIdPost(deploymentId: kotlin.String): HttpResponse<Unit> {

        val localVariableAuthNames = listOf<String>("BasicAuth", "BearerAuth")

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.POST,
            "/api/v1/publisher/deployment/{deploymentId}".replace("{" + "deploymentId" + "}", "$deploymentId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames
        ).wrap()
    }


    /**
     * 
     * Retrieve status of a deployment. Polling this endpoint can be useful for determining when a deployment changes state.
     * @param id The deployment identifier, which was obtained by a call to &#x60;/api/v1/publisher/upload&#x60;.
     * @return kotlin.String
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun apiV1PublisherStatusPost(id: kotlin.String): HttpResponse<kotlin.String> {

        val localVariableAuthNames = listOf<String>("BasicAuth", "BearerAuth")

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        id?.apply { localVariableQuery["id"] = listOf("$id") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.POST,
            "/api/v1/publisher/status",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames
        ).wrap()
    }



    /**
     * enum for parameter publishingType
     */
    @Serializable
    enum class PublishingTypeApiV1PublisherUploadPost(val value: kotlin.String) {
        
        @SerialName(value = "USER_MANAGED")
        USER_MANAGED("USER_MANAGED"),
        
        @SerialName(value = "AUTOMATIC")
        AUTOMATIC("AUTOMATIC")
        
    }

    /**
     * 
     * Upload a deployment bundle intended to be published to Maven Central.
     * @param name Deployment/bundle name, optional (will use attached file name if not present). (optional)
     * @param publishingType Whether to have the deployment stop in the &#x60;VALIDATED&#x60; state and require a user to log in and manually approve its progression, or to automatically go directly to &#x60;PUBLISHING&#x60; when validation has passed. (optional)
     * @param bundle  (optional)
     * @return kotlin.String
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun apiV1PublisherUploadPost(name: kotlin.String? = null, publishingType: PublishingTypeApiV1PublisherUploadPost? = null, bundle: io.ktor.client.request.forms.InputProvider? = null): HttpResponse<kotlin.String> {

        val localVariableAuthNames = listOf<String>("BasicAuth", "BearerAuth")

        val localVariableBody = 
            formData {
                bundle?.apply {
                    append(
                        "bundle",
                        bundle,
                        io.ktor.http.Headers.build {
                            append(io.ktor.http.HttpHeaders.ContentDisposition, "filename=\"$name\"")
                        }
                    )
                }
            }

        val localVariableQuery = mutableMapOf<String, List<String>>()
        name?.apply { localVariableQuery["name"] = listOf("$name") }
        publishingType?.apply { localVariableQuery["publishingType"] = listOf("${ publishingType.value }") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.POST,
            "/api/v1/publisher/upload",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
        )

        return multipartFormRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames
        ).wrap()
    }


}
