/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.reflect.Field;
import org.apache.logging.log4j.util.Unbox;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;
import org.junit.jupiter.api.parallel.ResourceLock;

@EnabledIfSystemProperty(named="test", matches=".*Unbox2ConfigurableTest.*")
@ResourceLock(value="java.lang.System.properties")
public class Unbox2ConfigurableTest {
    @BeforeAll
    public static void beforeClass() {
        System.setProperty("log4j.unbox.ringbuffer.size", "65");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        System.clearProperty("log4j.unbox.ringbuffer.size");
        Field field = Unbox.class.getDeclaredField("RINGBUFFER_SIZE");
        field.setAccessible(true);
        Field modifierField = Field.class.getDeclaredField("modifiers");
        modifierField.setAccessible(true);
        modifierField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, 32);
        Field threadLocalField = Unbox.class.getDeclaredField("threadLocalState");
        threadLocalField.setAccessible(true);
        ThreadLocal threadLocal = (ThreadLocal)threadLocalField.get(null);
        threadLocal.remove();
        threadLocalField.set(null, new ThreadLocal());
    }

    @Test
    public void testBoxConfiguredTo128Slots() {
        Assertions.assertEquals((int)128, (int)Unbox.getRingbufferSize());
    }

    @Test
    public void testBoxSuccessfullyConfiguredTo128Slots() {
        int MAX = 128;
        StringBuilder[] probe = new StringBuilder[384];
        int i = 0;
        while (i <= probe.length - 8) {
            probe[i++] = Unbox.box((boolean)true);
            probe[i++] = Unbox.box((char)'c');
            probe[i++] = Unbox.box((byte)127);
            probe[i++] = Unbox.box((double)Double.MAX_VALUE);
            probe[i++] = Unbox.box((float)Float.MAX_VALUE);
            probe[i++] = Unbox.box((int)Integer.MAX_VALUE);
            probe[i++] = Unbox.box((long)Long.MAX_VALUE);
            probe[i++] = Unbox.box((short)Short.MAX_VALUE);
        }
        for (i = 0; i < probe.length - 128; ++i) {
            Assertions.assertSame((Object)probe[i], (Object)probe[i + 128], (String)("probe[" + i + "], probe[" + (i + 128) + "]"));
            for (int j = 1; j < 127; ++j) {
                Assertions.assertNotSame((Object)probe[i], (Object)probe[i + j], (String)("probe[" + i + "], probe[" + (i + j) + "]"));
            }
        }
    }
}

