/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.FilePermission;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.Permission;
import org.apache.logging.log4j.junit.SecurityManagerTestRule;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.SecurityManager")
public class PropertyFilePropertySourceSecurityManagerIT {
    @Rule
    public final SecurityManagerTestRule rule = new SecurityManagerTestRule(new TestSecurityManager());
    private static final String TEST_FIXTURE_PATH = "src/test/resources/PropertiesUtilTest.properties";

    @BeforeClass
    public static void beforeClass() {
        Assert.assertTrue((String)TEST_FIXTURE_PATH, (boolean)Files.exists(Paths.get(TEST_FIXTURE_PATH, new String[0]), new LinkOption[0]));
    }

    @Test
    public void test() {
        PropertiesUtil propertiesUtil = new PropertiesUtil(TEST_FIXTURE_PATH);
        Assert.assertNull((Object)propertiesUtil.getStringProperty("a.1"));
    }

    private static class TestSecurityManager
    extends SecurityManager {
        private TestSecurityManager() {
        }

        @Override
        public void checkPermission(Permission permission) {
            if (permission instanceof FilePermission && permission.getName().endsWith(PropertyFilePropertySourceSecurityManagerIT.TEST_FIXTURE_PATH)) {
                throw new SecurityException();
            }
        }
    }
}

