/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.message.ThreadDumpMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadDumpMessageTest {
    @Test
    public void testMessage() {
        ThreadDumpMessage msg = new ThreadDumpMessage("Testing");
        String message = msg.getFormattedMessage();
        Assertions.assertTrue((boolean)message.contains("Testing"), (String)"No header");
        Assertions.assertTrue((boolean)message.contains("RUNNABLE"), (String)"No RUNNABLE");
        Assertions.assertTrue((boolean)message.contains("ThreadDumpMessage"), (String)"No ThreadDumpMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageWithLocks() throws Exception {
        ThreadDumpMessage msg;
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        Thread1 thread1 = new Thread1(lock);
        thread1.start();
        ThreadDumpMessageTest threadDumpMessageTest = this;
        synchronized (threadDumpMessageTest) {
            Thread2 thread2 = new Thread2(this);
            thread2.start();
            try {
                Thread.sleep(200L);
                msg = new ThreadDumpMessage("Testing");
            }
            finally {
                lock.unlock();
            }
        }
        String message = msg.getFormattedMessage();
        Assertions.assertTrue((boolean)message.contains("Testing"), (String)"No header");
        Assertions.assertTrue((boolean)message.contains("RUNNABLE"), (String)"No RUNNABLE");
        Assertions.assertTrue((boolean)message.contains("ThreadDumpMessage"), (String)"No ThreadDumpMessage");
    }

    @Test
    public void testToString() {
        ThreadDumpMessage msg = new ThreadDumpMessage("Test");
        String actual = msg.toString();
        Assertions.assertTrue((boolean)actual.contains("Test"));
        Assertions.assertTrue((boolean)actual.contains("RUNNABLE"));
        Assertions.assertTrue((boolean)actual.contains(this.getClass().getName()));
    }

    @Test
    public void testUseConstructorThread() throws InterruptedException {
        final ThreadDumpMessage msg = new ThreadDumpMessage("Test");
        final AtomicReference actual = new AtomicReference();
        Thread other = new Thread("OtherThread"){

            @Override
            public void run() {
                actual.set(msg.getFormattedMessage());
            }
        };
        other.start();
        other.join();
        Assertions.assertFalse((boolean)((String)actual.get()).contains("OtherThread"), (String)"No mention of other thread in msg");
    }

    @Test
    public void formatTo_usesCachedMessageString() throws Exception {
        ThreadDumpMessage message = new ThreadDumpMessage("");
        String initial = message.getFormattedMessage();
        Assertions.assertFalse((boolean)initial.contains("ThreadWithCountDownLatch"), (String)"no ThreadWithCountDownLatch thread yet");
        CountDownLatch started = new CountDownLatch(1);
        CountDownLatch keepAlive = new CountDownLatch(1);
        ThreadWithCountDownLatch thread = new ThreadWithCountDownLatch(started, keepAlive);
        thread.start();
        started.await();
        StringBuilder result = new StringBuilder();
        message.formatTo(result);
        Assertions.assertFalse((boolean)result.toString().contains("ThreadWithCountDownLatch"), (String)"no ThreadWithCountDownLatch captured");
        Assertions.assertEquals((Object)initial, (Object)result.toString());
        keepAlive.countDown();
    }

    private static class ThreadWithCountDownLatch
    extends Thread {
        private final CountDownLatch started;
        private final CountDownLatch keepAlive;
        volatile boolean finished;

        public ThreadWithCountDownLatch(CountDownLatch started, CountDownLatch keepAlive) {
            super("ThreadWithCountDownLatch");
            this.started = started;
            this.keepAlive = keepAlive;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.started.countDown();
            try {
                this.keepAlive.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.finished = true;
        }
    }

    private static class Thread2
    extends Thread {
        private final Object obj;

        public Thread2(Object obj) {
            this.obj = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.obj;
            synchronized (object) {
            }
        }
    }

    private static class Thread1
    extends Thread {
        private final ReentrantLock lock;

        public Thread1(ReentrantLock lock) {
            this.lock = lock;
        }

        @Override
        public void run() {
            this.lock.lock();
            this.lock.unlock();
        }
    }
}

