/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.junit.StatusLoggerLevel;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

class StatusLoggerLevelExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final String KEY = "previousLevel";

    StatusLoggerLevelExtension() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        StatusLoggerLevel annotation = context.getRequiredTestClass().getAnnotation(StatusLoggerLevel.class);
        if (annotation == null) {
            return;
        }
        StatusLogger logger = StatusLogger.getLogger();
        this.getStore(context).put((Object)KEY, (Object)logger.getLevel());
        logger.setLevel(Level.valueOf((String)annotation.value()));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        StatusLogger.getLogger().setLevel((Level)this.getStore(context).get((Object)KEY, Level.class));
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestInstance()}));
    }
}

