/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.apache.logging.log4j.message.ReusableParameterizedMessageTest;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TraceLoggingTest
extends AbstractLogger {
    static final StringBuilder CHAR_SEQ = new StringBuilder("CharSeq");
    private int charSeqCount;
    private int objectCount;
    private static final long serialVersionUID = 1L;
    private static Level currentLevel;
    private LogEvent currentEvent;
    private static Throwable t;
    private static Class<AbstractLogger> obj;
    private static String pattern;
    private static String p1;
    private static String p2;
    private static Message charSeq;
    private static Message simple;
    private static Message object;
    private static Message param;
    private static String marker;

    public Level getLevel() {
        return currentLevel;
    }

    public boolean isEnabled(Level level, Marker marker, Message data, Throwable t) {
        return true;
    }

    public boolean isEnabled(Level level, Marker marker, CharSequence data, Throwable t) {
        ++this.charSeqCount;
        return this.isEnabled(level, marker, (Message)new SimpleMessage(data), t);
    }

    public boolean isEnabled(Level level, Marker marker, Object data, Throwable t) {
        ++this.objectCount;
        return this.isEnabled(level, marker, (Message)new ObjectMessage(data), t);
    }

    public boolean isEnabled(Level level, Marker marker, String data) {
        return this.isEnabled(level, marker, (Message)new SimpleMessage(data), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String data, Object ... p1) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(data, p1), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, p0), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, p0, p1), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6, p7}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6, p7, p8}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(message, new Object[]{p0, p1, p2, p3, p4, p5, p6, p7, p8, p9}), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String data, Throwable t) {
        return this.isEnabled(level, marker, (Message)new SimpleMessage(data), t);
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message data, Throwable t) {
        Assertions.assertEquals((Object)level, (Object)currentLevel, (String)("Incorrect Level. Expected " + currentLevel + ", actual " + level));
        if (marker == null) {
            if (this.currentEvent.markerName != null) {
                Assertions.fail((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual is null"));
            }
        } else if (this.currentEvent.markerName == null) {
            Assertions.fail((String)("Incorrect marker. Expected null. Actual is " + marker.getName()));
        } else {
            Assertions.assertEquals((Object)this.currentEvent.markerName, (Object)marker.getName(), (String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual " + marker.getName()));
        }
        if (data == null) {
            if (this.currentEvent.data != null) {
                Assertions.fail((String)("Incorrect message. Expected " + this.currentEvent.data + ", actual is null"));
            }
        } else if (this.currentEvent.data == null) {
            Assertions.fail((String)("Incorrect message. Expected null. Actual is " + data.getFormattedMessage()));
        } else {
            Assertions.assertTrue((boolean)data.getClass().isAssignableFrom(this.currentEvent.data.getClass()), (String)("Incorrect message type. Expected " + this.currentEvent.data + ", actual " + data));
            Assertions.assertEquals((Object)this.currentEvent.data.getFormattedMessage(), (Object)data.getFormattedMessage(), (String)("Incorrect message. Expected " + this.currentEvent.data.getFormattedMessage() + ", actual " + data.getFormattedMessage()));
        }
        if (t == null) {
            if (this.currentEvent.t != null) {
                Assertions.fail((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual is null"));
            }
        } else if (this.currentEvent.t == null) {
            Assertions.fail((String)("Incorrect Throwable. Expected null. Actual is " + t));
        } else {
            Assertions.assertEquals((Object)this.currentEvent.t, (Object)t, (String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual " + t));
        }
    }

    @Test
    public void testTraceEntryExit() {
        currentLevel = Level.TRACE;
        DefaultFlowMessageFactory fact = new DefaultFlowMessageFactory();
        ParameterizedMessage paramMsg = new ParameterizedMessage("Tracy {}", (Object)"Logan");
        this.currentEvent = new LogEvent(ENTRY_MARKER.getName(), (Message)fact.newEntryMessage((Message)paramMsg), null);
        EntryMessage entry = this.traceEntry("Tracy {}", new Object[]{"Logan"});
        ReusableParameterizedMessage msg = ReusableParameterizedMessageTest.set(new ReusableParameterizedMessage(), "Tracy {}", "Logan");
        ReusableParameterizedMessageTest.set(msg, "Some other message {}", 123);
        this.currentEvent = new LogEvent(null, (Message)msg, null);
        this.trace("Some other message {}", 123);
        Assertions.assertEquals((Object)"Tracy Logan", (Object)entry.getMessage().getFormattedMessage());
        this.currentEvent = new LogEvent(EXIT_MARKER.getName(), (Message)fact.newExitMessage(entry), null);
        this.traceExit(entry);
        Assertions.assertEquals((Object)"Tracy Logan", (Object)entry.getMessage().getFormattedMessage());
    }

    @Test
    public void testTraceEntryMessage() {
        currentLevel = Level.TRACE;
        DefaultFlowMessageFactory fact = new DefaultFlowMessageFactory();
        ParameterizedMessage paramMsg = new ParameterizedMessage("Tracy {}", (Object)"Logan");
        this.currentEvent = new LogEvent(ENTRY_MARKER.getName(), (Message)fact.newEntryMessage((Message)paramMsg), null);
        ReusableParameterizedMessage msg = ReusableParameterizedMessageTest.set(new ReusableParameterizedMessage(), "Tracy {}", "Logan");
        EntryMessage entry = this.traceEntry((Message)msg);
        ReusableParameterizedMessageTest.set(msg, "Some other message {}", 123);
        this.currentEvent = new LogEvent(null, (Message)msg, null);
        this.trace("Some other message {}", 123);
        Assertions.assertEquals((Object)"Tracy Logan", (Object)entry.getMessage().getFormattedMessage());
        this.currentEvent = new LogEvent(EXIT_MARKER.getName(), (Message)fact.newExitMessage(entry), null);
        this.traceExit(entry);
        Assertions.assertEquals((Object)"Tracy Logan", (Object)entry.getMessage().getFormattedMessage());
    }

    static {
        t = new UnsupportedOperationException("Test");
        obj = AbstractLogger.class;
        pattern = "{}, {}";
        p1 = "Long Beach";
        p2 = "California";
        charSeq = new SimpleMessage((CharSequence)CHAR_SEQ);
        simple = new SimpleMessage("Hello");
        object = new ObjectMessage(obj);
        param = new ParameterizedMessage(pattern, (Object)p1, (Object)p2);
        marker = "TEST";
    }

    private static class LogEvent {
        String markerName;
        Message data;
        Throwable t;

        public LogEvent(String markerName, Message data, Throwable t) {
            this.markerName = markerName;
            this.data = data;
            this.t = t;
        }
    }
}

