/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextUtilityClass;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@UsingAnyThreadContext
@ResourceLock(value="java.lang.System.properties")
public class ThreadContextInheritanceTest {
    @BeforeAll
    public static void setupClass() {
        System.setProperty("isThreadContextMapInheritable", "true");
        ThreadContext.init();
    }

    @AfterAll
    public static void tearDownClass() {
        System.clearProperty("isThreadContextMapInheritable");
        ThreadContext.init();
    }

    @Test
    public void testPush() {
        ThreadContext.push((String)"Hello");
        ThreadContext.push((String)"{} is {}", (Object[])new Object[]{ThreadContextInheritanceTest.class.getSimpleName(), "running"});
        Assertions.assertEquals((Object)ThreadContext.pop(), (Object)"ThreadContextInheritanceTest is running", (String)"Incorrect parameterized stack value");
        Assertions.assertEquals((Object)ThreadContext.pop(), (Object)"Hello", (String)"Incorrect simple stack value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInheritanceSwitchedOn() throws Exception {
        System.setProperty("isThreadContextMapInheritable", "true");
        ThreadContext.init();
        try {
            ThreadContext.clearMap();
            ThreadContext.put((String)"Greeting", (String)"Hello");
            StringBuilder sb = new StringBuilder();
            TestThread thread = new TestThread(sb);
            thread.start();
            thread.join();
            String str = sb.toString();
            Assertions.assertEquals((Object)"Hello", (Object)str, (String)("Unexpected ThreadContext value. Expected Hello. Actual " + str));
            sb = new StringBuilder();
            thread = new TestThread(sb);
            thread.start();
            thread.join();
            str = sb.toString();
            Assertions.assertEquals((Object)"Hello", (Object)str, (String)("Unexpected ThreadContext value. Expected Hello. Actual " + str));
        }
        finally {
            System.clearProperty("isThreadContextMapInheritable");
        }
    }

    @Test
    @Tag(value="performance")
    public void perfTest() {
        ThreadContextUtilityClass.perfTest();
    }

    @Test
    public void testGetContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetContextReturnsEmptyMapIfEmpty();
    }

    @Test
    public void testGetContextReturnsMutableCopy() {
        ThreadContextUtilityClass.testGetContextReturnsMutableCopy();
    }

    @Test
    public void testGetImmutableContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsEmptyMapIfEmpty();
    }

    @Test
    public void testGetImmutableContextReturnsImmutableMapIfNonEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfNonEmpty();
    }

    @Test
    public void testGetImmutableContextReturnsImmutableMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfEmpty();
    }

    @Test
    public void testGetImmutableStackReturnsEmptyStackIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableStackReturnsEmptyStackIfEmpty();
    }

    @Test
    public void testPut() {
        ThreadContextUtilityClass.testPut();
    }

    @Test
    public void testRemove() {
        ThreadContext.clearMap();
        Assertions.assertNull((Object)ThreadContext.get((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assertions.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assertions.assertNull((Object)ThreadContext.get((String)"testKey"));
        Assertions.assertTrue((boolean)ThreadContext.isEmpty());
    }

    @Test
    public void testContainsKey() {
        ThreadContext.clearMap();
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assertions.assertTrue((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
    }

    private static class TestThread
    extends Thread {
        private final StringBuilder sb;

        public TestThread(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void run() {
            String greeting = ThreadContext.get((String)"Greeting");
            if (greeting == null) {
                this.sb.append("null");
            } else {
                this.sb.append(greeting);
            }
            ThreadContext.clearMap();
        }
    }
}

