/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.ThreadContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
public class CloseableThreadContextTest {
    private final String key = "key";
    private final String value = "value";

    @BeforeEach
    @AfterEach
    void clearThreadContext() {
        ThreadContext.clearAll();
    }

    @Test
    public void shouldAddAnEntryToTheMap() {
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
        }
    }

    @Test
    public void shouldAddTwoEntriesToTheMap() {
        String key2 = "key2";
        String value2 = "value2";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value").put("key2", "value2");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
            Assertions.assertEquals((Object)"value2", (Object)ThreadContext.get((String)"key2"));
        }
    }

    @Test
    public void shouldNestEntries() {
        String oldValue = "oldValue";
        String innerValue = "innerValue";
        ThreadContext.put((String)"key", (String)"oldValue");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
            try (CloseableThreadContext.Instance ignored2 = CloseableThreadContext.put((String)"key", (String)"innerValue");){
                Assertions.assertNotNull((Object)ignored2);
                Assertions.assertEquals((Object)"innerValue", (Object)ThreadContext.get((String)"key"));
            }
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
        }
        Assertions.assertEquals((Object)"oldValue", (Object)ThreadContext.get((String)"key"));
    }

    @Test
    public void shouldPreserveOldEntriesFromTheMapWhenAutoClosed() {
        String oldValue = "oldValue";
        ThreadContext.put((String)"key", (String)"oldValue");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
        }
        Assertions.assertEquals((Object)"oldValue", (Object)ThreadContext.get((String)"key"));
    }

    @Test
    public void ifTheSameKeyIsAddedTwiceTheOriginalShouldBeUsed() {
        String oldValue = "oldValue";
        String secondValue = "innerValue";
        ThreadContext.put((String)"key", (String)"oldValue");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value").put("key", "innerValue");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"innerValue", (Object)ThreadContext.get((String)"key"));
        }
        Assertions.assertEquals((Object)"oldValue", (Object)ThreadContext.get((String)"key"));
    }

    @Test
    public void shouldPushAndPopAnEntryToTheStack() {
        String message = "message";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.push((String)"message");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"message", (Object)ThreadContext.peek());
        }
        Assertions.assertEquals((Object)"", (Object)ThreadContext.peek());
    }

    @Test
    public void shouldPushAndPopTwoEntriesToTheStack() {
        String message1 = "message1";
        String message2 = "message2";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.push((String)"message1").push("message2");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"message2", (Object)ThreadContext.peek());
        }
        Assertions.assertEquals((Object)"", (Object)ThreadContext.peek());
    }

    @Test
    public void shouldPushAndPopAParameterizedEntryToTheStack() {
        String parameterizedMessage = "message {}";
        String parameterizedMessageParameter = "param";
        String formattedMessage = "message {}".replace("{}", "param");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.push((String)"message {}", (Object[])new Object[]{"param"});){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)formattedMessage, (Object)ThreadContext.peek());
        }
        Assertions.assertEquals((Object)"", (Object)ThreadContext.peek());
    }

    @Test
    public void shouldRemoveAnEntryFromTheMapWhenAutoClosed() {
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
        }
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"key"));
    }

    @Test
    public void shouldAddEntriesToBothStackAndMap() {
        String stackValue = "something";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value").push("something");){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
            Assertions.assertEquals((Object)"something", (Object)ThreadContext.peek());
        }
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"key"));
        Assertions.assertEquals((Object)"", (Object)ThreadContext.peek());
    }

    @Test
    public void canReuseCloseableThreadContext() {
        String stackValue = "something";
        CloseableThreadContext.Instance ctc = CloseableThreadContext.push((String)"something").put("key", "value");
        Assertions.assertNotNull((Object)ctc);
        Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
        Assertions.assertEquals((Object)"something", (Object)ThreadContext.peek());
        ctc.close();
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"key"));
        Assertions.assertEquals((Object)"", (Object)ThreadContext.peek());
        String anotherKey = "key2";
        String anotherValue = "value2";
        String anotherStackValue = "something else";
        ctc.push("something else").put("key2", "value2");
        Assertions.assertEquals((Object)"value2", (Object)ThreadContext.get((String)"key2"));
        Assertions.assertEquals((Object)"something else", (Object)ThreadContext.peek());
        ctc.close();
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"key2"));
        Assertions.assertEquals((Object)"", (Object)ThreadContext.peek());
    }

    @Test
    public void closeIsIdempotent() {
        String originalMapValue = "map to keep";
        String originalStackValue = "stack to keep";
        ThreadContext.put((String)"key", (String)"map to keep");
        ThreadContext.push((String)"stack to keep");
        String newMapValue = "temp map value";
        String newStackValue = "temp stack to keep";
        CloseableThreadContext.Instance ctc = CloseableThreadContext.push((String)"temp stack to keep").put("key", "temp map value");
        Assertions.assertNotNull((Object)ctc);
        ctc.close();
        Assertions.assertEquals((Object)"map to keep", (Object)ThreadContext.get((String)"key"));
        Assertions.assertEquals((Object)"stack to keep", (Object)ThreadContext.peek());
        ctc.close();
        Assertions.assertEquals((Object)"map to keep", (Object)ThreadContext.get((String)"key"));
        Assertions.assertEquals((Object)"stack to keep", (Object)ThreadContext.peek());
    }

    @Test
    public void putAllWillPutAllValues() {
        String oldValue = "oldValue";
        ThreadContext.put((String)"key", (String)"oldValue");
        HashMap<String, String> valuesToPut = new HashMap<String, String>();
        valuesToPut.put("key", "value");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.putAll(valuesToPut);){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"value", (Object)ThreadContext.get((String)"key"));
        }
        Assertions.assertEquals((Object)"oldValue", (Object)ThreadContext.get((String)"key"));
    }

    @Test
    public void pushAllWillPushAllValues() {
        ThreadContext.push((String)"key");
        List messages = ThreadContext.getImmutableStack().asList();
        ThreadContext.pop();
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.pushAll((List)messages);){
            Assertions.assertNotNull((Object)ignored);
            Assertions.assertEquals((Object)"key", (Object)ThreadContext.peek());
        }
        Assertions.assertEquals((Object)"", (Object)ThreadContext.peek());
    }
}

