/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.Unbox;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Unbox1Test {
    @BeforeClass
    public static void beforeClass() {
        System.clearProperty("log4j.unbox.ringbuffer.size");
    }

    @Test
    public void testBoxClaimsItHas32Slots() throws Exception {
        Assert.assertEquals((long)32L, (long)Unbox.getRingbufferSize());
    }

    @Test
    public void testBoxHas32Slots() throws Exception {
        int MAX = 32;
        StringBuilder[] probe = new StringBuilder[96];
        int i = 0;
        while (i <= probe.length - 8) {
            probe[i++] = Unbox.box((boolean)true);
            probe[i++] = Unbox.box((char)'c');
            probe[i++] = Unbox.box((byte)127);
            probe[i++] = Unbox.box((double)Double.MAX_VALUE);
            probe[i++] = Unbox.box((float)Float.MAX_VALUE);
            probe[i++] = Unbox.box((int)Integer.MAX_VALUE);
            probe[i++] = Unbox.box((long)Long.MAX_VALUE);
            probe[i++] = Unbox.box((short)Short.MAX_VALUE);
        }
        for (i = 0; i < probe.length - 32; ++i) {
            Assert.assertSame((String)("probe[" + i + "], probe[" + (i + 32) + "]"), (Object)probe[i], (Object)probe[i + 32]);
            for (int j = 1; j < 31; ++j) {
                Assert.assertNotSame((String)("probe[" + i + "], probe[" + (i + j) + "]"), (Object)probe[i], (Object)probe[i + j]);
            }
        }
    }

    @Test
    public void testBoxBoolean() throws Exception {
        Assert.assertEquals((Object)"true", (Object)Unbox.box((boolean)true).toString());
        Assert.assertEquals((Object)"false", (Object)Unbox.box((boolean)false).toString());
    }

    @Test
    public void testBoxByte() throws Exception {
        Assert.assertEquals((Object)"0", (Object)Unbox.box((byte)0).toString());
        Assert.assertEquals((Object)"1", (Object)Unbox.box((byte)1).toString());
        Assert.assertEquals((Object)"127", (Object)Unbox.box((byte)127).toString());
        Assert.assertEquals((Object)"-1", (Object)Unbox.box((byte)-1).toString());
        Assert.assertEquals((Object)"-128", (Object)Unbox.box((byte)-128).toString());
    }

    @Test
    public void testBoxChar() throws Exception {
        Assert.assertEquals((Object)"a", (Object)Unbox.box((char)'a').toString());
        Assert.assertEquals((Object)"b", (Object)Unbox.box((char)'b').toString());
        Assert.assertEquals((Object)"\u5b57", (Object)Unbox.box((char)'\u5b57').toString());
    }

    @Test
    public void testBoxDouble() throws Exception {
        Assert.assertEquals((Object)"3.14", (Object)Unbox.box((double)3.14).toString());
        Assert.assertEquals((Object)new Double(Double.MAX_VALUE).toString(), (Object)Unbox.box((double)Double.MAX_VALUE).toString());
        Assert.assertEquals((Object)new Double(Double.MIN_VALUE).toString(), (Object)Unbox.box((double)Double.MIN_VALUE).toString());
    }

    @Test
    public void testBoxFloat() throws Exception {
        Assert.assertEquals((Object)"3.14", (Object)Unbox.box((float)3.14f).toString());
        Assert.assertEquals((Object)new Float(Float.MAX_VALUE).toString(), (Object)Unbox.box((float)Float.MAX_VALUE).toString());
        Assert.assertEquals((Object)new Float(Float.MIN_VALUE).toString(), (Object)Unbox.box((float)Float.MIN_VALUE).toString());
    }

    @Test
    public void testBoxInt() throws Exception {
        Assert.assertEquals((Object)"0", (Object)Unbox.box((int)0).toString());
        Assert.assertEquals((Object)"1", (Object)Unbox.box((int)1).toString());
        Assert.assertEquals((Object)"127", (Object)Unbox.box((int)127).toString());
        Assert.assertEquals((Object)"-1", (Object)Unbox.box((int)-1).toString());
        Assert.assertEquals((Object)"-128", (Object)Unbox.box((int)-128).toString());
        Assert.assertEquals((Object)new Integer(Integer.MAX_VALUE).toString(), (Object)Unbox.box((int)Integer.MAX_VALUE).toString());
        Assert.assertEquals((Object)new Integer(Integer.MIN_VALUE).toString(), (Object)Unbox.box((int)Integer.MIN_VALUE).toString());
    }

    @Test
    public void testBoxLong() throws Exception {
        Assert.assertEquals((Object)"0", (Object)Unbox.box((long)0L).toString());
        Assert.assertEquals((Object)"1", (Object)Unbox.box((long)1L).toString());
        Assert.assertEquals((Object)"127", (Object)Unbox.box((long)127L).toString());
        Assert.assertEquals((Object)"-1", (Object)Unbox.box((long)-1L).toString());
        Assert.assertEquals((Object)"-128", (Object)Unbox.box((long)-128L).toString());
        Assert.assertEquals((Object)new Long(Long.MAX_VALUE).toString(), (Object)Unbox.box((long)Long.MAX_VALUE).toString());
        Assert.assertEquals((Object)new Long(Long.MIN_VALUE).toString(), (Object)Unbox.box((long)Long.MIN_VALUE).toString());
    }

    @Test
    public void testBoxShort() throws Exception {
        Assert.assertEquals((Object)"0", (Object)Unbox.box((short)0).toString());
        Assert.assertEquals((Object)"1", (Object)Unbox.box((short)1).toString());
        Assert.assertEquals((Object)"127", (Object)Unbox.box((short)127).toString());
        Assert.assertEquals((Object)"-1", (Object)Unbox.box((short)-1).toString());
        Assert.assertEquals((Object)"-128", (Object)Unbox.box((short)-128).toString());
        Assert.assertEquals((Object)new Short(Short.MAX_VALUE).toString(), (Object)Unbox.box((short)Short.MAX_VALUE).toString());
        Assert.assertEquals((Object)new Short(Short.MIN_VALUE).toString(), (Object)Unbox.box((short)Short.MIN_VALUE).toString());
    }

    @Test
    public void testBoxIsThreadLocal() throws Exception {
        final StringBuilder[] probe = new StringBuilder[48];
        this.populate(0, probe);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                Unbox1Test.this.populate(16, probe);
            }
        };
        t1.start();
        t1.join();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                Unbox1Test.this.populate(16, probe);
            }
        };
        t2.start();
        t2.join();
        for (int i = 0; i < probe.length - 16; ++i) {
            for (int j = 1; j < 16; ++j) {
                Assert.assertNotSame((String)("probe[" + i + "]=" + probe[i] + ", probe[" + (i + j) + "]=" + probe[i + j]), (Object)probe[i], (Object)probe[i + j]);
            }
        }
    }

    private void populate(int start, StringBuilder[] probe) {
        int i = start;
        while (i <= start + 8) {
            probe[i++] = Unbox.box((boolean)true);
            probe[i++] = Unbox.box((char)'c');
            probe[i++] = Unbox.box((byte)127);
            probe[i++] = Unbox.box((double)Double.MAX_VALUE);
            probe[i++] = Unbox.box((float)Float.MAX_VALUE);
            probe[i++] = Unbox.box((int)Integer.MAX_VALUE);
            probe[i++] = Unbox.box((long)Long.MAX_VALUE);
            probe[i++] = Unbox.box((short)Short.MAX_VALUE);
        }
    }
}

