/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertiesUtilTest {
    private final Properties properties = new Properties();

    @Before
    public void setUp() throws Exception {
        this.properties.load(ClassLoader.getSystemResourceAsStream("PropertiesUtilTest.properties"));
    }

    @Test
    public void testExtractSubset() throws Exception {
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"a"));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"b."));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"c.1"));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"dd"));
        Assert.assertEquals((long)0L, (long)this.properties.size());
    }

    @Test
    public void testPartitionOnCommonPrefix() throws Exception {
        Map parts = PropertiesUtil.partitionOnCommonPrefixes((Properties)this.properties);
        Assert.assertEquals((long)4L, (long)parts.size());
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("a"));
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("b"));
        PropertiesUtilTest.assertHasAllProperties((Properties)PropertiesUtil.partitionOnCommonPrefixes((Properties)((Properties)parts.get("c"))).get("1"));
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("dd"));
    }

    private static void assertHasAllProperties(Properties properties) {
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((Object)"1", (Object)properties.getProperty("1"));
        Assert.assertEquals((Object)"2", (Object)properties.getProperty("2"));
        Assert.assertEquals((Object)"3", (Object)properties.getProperty("3"));
    }

    @Test
    public void testGetCharsetProperty() throws Exception {
        Properties p = new Properties();
        p.setProperty("e.1", StandardCharsets.US_ASCII.name());
        p.setProperty("e.2", "wrong-charset-name");
        PropertiesUtil pu = new PropertiesUtil(p);
        Assert.assertEquals((Object)Charset.defaultCharset(), (Object)pu.getCharsetProperty("e.0"));
        Assert.assertEquals((Object)StandardCharsets.US_ASCII, (Object)pu.getCharsetProperty("e.1"));
        Assert.assertEquals((Object)Charset.defaultCharset(), (Object)pu.getCharsetProperty("e.2"));
    }

    @Test
    public void testGetMappedProperty_sun_stdout_encoding() {
        PropertiesUtil pu = new PropertiesUtil(System.getProperties());
        Charset expected = System.console() == null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
        Assert.assertEquals((Object)expected, (Object)pu.getCharsetProperty("sun.stdout.encoding"));
    }

    @Test
    public void testGetMappedProperty_sun_stderr_encoding() {
        PropertiesUtil pu = new PropertiesUtil(System.getProperties());
        Charset expected = System.console() == null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
        Assert.assertEquals((Object)expected, (Object)pu.getCharsetProperty("sun.err.encoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonStringSystemProperties() {
        String key1 = "1";
        Object key2 = new Object();
        System.getProperties().put(key1, new Object());
        System.getProperties().put(key2, "value-2");
        try {
            PropertiesUtil util = new PropertiesUtil(new Properties());
            Assert.assertNull((Object)util.getStringProperty("1"));
        }
        finally {
            System.getProperties().remove(key1);
            System.getProperties().remove(key2);
        }
    }

    @Test
    public void testPublish() {
        Properties props = new Properties();
        PropertiesUtil util = new PropertiesUtil(props);
        String value = System.getProperty("Application");
        Assert.assertNotNull((String)"System property was not published", (Object)value);
        Assert.assertEquals((Object)"Log4j", (Object)value);
    }
}

