/*
 * Decompiled with CFR 0.152.
 */
package hdfs;

import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class MiniHDFS {
    private static String PORT_FILE_NAME = "ports";
    private static String PID_FILE_NAME = "pid";

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("MiniHDFS <baseDirectory>");
        }
        Path baseDir = Paths.get(args[0], new String[0]);
        if (System.getenv("HADOOP_HOME") == null) {
            Path hadoopHome = baseDir.resolve("hadoop-home");
            Files.createDirectories(hadoopHome, new FileAttribute[0]);
            System.setProperty("hadoop.home.dir", hadoopHome.toAbsolutePath().toString());
        }
        Path hdfsHome = baseDir.resolve("hdfs-data");
        Configuration cfg = new Configuration();
        cfg.set("hdfs.minidfs.basedir", hdfsHome.toAbsolutePath().toString());
        cfg.set("dfs.datanode.data.dir.perm", "766");
        MiniDFSCluster dfs = new MiniDFSCluster.Builder(cfg).nameNodePort(9999).build();
        Path tmp = Files.createTempFile(baseDir, null, null, new FileAttribute[0]);
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        Files.write(tmp, pid.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(tmp, baseDir.resolve(PID_FILE_NAME), StandardCopyOption.ATOMIC_MOVE);
        tmp = Files.createTempFile(baseDir, null, null, new FileAttribute[0]);
        Files.write(tmp, Integer.toString(dfs.getNameNodePort()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(tmp, baseDir.resolve(PORT_FILE_NAME), StandardCopyOption.ATOMIC_MOVE);
    }
}

