/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import oracle.ons.Notification;
import oracle.ons.OutputBuffer;
import oracle.ons.SubscriptionException;

public class SubscriptionNotification {
    protected int subsid;
    protected String subscription;
    protected Object lock;
    protected boolean waiter;
    protected SubscriptionException ex;
    protected boolean success;
    private boolean replyrecvd;
    private static byte[] subsmessageline = new byte[26];
    private static byte[] subsidheader;
    private static byte[] subsheader;
    private static byte[] contentlengthline;

    protected SubscriptionNotification(int n, String string, boolean bl) {
        this.subsid = n;
        this.subscription = string;
        this.waiter = bl;
        this.ex = null;
        this.success = false;
        this.replyrecvd = false;
        this.lock = this.waiter ? new Object() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForReply(long l) throws SubscriptionException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.replyrecvd) {
                    if (l <= 0L) {
                        this.lock.wait();
                    } else {
                        this.lock.wait(l);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l >= 0L && !this.replyrecvd) {
            throw new SubscriptionException("Subscription request timed out after " + l + " millseconds.  Possible causes: OPMN may not be running, you may have an OPMN running in an alternate ORACLE_HOME using duplicate port values, or OPMN may be misconfigured.");
        }
        if (!this.success) {
            if (this.ex != null) {
                throw this.ex;
            }
            throw new SubscriptionException("Subscription failed for unknown reason");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeup(boolean bl, SubscriptionException subscriptionException) {
        this.success = bl;
        this.ex = subscriptionException;
        if (this.waiter) {
            Object object = this.lock;
            synchronized (object) {
                this.replyrecvd = true;
                this.lock.notifyAll();
            }
        }
    }

    protected void send(OutputBuffer outputBuffer) throws IOException {
        outputBuffer.putBytes(subsmessageline, subsmessageline.length);
        outputBuffer.putBytes(contentlengthline, contentlengthline.length);
        outputBuffer.putBytes(subsidheader, subsidheader.length);
        String string = Integer.toString(this.subsid);
        outputBuffer.putBytes(string.getBytes(), string.length());
        outputBuffer.putBytes(Notification.crlf, 2);
        outputBuffer.putBytes(subsheader, subsheader.length);
        if (this.subscription != null && this.subscription.length() > 0) {
            outputBuffer.putBytes(this.subscription.getBytes(), this.subscription.length());
        }
        outputBuffer.putBytes(Notification.crlf, 2);
        outputBuffer.putBytes(Notification.crlf, 2);
        outputBuffer.flush();
    }

    static {
        System.arraycopy(new String("POST /subscribe HTTP/1.1").getBytes(), 0, subsmessageline, 0, 24);
        System.arraycopy(Notification.crlf, 0, subsmessageline, 24, 2);
        subsidheader = new String("SubscriberID: ").getBytes();
        subsheader = new String("Subscription: ").getBytes();
        contentlengthline = new byte[19];
        System.arraycopy(new String("Content-Length: 0").getBytes(), 0, contentlengthline, 0, 17);
        System.arraycopy(Notification.crlf, 0, contentlengthline, 17, 2);
    }
}

