/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.CallBack;
import oracle.ons.CallBackThread;
import oracle.ons.Notification;
import oracle.ons.NotificationQueue;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.SubscribePermission;
import oracle.ons.SubscriptionException;

public class Subscriber {
    private String subscription;
    private String component;
    private Publisher pub;
    private ONS oems;
    private boolean closed;
    private int id;
    private NotificationQueue queue;
    private CallBack cb;
    private int cbmode;
    private Object cblock;
    private int numcbthreads;
    private CallBackThread cbthread;
    public static final int CBMODE_ONETHREAD = 1;
    public static final int CBMODE_THREADPERCB = 2;

    public Subscriber(String string, String string2) throws SubscriptionException, ONSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.oems = ONS.getONS();
        this.realStartup(string, string2, -1L);
    }

    public Subscriber(String string, String string2, long l) throws SubscriptionException, ONSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.oems = ONS.getONS();
        this.realStartup(string, string2, l);
    }

    Subscriber(ONS oNS, String string, String string2) {
        this.oems = oNS;
        this.realStartup(string, string2, -1L);
    }

    Subscriber(ONS oNS, String string, String string2, long l) {
        this.oems = oNS;
        this.realStartup(string, string2, l);
    }

    private void realStartup(String string, String string2, long l) {
        this.subscription = string;
        this.pub = new Publisher(this.oems, string2);
        this.component = string2;
        this.closed = false;
        this.id = -1;
        this.queue = new NotificationQueue();
        this.oems.addSubscriber(this, l);
        this.cb = null;
        this.cbmode = 0;
        this.cblock = new Object();
        this.numcbthreads = 0;
    }

    public Publisher getPublisher() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PublishPermission("ONSUser"));
        }
        return this.pub;
    }

    public Notification receive(boolean bl) {
        return (Notification)this.queue.dequeue(bl);
    }

    public Notification receive(long l) {
        return (Notification)this.queue.dequeue(l);
    }

    public void close() {
        if (this.cb != null) {
            this.cancel_callback();
        }
        this.closed = true;
        this.oems.removeSubscriber(this.id);
        this.pub.close();
        this.queue.close();
    }

    public void relinquish(Notification notification) {
    }

    public String subscription() {
        return this.subscription;
    }

    public String component() {
        return this.component;
    }

    public int id() {
        return this.id;
    }

    protected void setID(int n) {
        this.id = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliver(Notification notification) {
        if (this.cb != null && this.cbmode == 2) {
            CallBackThread callBackThread = new CallBackThread(this, this.cb, notification);
            Object object = this.cblock;
            synchronized (object) {
                --this.numcbthreads;
            }
            callBackThread.start();
        } else {
            this.queue.enqueue(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_callback(CallBack callBack, int n) throws SubscriptionException {
        if (this.cb != null) {
            throw new SubscriptionException("Callback object already registered");
        }
        this.cb = callBack;
        this.cbmode = n;
        if (n == 1) {
            this.cbthread = new CallBackThread(this, callBack);
            Object object = this.cblock;
            synchronized (object) {
                --this.numcbthreads;
            }
            this.cbthread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel_callback() throws SubscriptionException {
        int n;
        if (this.cb == null) {
            throw new SubscriptionException("No callback object registered");
        }
        this.cb = null;
        if (this.cbmode == 1) {
            this.cbthread.set_shutdown();
        }
        Object object = this.cblock;
        synchronized (object) {
            n = this.numcbthreads;
        }
        while (n > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = this.cblock;
            synchronized (object) {
                n = this.numcbthreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cbthread_exit() {
        Object object = this.cblock;
        synchronized (object) {
            --this.numcbthreads;
        }
    }
}

