/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.net.Socket;
import oracle.ons.Notification;
import oracle.ons.NotificationQueue;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.ReceiverThread;
import oracle.ons.SendElement;
import oracle.ons.SubscriptionNotification;

public class SenderThread
extends Thread {
    private ONS oems;
    private ReceiverThread r;
    private boolean shutdown = false;
    private NotificationQueue q;

    protected SenderThread(ONS oNS, ReceiverThread receiverThread, NotificationQueue notificationQueue) {
        this.setDaemon(true);
        this.oems = oNS;
        this.r = receiverThread;
        this.q = notificationQueue != null ? notificationQueue : new NotificationQueue();
        receiverThread.registerSender(this);
    }

    public void run() {
        Socket socket = null;
        while (!this.shutdown) {
            SendElement sendElement = (SendElement)this.q.dequeue(true);
            if (ONS.debug) {
                ONS.outstream.println("SenderThread::run ==> have an event, se=" + sendElement);
            }
            if (sendElement == null) continue;
            Socket socket2 = this.r.getSocket();
            if (ONS.debug) {
                ONS.outstream.println("SenderThread::run ==> have a socket, s=" + socket2);
            }
            if (socket2 == null) {
                this.q.push(sendElement);
                continue;
            }
            if (socket2 != socket) {
                this.q.push(sendElement);
                sendElement = (SendElement)this.q.dequeue(true);
                if (sendElement == null) continue;
            }
            socket = socket2;
            try {
                if (ONS.debug) {
                    ONS.outstream.println("SenderThread::run ==> about to send event");
                }
                if (sendElement.e != null) {
                    sendElement.e.send(new OutputBuffer(socket2.getOutputStream()));
                    continue;
                }
                if (sendElement.s == null) continue;
                sendElement.s.send(new OutputBuffer(socket2.getOutputStream()));
            }
            catch (IOException iOException) {
                if (ONS.debug) {
                    ONS.errstream.println("SenderThread::run caught exception trying to send");
                    iOException.printStackTrace(ONS.errstream);
                }
                this.q.push(sendElement);
            }
        }
    }

    protected void send(Notification notification) {
        SendElement sendElement = new SendElement(notification);
        if (ONS.debug) {
            ONS.outstream.println("SenderThread::send ==> queueing event e=" + notification);
        }
        this.q.enqueue(sendElement);
    }

    protected void send(SubscriptionNotification subscriptionNotification) {
        SendElement sendElement = new SendElement(subscriptionNotification);
        if (ONS.debug) {
            ONS.outstream.println("SenderThread::send ==> queueing SubscriptionNotification e=" + subscriptionNotification);
        }
        this.q.enqueue(sendElement);
    }

    protected void send(SubscriptionNotification subscriptionNotification, int n) {
        SendElement sendElement = new SendElement(subscriptionNotification);
        if (ONS.debug) {
            ONS.outstream.println("SenderThread::send ==> pushing SubscriptionNotification e=" + subscriptionNotification + " with priority " + n);
        }
        this.q.push(sendElement, n);
    }

    protected void shutdown() {
        try {
            this.q.drain_and_close();
            this.shutdown = true;
        }
        catch (Exception exception) {
            ONS.errstream.println("Exception occured shutting down sender thread");
            exception.printStackTrace(ONS.errstream);
        }
    }

    protected boolean isReady() {
        return this.r.s != null;
    }

    void stopThread() {
        this.shutdown = true;
        this.interrupt();
    }

    NotificationQueue getSenderQueue() {
        SendElement sendElement;
        NotificationQueue notificationQueue = new NotificationQueue();
        while ((sendElement = (SendElement)this.q.dequeue(false)) != null) {
            if (sendElement.e == null) continue;
            notificationQueue.enqueue(sendElement);
        }
        return notificationQueue;
    }
}

