/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import oracle.ons.InputBuffer;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.SenderThread;
import oracle.ons.ServerElement;
import oracle.security.pki.OracleWallet;

public class ReceiverThread
extends Thread {
    private String hostname;
    private int port;
    protected Socket s;
    private ONS oems;
    private ServerElement se;
    private boolean shutdown = false;
    private Object socketlock;
    private int waiters;
    private SenderThread sender;
    private boolean firstconnection;
    private static byte[] connectmessage = new String("POST /connect HTTP/1.1\r\nVersion: 3\r\nFormFactor: ").getBytes();
    private static byte[] endconnect = new String("\r\n\r\n").getBytes();

    protected void registerSender(SenderThread senderThread) {
        this.sender = senderThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket getSocket() {
        Socket socket = null;
        if (this.shutdown) {
            return null;
        }
        Object object = this.socketlock;
        synchronized (object) {
            while (!this.shutdown && this.s == null) {
                try {
                    ++this.waiters;
                    this.socketlock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --this.waiters;
            }
            socket = this.s;
        }
        return socket;
    }

    protected ReceiverThread(String string, int n, ServerElement serverElement, ONS oNS) {
        this.setDaemon(true);
        this.oems = oNS;
        this.se = serverElement;
        this.hostname = string;
        this.port = n;
        this.socketlock = new Object();
        this.firstconnection = true;
        this.establishConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection() {
        this.s = null;
        Socket socket = null;
        try {
            if (this.oems.walletfile == null) {
                socket = new Socket(this.hostname, this.port);
            } else {
                if (ONS.debug) {
                    ONS.outstream.println("ReceiverThread::establishConnection ==> Using SSL, walletfile is " + this.oems.walletfile);
                }
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                OracleWallet oracleWallet = new OracleWallet();
                oracleWallet.open(this.oems.walletfile, this.oems.password);
                KeyStore keyStore = oracleWallet.getKeyStore();
                keyManagerFactory.init(keyStore, this.oems.password);
                trustManagerFactory.init(keyStore);
                sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                socket = sSLSocketFactory.createSocket(this.hostname, this.port);
            }
            OutputStream outputStream = socket.getOutputStream();
            OutputBuffer outputBuffer = new OutputBuffer(outputStream);
            outputBuffer.putBytes(connectmessage, connectmessage.length);
            if (ONS.localConn) {
                outputBuffer.putString(ONS.readFormFactor(this.oems.oraclehome));
            }
            outputBuffer.putBytes(endconnect, endconnect.length);
            outputBuffer.flush();
            InputBuffer inputBuffer = new InputBuffer(socket.getInputStream());
            inputBuffer.getNextString();
            inputBuffer.getNextString();
            inputBuffer.getNextString();
            inputBuffer.getNextString();
            inputBuffer.getNextString();
            inputBuffer.getNextString();
            inputBuffer.skipBytes(Notification.clusteridheader.length);
            this.oems.clusterid = inputBuffer.getNextString();
            inputBuffer.skipBytes(Notification.clusternameheader.length);
            this.oems.clustername = inputBuffer.getNextString();
            inputBuffer.skipBytes(Notification.instanceidheader.length);
            this.oems.instanceid = inputBuffer.getNextString();
            inputBuffer.skipBytes(Notification.instancenameheader.length);
            this.oems.instancename = inputBuffer.getNextString();
            inputBuffer.getNextString();
        }
        catch (Exception exception) {
            if (ONS.debug) {
                ONS.errstream.println("Caught exception in ReceiverThread::establishConnection");
                exception.printStackTrace(ONS.errstream);
            }
            if (this.s != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            socket = null;
            this.s = null;
        }
        if (socket != null) {
            if (!this.firstconnection) {
                this.oems.resendSubscriptions(this.sender);
            }
            this.firstconnection = false;
            Object object = this.socketlock;
            synchronized (object) {
                this.s = socket;
                if (this.waiters > 0) {
                    this.socketlock.notify();
                }
            }
        }
    }

    public void run() {
        InputStream inputStream = null;
        InputBuffer inputBuffer = null;
        while (!this.shutdown) {
            if (this.s != null) {
                try {
                    inputStream = this.s.getInputStream();
                    inputBuffer = new InputBuffer(inputStream);
                }
                catch (Exception exception) {
                    if (ONS.debug) {
                        ONS.errstream.println("Exception occured getting InputStream in ReceiverThread::run");
                        exception.printStackTrace(ONS.errstream);
                    }
                    return;
                }
            }
            while (!this.shutdown && this.s != null) {
                String string;
                boolean bl = false;
                try {
                    string = inputBuffer.getNextString();
                    if (ONS.debug) {
                        ONS.outstream.println("ReceiverThread::run ==> returned from getNextString, line=" + string);
                    }
                    if (string == null || string.charAt(0) != 'P' || string.charAt(1) != 'O' || string.charAt(2) != 'S' || string.charAt(3) != 'T' || string.charAt(4) != ' ') {
                        if (!ONS.debug) continue;
                        ONS.outstream.println("Got unexpected message start ==> " + string);
                        continue;
                    }
                }
                catch (IOException iOException) {
                    if (ONS.debug) {
                        ONS.errstream.println("Exception occured reading from InputStream");
                        iOException.printStackTrace(ONS.errstream);
                    }
                    try {
                        this.s.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.s = null;
                    bl = true;
                    string = null;
                }
                if (bl) continue;
                if (string.charAt(6) == 's' && string.charAt(7) == 't' && string.charAt(8) == 'a' && string.charAt(9) == 't' && string.charAt(10) == 'u' && string.charAt(11) == 's') {
                    if (this.readStatusMessage(inputBuffer)) continue;
                    this.s = null;
                    continue;
                }
                if (string.charAt(6) != 'e' || string.charAt(7) != 'v' || string.charAt(8) != 'e' || string.charAt(9) != 'n' || string.charAt(10) != 't') continue;
                Notification notification = this.readNotificationMessage(inputBuffer);
                if (ONS.debug) {
                    ONS.outstream.println("ReceiverThread::run ==> have an event, ev=" + notification);
                }
                if (notification != null) {
                    if (ONS.debug) {
                        ONS.outstream.println("ReceiverThread::run ==> about to deliver event");
                    }
                    this.oems.deliver(notification);
                    continue;
                }
                try {
                    this.s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.s = null;
            }
            long l = 500L;
            while (this.s == null && !this.shutdown) {
                this.establishConnection();
                if (this.s != null) continue;
                try {
                    ReceiverThread.sleep(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l >= 10000L || (l *= 2L) <= 10000L) continue;
                l = 10000L;
            }
        }
    }

    protected void shutdown() {
        block2: {
            try {
                this.shutdown = true;
                this.interrupt();
            }
            catch (Exception exception) {
                if (!ONS.debug) break block2;
                ONS.errstream.println("Exception occured shutting down receiver thread");
                exception.printStackTrace(ONS.errstream);
            }
        }
    }

    private boolean readStatusMessage(InputBuffer inputBuffer) {
        boolean bl = true;
        int n = -1;
        boolean bl2 = false;
        String string = null;
        try {
            String string2 = inputBuffer.getNextString();
            while (string2 != null) {
                int n2 = string2.indexOf(58);
                if (n2 != -1) {
                    String string3 = string2.substring(0, n2);
                    String string4 = string2.substring(n2 + 2);
                    if (string3.equalsIgnoreCase("result")) {
                        bl2 = string4.equalsIgnoreCase("success");
                    } else if (string3.equalsIgnoreCase("subscriberid")) {
                        try {
                            n = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (ONS.debug) {
                                ONS.errstream.println("ReceiverThread.readStatusMessage ==> Caught exception");
                                numberFormatException.printStackTrace(ONS.errstream);
                            }
                            n = -1;
                        }
                    } else if (string3.equalsIgnoreCase("message")) {
                        string = string4;
                    }
                }
                string2 = inputBuffer.getNextString();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (n == -1) {
            bl = false;
        }
        if (bl) {
            this.oems.handleSubscriptionReply(n, bl2, string);
        }
        return bl;
    }

    private Notification readNotificationMessage(InputBuffer inputBuffer) {
        Notification notification;
        try {
            notification = new Notification(inputBuffer);
        }
        catch (IOException iOException) {
            if (ONS.debug) {
                ONS.errstream.println("ReceiverThread.readNotificationMessage ==> Exception occurred");
                iOException.printStackTrace(ONS.errstream);
            }
            notification = null;
        }
        return notification;
    }

    SenderThread getSenderThread() {
        return this.sender;
    }

    boolean isReady() {
        return this.s != null;
    }

    ServerElement getServer() {
        return this.se;
    }
}

