/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;

public class Publisher {
    private String component;
    private ONS oems;
    private Object lock;
    private int eventId;
    private int id;
    private String idString;

    public Publisher(String string) throws ONSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PublishPermission("ONSUser"));
        }
        this.oems = ONS.getONS();
        this.realStartup(string);
    }

    Publisher(ONS oNS, String string) {
        this.oems = oNS;
        this.realStartup(string);
    }

    private void realStartup(String string) {
        this.component = string;
        this.lock = new Object();
        this.eventId = 1;
        this.oems.addPublisher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Notification notification) {
        int n;
        Object object = this.lock;
        synchronized (object) {
            n = this.eventId++;
        }
        notification.generatingComponent = this.component;
        notification.generatingNode = this.oems.hostname();
        notification.generatingProcess = this.oems.processId();
        notification.id = this.idString + new Integer(n);
        notification.creationTime = System.currentTimeMillis();
        this.oems.publish(notification);
    }

    public void close() {
        this.oems.removePublisher(this);
    }

    public int id() {
        return this.id;
    }

    protected void id(int n) {
        this.id = n;
        this.idString = this.oems.processId() + new Integer(n).toString();
    }
}

