/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import oracle.ons.InputBuffer;
import oracle.ons.Notification;
import oracle.ons.NotificationProperty;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.PropertyElement;

public class PropertyList {
    PropertyElement head;
    int numelems;

    protected PropertyList() {
        this.head = null;
        this.numelems = 0;
    }

    protected PropertyList(int n, InputBuffer inputBuffer) throws IOException {
        this.numelems = 0;
        this.head = null;
        for (int i = 0; i < n; ++i) {
            String string = inputBuffer.getNextString();
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 2);
            this.put(string2, string3);
        }
    }

    protected void put(String string, String string2) {
        PropertyElement propertyElement = new PropertyElement(string, string2);
        if (this.head == null) {
            this.head = propertyElement;
        } else {
            propertyElement.next = this.head;
            this.head = propertyElement;
        }
        ++this.numelems;
    }

    protected String get(String string) {
        String string2 = null;
        PropertyElement propertyElement = this.head;
        while (propertyElement != null && string2 == null) {
            if (propertyElement.name.equals(string)) {
                string2 = propertyElement.value;
                continue;
            }
            propertyElement = propertyElement.next;
        }
        return string2;
    }

    protected void write(OutputBuffer outputBuffer) throws IOException {
        PropertyElement propertyElement = this.head;
        while (propertyElement != null) {
            outputBuffer.putString(propertyElement.name);
            outputBuffer.putBytes(Notification.headerseparator, 2);
            outputBuffer.putString(propertyElement.value);
            outputBuffer.putBytes(Notification.crlf, 2);
            propertyElement = propertyElement.next;
        }
    }

    protected NotificationProperty[] getAll() {
        NotificationProperty[] notificationPropertyArray = null;
        int n = 0;
        PropertyElement propertyElement = this.head;
        if (this.numelems > 0) {
            notificationPropertyArray = new NotificationProperty[this.numelems];
            while (propertyElement != null) {
                notificationPropertyArray[n] = new NotificationProperty(propertyElement.name, propertyElement.value);
                ++n;
                propertyElement = propertyElement.next;
            }
        }
        return notificationPropertyArray;
    }

    protected int num() {
        return this.numelems;
    }

    protected void print() {
        PropertyElement propertyElement = this.head;
        while (propertyElement != null) {
            ONS.outstream.println("PROPERTY ==> " + propertyElement.name + " = " + propertyElement.value);
            propertyElement = propertyElement.next;
        }
    }
}

