/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.io.OutputStream;
import oracle.ons.ONS;

public class OutputBuffer {
    private static final int BUFFERSIZE = 1024;
    private OutputStream ostr;
    private byte[] buffer;
    private int spaceleft;
    private int position;

    protected OutputBuffer(OutputStream outputStream) {
        this.ostr = outputStream;
        this.buffer = new byte[1024];
        this.spaceleft = 1024;
        this.position = 0;
    }

    protected void putBytes(byte[] byArray, int n) throws IOException {
        if (this.spaceleft >= n) {
            System.arraycopy(byArray, 0, this.buffer, this.position, n);
            this.spaceleft -= n;
            this.position += n;
        } else if (n > 1024) {
            if (this.position > 0) {
                this.ostr.write(this.buffer, 0, this.position);
            }
            this.position = 0;
            this.spaceleft = 1024;
            this.ostr.write(byArray, 0, n);
        } else {
            System.arraycopy(byArray, 0, this.buffer, this.position, this.spaceleft);
            this.ostr.write(this.buffer, 0, 1024);
            System.arraycopy(byArray, this.spaceleft, this.buffer, 0, n - this.spaceleft);
            this.position = n - this.spaceleft;
            this.spaceleft = 1024 - this.position;
        }
    }

    protected void putString(String string) throws IOException {
        this.putBytes(string.getBytes(), string.length());
    }

    protected void putByte(byte by) throws IOException {
        if (this.spaceleft == 0) {
            this.ostr.write(this.buffer, 0, 1024);
            this.spaceleft = 1024;
            this.position = 0;
        }
        this.buffer[this.position] = by;
        ++this.position;
        --this.spaceleft;
    }

    protected void flush() throws IOException {
        if (ONS.debug) {
            ONS.outstream.println("OutputBuffer.flush ==> position=" + this.position);
        }
        if (this.position > 0) {
            this.ostr.write(this.buffer, 0, this.position);
        }
        this.ostr.flush();
        this.position = 0;
        this.spaceleft = 1024;
        if (ONS.debug) {
            ONS.outstream.println("OutputBuffer.flush ==> leaving method, no exceptions");
        }
    }
}

