/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.BodyBlock;
import oracle.ons.ComponentCallBack;
import oracle.ons.HeaderBlock;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Publisher;

public class OpmnNotifier
implements Runnable {
    private final String ONS_READY_EVENT = "IAS/PM/PROC_READY";
    private final String ONS_FIRST_EVENT = "OPMFirst";
    private final String OPMN_ID = "OPMN_UID";
    private final String UMP_UID = "-1";
    private String onsComponentName;
    private String opmnId;
    private int pingInterval = 10000;
    private boolean localOnly = false;
    private ComponentCallBack compCb = null;
    private Object notifCbData = null;
    private boolean threadShutdown = false;
    private Thread notifThread = null;

    public OpmnNotifier(String string, String string2) {
        this(string, string2, 10, false, null, null);
    }

    public OpmnNotifier(String string, String string2, int n, boolean bl, ComponentCallBack componentCallBack, Object object) {
        this.onsComponentName = string;
        this.opmnId = string2;
        this.compCb = componentCallBack;
        this.notifCbData = object;
        this.localOnly = bl;
        if (n > 0) {
            this.pingInterval = n * 1000;
        }
    }

    public String getComponentName() {
        return this.onsComponentName;
    }

    public void startup() throws IllegalThreadStateException {
        if (this.notifThread != null) {
            return;
        }
        this.notifThread = new Thread((Runnable)this, "OpmnNotifier");
        this.notifThread.setDaemon(true);
        this.notifThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        if (this.onsComponentName == null || this.opmnId == null) {
            if (ONS.debug) {
                ONS.errstream.println("ComponentName or OPMNID is NULL");
            }
            return;
        }
        Publisher publisher = new Publisher(this.onsComponentName);
        while (!this.threadShutdown) {
            BodyBlock bodyBlock = new BodyBlock();
            HeaderBlock headerBlock = new HeaderBlock();
            if (this.compCb != null) {
                this.compCb.OpmnCallback(bodyBlock, headerBlock, this.notifCbData);
            }
            byte[] byArray = bodyBlock.generateBody();
            Notification notification = new Notification("IAS/PM/PROC_READY", "", "", byArray);
            headerBlock.setHeader(notification);
            if (!this.opmnId.equals("-1")) {
                notification.setProperty("OPMN_UID", this.opmnId);
            }
            if (bl) {
                bl = false;
                notification.setProperty("OPMFirst", "true");
            } else {
                notification.setProperty("OPMFirst", "false");
            }
            if (this.localOnly) {
                notification.setLocalOnly();
            }
            publisher.publish(notification);
            OpmnNotifier opmnNotifier = this;
            synchronized (opmnNotifier) {
                if (!this.threadShutdown) {
                    try {
                        this.wait(this.pingInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        publisher.close();
        this.notifThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        OpmnNotifier opmnNotifier = this;
        synchronized (opmnNotifier) {
            this.threadShutdown = true;
            this.notifyAll();
        }
    }
}

