/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.ons.CreatePermission;
import oracle.ons.InputBuffer;
import oracle.ons.MonitorThread;
import oracle.ons.Notification;
import oracle.ons.NotificationInformation;
import oracle.ons.NotificationQueue;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.ReceiverThread;
import oracle.ons.SenderThread;
import oracle.ons.ServerElement;
import oracle.ons.SubscribePermission;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;
import oracle.ons.SubscriptionNotification;

public class ONS {
    private static Object lock = new Object();
    private static ONS myoems = null;
    private Hashtable subscribers;
    private Hashtable pendingSubscriptions;
    private HashMap notifications;
    private int subscriberId;
    private int publisherId;
    private int numPublishers;
    private int currentSenderIndex;
    private int lastServerIndex;
    private long startTime;
    private long lastCleanupTime;
    private String processId;
    private String hostname;
    private static String configFile;
    private static boolean isSharedInstall;
    private static String hostNameSuffix;
    private ReceiverThread receiver;
    private SenderThread sender;
    private MonitorThread monitor;
    private List receivers;
    private List senders;
    private List serverList;
    private int maxconnections = 3;
    private int connections;
    protected String walletfile = null;
    protected char[] password = null;
    protected String clusterid;
    protected String clustername;
    protected String instanceid;
    protected String instancename;
    protected String oraclehome;
    protected static boolean debug;
    protected static boolean localConn;
    protected static PrintStream outstream;
    protected static PrintStream errstream;
    protected static int shutdowntimeout;
    protected static int notificationtimeout;
    protected static final String ONS_SSL_CONTEXT_PROTOCOL = "SSL";
    protected static final String ONS_SSL_KEY_MANAGEMENT = "SunX509";
    protected static final String ONS_NODES = "nodes=";
    protected static final String ONS_WALLET_FILE = "walletfile=";
    protected static final String ONS_PASSWORD = "walletpassword=";
    protected static final String ONS_HP_SEPARATOR = ",";
    protected static final String ONS_FILE_STRING = "file:";
    protected static final char ONS_CONFIG_SEPARATOR = '\n';
    public static final String ONS_PERM_STRING = "ONSUser";
    public static final int ONS_ORACLE_HOME = 1;
    public static final int ONS_CONFIG_FILE = 2;

    public static void setLogStream(PrintStream printStream, PrintStream printStream2) {
        if (printStream != null) {
            outstream = printStream;
        }
        if (printStream2 != null) {
            errstream = printStream2;
        }
    }

    protected ONS() throws ONSException {
        String string = null;
        ONSException oNSException = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CreatePermission(ONS_PERM_STRING));
        }
        this.oraclehome = System.getProperty("oracle.ons.oracleconfighome");
        if (this.oraclehome == null) {
            this.oraclehome = System.getProperty("oracle.ons.oraclehome");
        }
        if (this.oraclehome == null) {
            throw new ONSException("oracle.ons.oraclehome not set");
        }
        try {
            string = "127.0.0.1:" + ONS.readLocalPort(this.oraclehome);
        }
        catch (ONSException oNSException2) {
            oNSException = oNSException2;
        }
        if (oNSException != null) {
            string = "127.0.0.1:" + ONS.readStandaloneLocalPort(this.oraclehome);
        }
        this.onsInit();
        if (!this.netStartup(string, null, null)) {
            throw new ONSException("Error starting ONS");
        }
        String string2 = System.getProperty("oracle.ons.shutdowntimeout");
        if (string2 != null) {
            try {
                shutdowntimeout = Integer.valueOf(string2);
            }
            catch (Exception exception) {
                shutdowntimeout = 5;
            }
        }
    }

    public ONS(int n, String string) throws ONSException {
        String string2 = null;
        ONSException oNSException = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CreatePermission(ONS_PERM_STRING));
        }
        if (n == 1) {
            this.oraclehome = string;
            String string3 = string + File.separator + "opmn" + File.separator + "conf" + File.separator + "opmn.xml";
        } else {
            String string4 = string;
            int n2 = string.lastIndexOf(File.separator);
            if (n2 == -1) {
                throw new ONSException("Can't determine ORACLE_HOME from configuration file given");
            }
            this.oraclehome = string.substring(0, n2);
            if ((n2 = this.oraclehome.substring(0, n2).lastIndexOf(File.separator)) == -1) {
                throw new ONSException("Can't determine ORACLE_HOME from configuration file given");
            }
            this.oraclehome = string.substring(0, n2);
            if ((n2 = this.oraclehome.substring(0, n2).lastIndexOf(File.separator)) == -1) {
                throw new ONSException("Can't determine ORACLE_HOME from configuration file given");
            }
            this.oraclehome = string.substring(0, n2);
        }
        try {
            string2 = "127.0.0.1:" + ONS.readLocalPort(this.oraclehome);
        }
        catch (ONSException oNSException2) {
            oNSException = oNSException2;
        }
        if (oNSException != null) {
            string2 = "127.0.0.1:" + ONS.readStandaloneLocalPort(this.oraclehome);
        }
        this.onsInit();
        if (!this.netStartup(string2, null, null)) {
            throw new ONSException("Error starting ONS");
        }
    }

    public ONS(List list) throws ONSException {
    }

    private void onsSetup(String string) throws ONSException {
        String string2 = null;
        String string3 = null;
        if (string == null || string.length() == 0) {
            throw new ONSException("Hostport list can not be empty, at least one host:port should be specified");
        }
        this.onsInit();
        this.serverList = this.buildServerList(string);
        int n = this.serverList.size();
        localConn = false;
        this.receivers = Collections.synchronizedList(new ArrayList());
        this.senders = Collections.synchronizedList(new ArrayList());
        this.notifications = new HashMap();
        this.lastCleanupTime = 0L;
        this.currentSenderIndex = -1;
        this.lastServerIndex = -1;
        this.monitor = null;
        if (n > this.maxconnections) {
            this.connections = this.maxconnections;
            this.lastServerIndex = this.connections - 1;
        } else {
            this.connections = n;
        }
        for (int i = 0; i < this.connections; ++i) {
            ServerElement serverElement = (ServerElement)this.serverList.get(i);
            string2 = serverElement.getHostport();
            if (string2 != null && !this.netStartup(string2, serverElement, null)) {
                throw new ONSException("Error starting ONS");
            }
            serverElement.setConnected(true);
        }
        if (this.lastServerIndex >= 0) {
            this.monitor = new MonitorThread(this, this.receivers);
            this.monitor.start();
        }
        if ((string3 = System.getProperty("oracle.ons.shutdowntimeout")) != null) {
            try {
                shutdowntimeout = Integer.valueOf(string3);
            }
            catch (Exception exception) {
                shutdowntimeout = 5;
            }
        }
    }

    public ONS(List list, KeyStore keyStore, String string) throws ONSException {
    }

    public ONS(String string) throws ONSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CreatePermission(ONS_PERM_STRING));
        }
        if (string == null) {
            throw new ONSException("Config string can not be null");
        }
        String string2 = this.getValue(string, ONS_NODES);
        this.walletfile = this.getValue(string, ONS_WALLET_FILE);
        String string3 = this.getValue(string, ONS_PASSWORD);
        if (this.walletfile != null) {
            File file;
            String string4 = this.walletfile;
            if (string4.toLowerCase().startsWith(ONS_FILE_STRING)) {
                string4 = string4.substring(ONS_FILE_STRING.length());
            }
            if (!(file = new File(string4)).isFile() && !file.isDirectory()) {
                throw new ONSException("walletfile: " + this.walletfile + " does not exist!");
            }
        }
        if (string3 != null) {
            this.password = string3.toCharArray();
        }
        this.onsSetup(string2);
    }

    private String getValue(String string, String string2) {
        int n;
        boolean bl = false;
        String string3 = null;
        int n2 = 0;
        int n3 = 0;
        block0: while ((n = string.indexOf(string2, n2)) != -1 && !bl) {
            n3 = n;
            bl = true;
            n2 += string2.length();
            while (n > 0) {
                if (string.charAt(n - 1) == ' ') {
                    --n;
                    continue;
                }
                if (string.charAt(n - 1) == '\n') continue block0;
                bl = false;
                continue block0;
            }
        }
        if (bl) {
            int n4 = string.indexOf(10, n3 += string2.length());
            string3 = n4 == -1 ? string.substring(n3) : string.substring(n3, n4);
        }
        return string3;
    }

    private void onsInit() {
        myoems = this;
        this.subscribers = new Hashtable();
        this.pendingSubscriptions = new Hashtable();
        this.subscriberId = 1;
        this.publisherId = 1;
        this.numPublishers = 0;
        this.startTime = System.currentTimeMillis();
        this.processId = new Long(this.startTime).toString();
        this.receiver = null;
        this.hostname = ONS.getHostName();
        debug = false;
        this.clusterid = null;
        this.clustername = null;
        this.instanceid = null;
        this.instancename = null;
        try {
            String string;
            if (System.getProperty("oracle.ons.debug") != null) {
                debug = true;
                outstream.println("ONS.constructor ==> DEBUG enabled");
            }
            if ((string = System.getProperty("oracle.ons.maxconnections")) != null) {
                this.maxconnections = Integer.parseInt(string);
                if (debug) {
                    outstream.println("Number of max connections:" + string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getHostName() {
        String string = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {
            errstream.println("Caught exception getting local hostname");
            exception.printStackTrace(errstream);
            string = "UNKNOWNHOST";
        }
        return string;
    }

    private boolean netStartup(String string, ServerElement serverElement, NotificationQueue notificationQueue) {
        boolean bl = true;
        if (debug) {
            outstream.println("ONS::netStartup ==> hostport=" + string);
        }
        try {
            int n = string.indexOf(58);
            if (n != -1) {
                int n2 = Integer.valueOf(string.substring(n + 1));
                this.receiver = new ReceiverThread(string.substring(0, n), n2, serverElement, this);
                this.sender = new SenderThread(this, this.receiver, notificationQueue);
                if (!localConn) {
                    this.receivers.add(this.receiver);
                    this.senders.add(this.sender);
                }
                this.receiver.start();
                this.sender.start();
                if (serverElement != null) {
                    this.resendSubscriptions(this.sender);
                }
            }
        }
        catch (Exception exception) {
            errstream.println("Caught exception in netStartup()");
            exception.printStackTrace(errstream);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ONS getONS() {
        Object object = lock;
        synchronized (object) {
            if (myoems == null) {
                myoems = new ONS();
            }
        }
        return myoems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscriber(Subscriber subscriber, long l) throws SubscriptionException {
        Object object = lock;
        synchronized (object) {
            subscriber.setID(this.subscriberId);
            ++this.subscriberId;
        }
        SubscriptionNotification subscriptionNotification = new SubscriptionNotification(subscriber.id(), subscriber.subscription(), true);
        object = this.pendingSubscriptions;
        synchronized (object) {
            this.pendingSubscriptions.put(new Integer(subscriber.id()), subscriptionNotification);
        }
        if (localConn) {
            this.sender.send(subscriptionNotification);
        } else {
            object = this.senders;
            synchronized (object) {
                ListIterator listIterator = this.senders.listIterator();
                while (listIterator.hasNext()) {
                    ((SenderThread)listIterator.next()).send(subscriptionNotification);
                }
            }
        }
        subscriptionNotification.waitForReply(l);
        if (subscriptionNotification.success) {
            object = this.subscribers;
            synchronized (object) {
                this.subscribers.put(new Integer(subscriber.id()), subscriber);
            }
        } else {
            if (subscriptionNotification.ex != null) {
                throw subscriptionNotification.ex;
            }
            throw new SubscriptionException("Subscription failed for unknown reason");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionNotification findPendingSubscriptionNotification(int n) {
        SubscriptionNotification subscriptionNotification = null;
        Hashtable hashtable = this.pendingSubscriptions;
        synchronized (hashtable) {
            subscriptionNotification = (SubscriptionNotification)this.pendingSubscriptions.get(new Integer(n));
        }
        return subscriptionNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscriber(int n) {
        boolean bl = false;
        Object object = this.subscribers;
        synchronized (object) {
            this.subscribers.remove(new Integer(n));
            if (this.subscribers.size() == 0) {
                bl = true;
            }
        }
        if (bl) {
            object = lock;
            synchronized (object) {
                if (this.numPublishers == 0) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscriber lookupSubscriber(int n) {
        Subscriber subscriber;
        Hashtable hashtable = this.subscribers;
        synchronized (hashtable) {
            subscriber = (Subscriber)this.subscribers.get(new Integer(n));
        }
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPublisher(Publisher publisher) {
        Object object = lock;
        synchronized (object) {
            publisher.id(this.publisherId);
            ++this.publisherId;
            ++this.numPublishers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePublisher(Publisher publisher) {
        boolean bl = false;
        Object object = lock;
        synchronized (object) {
            --this.numPublishers;
            if (this.numPublishers == 0) {
                bl = true;
            }
        }
        if (bl) {
            object = this.subscribers;
            synchronized (object) {
                if (this.subscribers.size() != 0) {
                    bl = false;
                }
            }
        }
        if (bl) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        ListIterator listIterator = lock;
        synchronized (listIterator) {
            myoems = null;
        }
        if (this.monitor != null) {
            this.monitor.shutdown();
        }
        if (localConn) {
            if (this.sender != null) {
                this.sender.shutdown();
            }
            if (this.receiver != null) {
                this.receiver.shutdown();
            }
        } else {
            List list = this.senders;
            synchronized (list) {
                listIterator = this.senders.listIterator();
                while (listIterator.hasNext()) {
                    ((SenderThread)listIterator.next()).shutdown();
                }
            }
            list = this.receivers;
            synchronized (list) {
                listIterator = this.receivers.listIterator();
                while (listIterator.hasNext()) {
                    ((ReceiverThread)listIterator.next()).shutdown();
                }
            }
        }
    }

    protected String processId() {
        return this.processId;
    }

    protected String hostname() {
        return this.hostname;
    }

    protected void publish(Notification notification) {
        if (localConn && this.sender != null) {
            this.sender.send(notification);
        } else if (!localConn && this.senders.size() > 0) {
            SenderThread senderThread = null;
            for (int i = 0; i < this.senders.size(); ++i) {
                this.currentSenderIndex = (this.currentSenderIndex + 1) % this.senders.size();
                senderThread = (SenderThread)this.senders.get(this.currentSenderIndex);
                if (senderThread.isReady()) break;
            }
            if (senderThread != null) {
                senderThread.send(notification);
            }
        } else {
            Enumeration enumeration = this.subscribers.elements();
            while (enumeration.hasMoreElements()) {
                Subscriber subscriber = (Subscriber)enumeration.nextElement();
                subscriber.deliver(notification);
            }
        }
    }

    protected void deliver(Notification notification) {
        if (!localConn && this.receivers.size() > 1 && this.isDupNotification(notification)) {
            return;
        }
        if (notification.recipients != null && notification.recipients.length > 0) {
            for (int i = 0; i < notification.recipients.length; ++i) {
                Subscriber subscriber = this.lookupSubscriber(notification.recipients[i]);
                if (subscriber == null) continue;
                subscriber.deliver(notification);
            }
        }
    }

    protected boolean bytesEqual(byte[] byArray, byte[] byArray2, int n) {
        boolean bl = true;
        if ((byArray.length < n || byArray2.length < n) && byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; bl && i < n; ++i) {
            bl = byArray[i] == byArray2[i];
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSubscriptionReply(int n, boolean bl, String string) {
        SubscriptionNotification subscriptionNotification;
        SubscriptionException subscriptionException = null;
        Hashtable hashtable = this.pendingSubscriptions;
        synchronized (hashtable) {
            subscriptionNotification = this.findPendingSubscriptionNotification(n);
            if (subscriptionNotification != null) {
                this.pendingSubscriptions.remove(new Integer(n));
            }
        }
        if (subscriptionNotification != null) {
            if (!bl && string != null) {
                subscriptionException = new SubscriptionException(string);
            }
            subscriptionNotification.wakeup(bl, subscriptionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resendSubscriptions(SenderThread senderThread) {
        Hashtable hashtable = this.subscribers;
        synchronized (hashtable) {
            if (this.subscribers.size() > 0) {
                Enumeration enumeration = this.subscribers.elements();
                while (enumeration.hasMoreElements()) {
                    SubscriptionNotification subscriptionNotification;
                    Subscriber subscriber;
                    try {
                        subscriber = (Subscriber)enumeration.nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        subscriber = null;
                    }
                    if (subscriber == null) continue;
                    Hashtable hashtable2 = this.pendingSubscriptions;
                    synchronized (hashtable2) {
                        subscriptionNotification = (SubscriptionNotification)this.pendingSubscriptions.get(new Integer(subscriber.id()));
                        if (subscriptionNotification == null) {
                            subscriptionNotification = new SubscriptionNotification(subscriber.id(), subscriber.subscription(), false);
                            this.pendingSubscriptions.put(new Integer(subscriber.id()), subscriptionNotification);
                        }
                    }
                    if (senderThread == null) continue;
                    senderThread.send(subscriptionNotification, 1);
                }
            }
        }
    }

    public Subscriber createNewSubscriber(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission(ONS_PERM_STRING));
        }
        return new Subscriber(this, string, string2);
    }

    public Subscriber createNewSubscriber(String string, String string2, long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission(ONS_PERM_STRING));
        }
        return new Subscriber(this, string, string2, l);
    }

    public Publisher createNewPublisher(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PublishPermission(ONS_PERM_STRING));
        }
        return new Publisher(this, string);
    }

    public static int readLocalPort(String string) throws ONSException {
        return ONS.readPortFromConfigFile(string, "local");
    }

    public static int readRemotePort(String string) throws ONSException {
        return ONS.readPortFromConfigFile(string, "remote");
    }

    public static int readRequestPort(String string) throws ONSException {
        return ONS.readPortFromConfigFile(string, "request");
    }

    private static int readPortFromConfigFile(String string, String string2) throws ONSException {
        FileInputStream fileInputStream = null;
        boolean bl = false;
        String string3 = null;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = string + File.separator + "opmn" + File.separator + "conf" + File.separator + "opmn.xml";
        try {
            fileInputStream = new FileInputStream(string4);
        }
        catch (Exception exception) {
            throw new ONSException("Unable to open config file " + string4);
        }
        InputBuffer inputBuffer = new InputBuffer(fileInputStream);
        try {
            while (!bl) {
                int n2;
                int n3;
                int n4;
                String string5 = inputBuffer.getNextLine();
                if (!bl2 && (n4 = string5.indexOf("<port")) != -1) {
                    bl2 = true;
                    string5 = string5.substring(5);
                }
                if (!bl2) continue;
                if (!bl3 && (n4 = string5.indexOf(string2)) != -1) {
                    bl3 = true;
                    string5 = string5.substring(n4 + string2.length());
                }
                if (!bl3 || (n3 = string5.indexOf(61)) == -1) continue;
                string3 = string5.substring(n3 + 1);
                int n5 = (string3 = string3.trim()).length();
                if (n5 == 0) continue;
                if (string3.charAt(0) == '\"') {
                    string3 = string3.substring(1);
                }
                for (n2 = 0; n2 < n5 && Character.isDigit(string3.charAt(n2)); ++n2) {
                }
                if (n2 == 0) continue;
                if (n2 != n5) {
                    string3 = string3.substring(0, n2);
                }
                try {
                    n = Integer.decode(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (n == -1) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("End of stream encountered")) {
                throw new ONSException("No port entry found in config file " + string4);
            }
            throw new ONSException("I/O error encountered reading config file " + string4);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (n == -1) {
            throw new ONSException("No port entry found in config file " + string4);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readStandaloneLocalPort(String string) throws ONSException {
        int n;
        block27: {
            FileInputStream fileInputStream = null;
            boolean bl = false;
            String string2 = null;
            n = -1;
            boolean bl2 = false;
            ONS.getConfigFileName(string);
            try {
                fileInputStream = new FileInputStream(configFile);
            }
            catch (Exception exception) {
                throw new ONSException("Unable to open config file");
            }
            InputBuffer inputBuffer = new InputBuffer(fileInputStream);
            n = 6100;
            try {
                while (!bl) {
                    String string3;
                    String string4 = inputBuffer.getNextLine();
                    string4.toLowerCase();
                    string4.trim();
                    if (string4.startsWith("localport=")) {
                        int n2;
                        string2 = string4.substring(10);
                        int n3 = (string2 = string2.trim()).length();
                        if (n3 == 0) {
                            throw new ONSException("Format error when reading localport value");
                        }
                        if (string2.charAt(0) == '\"') {
                            string2 = string2.substring(1);
                        }
                        for (n2 = 0; n2 < n3 && Character.isDigit(string2.charAt(n2)); ++n2) {
                        }
                        if (n2 == 0) {
                            throw new ONSException("Format error when reading localport value");
                        }
                        if (n2 != n3) {
                            string2 = string2.substring(0, n2);
                        }
                        try {
                            n = Integer.decode(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ONSException("Format error when reading localport value");
                        }
                        bl2 = true;
                    } else if (!isSharedInstall && string4.startsWith("usesharedinstall=") && (string3 = string4.substring(17)).equalsIgnoreCase("true")) {
                        if (hostNameSuffix == null) {
                            throw new ONSException("GetHostName system call failed. Cannot proceed");
                        }
                        isSharedInstall = true;
                    }
                    if (!bl2 || !isSharedInstall) continue;
                    bl = true;
                }
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equals("End of stream encountered")) {
                    if (!bl2) {
                        throw new ONSException("No port entry found in config file " + configFile);
                    }
                    break block27;
                }
                throw new ONSException("I/O error encountered reading config file " + configFile);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return n;
    }

    private static void getConfigFileName(String string) {
        String string2 = string + File.separator + "opmn" + File.separator + "conf" + File.separator + "ons.config";
        configFile = null;
        isSharedInstall = false;
        hostNameSuffix = null;
        String string3 = ONS.getHostName();
        if (string3.equals("UNKNOWNHOST")) {
            File file = new File(string2);
            if (file.exists()) {
                configFile = string2;
                return;
            }
            errstream.println("ERROR: Hostname could not be resolved and config file (ons.config) could not be found.");
            return;
        }
        int n = string3.indexOf(46);
        hostNameSuffix = n != -1 ? string3.substring(0, n) : string3;
        String string4 = string2;
        File file = new File(string2 = string2 + "." + hostNameSuffix);
        if (file.exists()) {
            configFile = string2;
            isSharedInstall = true;
            return;
        }
        string2 = string4;
        file = new File(string2);
        if (file.exists()) {
            configFile = string2;
            return;
        }
        errstream.println("ERROR: config file (ons.config) could not be found.");
    }

    public static String readFormFactor(String string) throws ONSException {
        int n;
        FileInputStream fileInputStream = null;
        String string2 = null;
        String string3 = string + File.separator + "opmn" + File.separator + "conf" + File.separator + ".formfactor";
        if (isSharedInstall) {
            string3 = string3 + "." + hostNameSuffix;
        }
        try {
            fileInputStream = new FileInputStream(string3);
        }
        catch (Exception exception) {
            throw new ONSException("Unable to open formfactor file " + string3);
        }
        try {
            byte[] byArray = new byte[48];
            n = fileInputStream.read(byArray);
            if (n > 0) {
                string2 = new String(byArray, 0, n);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("End of stream encountered")) {
                throw new ONSException("No entry found in formfactor file " + string3);
            }
            throw new ONSException("I/O error encountered reading formfactor file " + string3);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (n <= 0) {
            throw new ONSException("No entry found in formfactor file " + string3);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDupNotification(Notification notification) {
        if (notification.id == null || notification.instanceName == null) {
            return false;
        }
        long l = System.currentTimeMillis();
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            String string;
            NotificationInformation notificationInformation;
            if (l - this.lastCleanupTime >= (long)notificationtimeout) {
                this.lastCleanupTime = l;
                this.cleanupNotificationTable(l);
            }
            if ((notificationInformation = (NotificationInformation)this.notifications.get(string = notification.instanceName + notification.id)) == null) {
                notificationInformation = new NotificationInformation(l);
                notificationInformation.addCount();
                this.notifications.put(string, notificationInformation);
                return false;
            }
            notificationInformation.addCount();
            this.cleanupNotificationTable(string, notificationInformation);
        }
        return true;
    }

    private void cleanupNotificationTable(String string, NotificationInformation notificationInformation) {
        if (string == null || notificationInformation == null) {
            return;
        }
        if (notificationInformation.getCount() >= this.connections) {
            this.notifications.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupNotificationTable(long l) {
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Set set = this.notifications.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                NotificationInformation notificationInformation = (NotificationInformation)entry.getValue();
                if (l - notificationInformation.getTimestamp() <= (long)notificationtimeout) continue;
                iterator.remove();
            }
        }
    }

    void replace(ReceiverThread receiverThread) {
        SenderThread senderThread;
        block6: {
            if (receiverThread == null) {
                return;
            }
            if (receiverThread.getServer() != null) {
                receiverThread.getServer().setConnected(false);
            }
            senderThread = receiverThread.getSenderThread();
            this.senders.remove(senderThread);
            this.receivers.remove(receiverThread);
            receiverThread.shutdown();
            senderThread.stopThread();
            try {
                senderThread.join();
            }
            catch (Exception exception) {
                if (!debug) break block6;
                exception.printStackTrace(errstream);
            }
        }
        NotificationQueue notificationQueue = senderThread.getSenderQueue();
        ServerElement serverElement = this.getNextServer();
        if (serverElement != null) {
            String string = serverElement.getHostport();
            if (!this.netStartup(string, serverElement, notificationQueue)) {
                throw new ONSException("Error starting receiver and sender threads");
            }
            serverElement.setConnected(true);
        }
    }

    private ServerElement getNextServer() {
        ServerElement serverElement = null;
        int n = this.serverList.size();
        for (int i = 0; i < n; ++i) {
            int n2 = (this.lastServerIndex + 1) % n;
            serverElement = (ServerElement)this.serverList.get(n2);
            if (serverElement == null || serverElement.isConnected()) continue;
            this.lastServerIndex = n2;
            break;
        }
        return serverElement;
    }

    private List buildServerList(String string) {
        String[] stringArray = string.split(ONS_HP_SEPARATOR);
        ArrayList<ServerElement> arrayList = new ArrayList<ServerElement>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new ServerElement(stringArray[i]));
        }
        return arrayList;
    }

    static {
        localConn = true;
        outstream = System.out;
        errstream = System.err;
        shutdowntimeout = 5;
        notificationtimeout = 30000;
    }
}

