/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.ONS;
import oracle.ons.QueueElement;

public class NotificationQueue {
    private QueueElement head = null;
    private QueueElement tail = null;
    private Object lock = new Object();
    private Object closelock = null;
    private int waiters = 0;
    private int count = 0;
    private boolean closed = false;
    private boolean closing;
    private int closewaiters = 0;
    protected static final int DEFAULT_PRIORITY = 10;
    protected static final int LOW_PRIORITY = 10;
    protected static final int HIGH_PRIORITY = 1;

    protected NotificationQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Object object) {
        QueueElement queueElement = new QueueElement(object);
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.closed && !this.closing) {
                if (this.head == null) {
                    this.head = queueElement;
                } else if (this.tail == null) {
                    this.head.next = this.tail = queueElement;
                } else {
                    this.tail.next = queueElement;
                    this.tail = queueElement;
                }
                if (this.waiters > 0) {
                    this.lock.notify();
                    --this.waiters;
                }
                ++this.count;
            }
        }
    }

    protected void push(Object object) {
        this.push(object, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(Object object, int n) {
        QueueElement queueElement = new QueueElement(object, n);
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.closed && !this.closing) {
                if (this.head == null) {
                    this.head = queueElement;
                } else if (n <= this.head.priority) {
                    if (this.tail == null) {
                        this.tail = this.head;
                    }
                    queueElement.next = this.head;
                    this.head = queueElement;
                } else {
                    QueueElement queueElement2 = this.head;
                    QueueElement queueElement3 = this.head.next;
                    while (queueElement3 != null && n > queueElement3.priority) {
                        queueElement2 = queueElement3;
                        queueElement3 = queueElement3.next;
                    }
                    if (queueElement3 != null) {
                        queueElement2.next = queueElement;
                        queueElement.next = queueElement3;
                    } else {
                        queueElement2.next = queueElement;
                        this.tail = queueElement;
                    }
                }
                if (this.waiters > 0) {
                    this.lock.notify();
                    --this.waiters;
                }
                ++this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
    }

    protected Object dequeue(boolean bl) {
        return this.internalDequeue(bl, -1L);
    }

    protected Object dequeue(long l) {
        return this.internalDequeue(true, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalDequeue(boolean bl, long l) {
        Object object = null;
        boolean bl2 = false;
        Object object2 = this.lock;
        synchronized (object2) {
            bl2 = this.closing;
            if (!this.closed) {
                block16: {
                    if (bl && this.head == null && !this.closing) {
                        ++this.waiters;
                        try {
                            if (l != -1L) {
                                this.lock.wait(l);
                            } else {
                                this.lock.wait();
                            }
                        }
                        catch (Exception exception) {
                            if (!ONS.debug) break block16;
                            exception.printStackTrace(ONS.errstream);
                        }
                    }
                }
                if (this.head != null) {
                    object = this.head.obj;
                    if (this.head.next == this.tail) {
                        this.tail = null;
                    }
                    this.head = this.head.next;
                    --this.count;
                }
            }
        }
        if (object == null && bl2) {
            object2 = this.closelock;
            synchronized (object2) {
                if (this.closewaiters > 0) {
                    this.closelock.notifyAll();
                }
            }
        }
        return object;
    }

    protected int count() {
        return this.count;
    }

    protected int waiters() {
        return this.waiters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain_and_close() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.closing = true;
            this.closelock = new Object();
            if (this.count > 0) {
                bl = true;
            }
        }
        if (bl) {
            object = this.closelock;
            synchronized (object) {
                Object object2 = this.lock;
                synchronized (object2) {
                    if (this.count == 0) {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        ++this.closewaiters;
                        this.closelock.wait(ONS.shutdowntimeout * 1000);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        --this.closewaiters;
                    }
                }
            }
        }
        this.close();
    }
}

