/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import oracle.ons.InputBuffer;
import oracle.ons.NotificationProperty;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.PropertyList;

public class Notification {
    protected static byte[] eventmessageline;
    protected static byte[] poststring;
    protected static byte[] headerseparator;
    protected static byte[] crlf;
    protected static byte[] versionheader;
    protected static byte[] versionheaderid;
    protected static byte[] typeheader;
    protected static byte[] affectedcomponentsheader;
    protected static byte[] affectednodesheader;
    protected static byte[] generatingcomponentheader;
    protected static byte[] generatingnodeheader;
    protected static byte[] generatingprocessheader;
    protected static byte[] idheader;
    protected static byte[] clusteridheader;
    protected static byte[] clusternameheader;
    protected static byte[] instanceidheader;
    protected static byte[] instancenameheader;
    protected static byte[] creationtimeheader;
    protected static byte[] contentlengthheader;
    protected static byte[] numpropertiesheader;
    protected static byte[] localonlyheader;
    protected static byte[] clusteronlyheader;
    protected static byte[] stampheader;
    protected static byte[] hostname;
    protected static byte[] truestring;
    protected static byte[] falsestring;
    private String type;
    private String affectedComponents;
    private String affectedNodes;
    private byte[] body;
    protected boolean localonly;
    protected boolean clusteronly;
    protected long deliveryTime;
    protected String generatingComponent;
    protected String generatingNode;
    protected String generatingProcess;
    protected String id;
    protected long creationTime;
    protected String clusterId;
    protected String clusterName;
    protected String instanceId;
    protected String instanceName;
    protected ONS oems;
    private boolean readonly;
    private PropertyList properties;
    protected int[] recipients;

    public Notification(String string, String string2, String string3, byte[] byArray) {
        this.type = string;
        this.affectedComponents = string2;
        this.affectedNodes = string3;
        this.body = byArray;
        this.generatingComponent = null;
        this.generatingProcess = null;
        this.id = null;
        this.creationTime = -1L;
        this.deliveryTime = -1L;
        this.properties = null;
        this.readonly = false;
        this.localonly = false;
        this.clusteronly = false;
        this.recipients = null;
        this.clusterId = null;
        this.clusterName = null;
        this.instanceId = null;
        this.instanceName = null;
        this.oems = ONS.getONS();
    }

    protected Notification(InputBuffer inputBuffer) throws IOException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String string = inputBuffer.getNextString();
        if (string.charAt(0) == 'o') {
            bl = true;
            inputBuffer.getNextString();
            inputBuffer.getNextString();
        }
        inputBuffer.skipBytes(typeheader.length);
        this.type = inputBuffer.getNextString();
        inputBuffer.skipBytes(affectedcomponentsheader.length);
        this.affectedComponents = inputBuffer.getNextString();
        inputBuffer.skipBytes(affectednodesheader.length);
        this.affectedNodes = inputBuffer.getNextString();
        inputBuffer.skipBytes(generatingcomponentheader.length);
        this.generatingComponent = inputBuffer.getNextString();
        inputBuffer.skipBytes(generatingprocessheader.length);
        this.generatingProcess = inputBuffer.getNextString();
        inputBuffer.skipBytes(generatingnodeheader.length);
        this.generatingNode = inputBuffer.getNextString();
        inputBuffer.skipBytes(idheader.length);
        this.id = inputBuffer.getNextString();
        inputBuffer.skipBytes(creationtimeheader.length);
        string = inputBuffer.getNextString();
        if (string != null) {
            try {
                this.creationTime = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (ONS.debug) {
                    ONS.errstream.println("Caught NumberFormatException trying to convert creationTime string " + string + " to long value");
                }
                throw new IOException();
            }
        } else {
            this.creationTime = -1L;
        }
        inputBuffer.skipBytes(clusteridheader.length);
        this.clusterId = inputBuffer.getNextString();
        inputBuffer.skipBytes(clusternameheader.length);
        this.clusterName = inputBuffer.getNextString();
        inputBuffer.skipBytes(instanceidheader.length);
        this.instanceId = inputBuffer.getNextString();
        inputBuffer.skipBytes(instancenameheader.length);
        this.instanceName = inputBuffer.getNextString();
        inputBuffer.skipBytes(localonlyheader.length);
        string = inputBuffer.getNextString();
        this.localonly = string != null ? string.equalsIgnoreCase("true") : false;
        if (!bl) {
            inputBuffer.skipBytes(clusteronlyheader.length);
            string = inputBuffer.getNextString();
            this.clusteronly = string != null ? string.equalsIgnoreCase("true") : false;
        } else {
            this.clusteronly = false;
        }
        inputBuffer.skipBytes(numpropertiesheader.length);
        string = inputBuffer.getNextString();
        if (string != null) {
            try {
                n2 = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (ONS.debug) {
                    ONS.errstream.println("Caught NumberFormatException trying to convert numproperties string " + string + " to int value");
                }
                throw new IOException();
            }
        } else {
            n2 = 0;
        }
        this.properties = n2 > 0 ? new PropertyList(n2, inputBuffer) : null;
        inputBuffer.skipBytes(contentlengthheader.length);
        string = inputBuffer.getNextString();
        if (string != null) {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (ONS.debug) {
                    ONS.errstream.println("Caught NumberFormatException trying to convert contentlength string " + string + " to int value");
                }
                throw new IOException();
            }
        } else {
            n = 0;
        }
        inputBuffer.skipBytes(14);
        string = inputBuffer.getNextString();
        if (string != null) {
            int n3;
            int n4 = 1;
            int n5 = 0;
            while ((n3 = string.indexOf(59, n5)) != -1) {
                ++n4;
                n5 = n3 + 1;
            }
            this.recipients = new int[n4];
            n5 = 0;
            for (int i = 0; i < n4; ++i) {
                n3 = string.indexOf(59, n5);
                String string2 = n3 == -1 ? string.substring(n5) : string.substring(n5, n3);
                try {
                    this.recipients[i] = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.recipients[i] = -1;
                }
                n5 = n3 + 1;
            }
        } else {
            this.recipients = null;
        }
        inputBuffer.skipBytes(2);
        if (n > 0) {
            this.body = new byte[n];
            inputBuffer.getBytes(this.body, n);
        } else {
            this.body = null;
        }
        this.deliveryTime = System.currentTimeMillis();
    }

    protected void send(OutputBuffer outputBuffer) throws IOException {
        if (ONS.debug) {
            ONS.outstream.println("Notification::send ==> obuf=" + outputBuffer);
        }
        outputBuffer.putBytes(eventmessageline, eventmessageline.length);
        outputBuffer.putBytes(versionheader, versionheader.length);
        outputBuffer.putBytes(versionheaderid, versionheaderid.length);
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(typeheader, typeheader.length);
        if (this.type != null) {
            outputBuffer.putString(this.type);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(affectedcomponentsheader, affectedcomponentsheader.length);
        if (this.affectedComponents != null) {
            outputBuffer.putString(this.affectedComponents);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(affectednodesheader, affectednodesheader.length);
        if (this.affectedNodes != null) {
            outputBuffer.putString(this.affectedNodes);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(generatingcomponentheader, generatingcomponentheader.length);
        if (this.generatingComponent != null) {
            outputBuffer.putString(this.generatingComponent);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(generatingprocessheader, generatingprocessheader.length);
        if (this.generatingProcess != null) {
            outputBuffer.putString(this.generatingProcess);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(generatingnodeheader, generatingnodeheader.length);
        if (this.generatingNode != null) {
            outputBuffer.putString(this.generatingNode);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(idheader, idheader.length);
        if (this.id != null) {
            outputBuffer.putString(this.id);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(creationtimeheader, creationtimeheader.length);
        byte[] byArray = new Long(this.creationTime).toString().getBytes();
        outputBuffer.putBytes(byArray, byArray.length);
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(clusteridheader, clusteridheader.length);
        if (this.oems.clusterid != null) {
            outputBuffer.putString(this.oems.clusterid);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(clusternameheader, clusternameheader.length);
        if (this.oems.clustername != null) {
            outputBuffer.putString(this.oems.clustername);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(instanceidheader, instanceidheader.length);
        if (this.oems.instanceid != null) {
            outputBuffer.putString(this.oems.instanceid);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(instancenameheader, instancenameheader.length);
        if (this.oems.instancename != null) {
            outputBuffer.putString(this.oems.instancename);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(localonlyheader, localonlyheader.length);
        if (this.localonly) {
            outputBuffer.putBytes(truestring, truestring.length);
        } else {
            outputBuffer.putBytes(falsestring, falsestring.length);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(clusteronlyheader, clusteronlyheader.length);
        if (this.clusteronly) {
            outputBuffer.putBytes(truestring, truestring.length);
        } else {
            outputBuffer.putBytes(falsestring, falsestring.length);
        }
        outputBuffer.putBytes(crlf, 2);
        outputBuffer.putBytes(numpropertiesheader, numpropertiesheader.length);
        if (this.properties != null) {
            byArray = new Integer(this.properties.num()).toString().getBytes();
            outputBuffer.putBytes(byArray, byArray.length);
            outputBuffer.putBytes(crlf, 2);
            this.properties.write(outputBuffer);
        } else {
            outputBuffer.putByte((byte)48);
            outputBuffer.putBytes(crlf, 2);
        }
        if (this.body != null) {
            outputBuffer.putBytes(contentlengthheader, contentlengthheader.length);
            byArray = new Integer(this.body.length).toString().getBytes();
            outputBuffer.putBytes(byArray, byArray.length);
            outputBuffer.putBytes(crlf, 2);
        } else {
            outputBuffer.putBytes(contentlengthheader, contentlengthheader.length);
            outputBuffer.putByte((byte)48);
            outputBuffer.putBytes(crlf, 2);
        }
        outputBuffer.putBytes(crlf, 2);
        if (this.body != null) {
            outputBuffer.putBytes(this.body, this.body.length);
        }
        outputBuffer.flush();
    }

    public String type() {
        return this.type;
    }

    public String affectedComponents() {
        return this.affectedComponents;
    }

    public String affectedNodes() {
        return this.affectedNodes;
    }

    public String generatingComponent() {
        return this.generatingComponent;
    }

    public String generatingNode() {
        return this.generatingNode;
    }

    public String generatingProcess() {
        return this.generatingProcess;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String id() {
        return this.id;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long deliveryTime() {
        return this.deliveryTime;
    }

    public void setProperty(String string, String string2) {
        if (!this.readonly) {
            if (this.properties == null) {
                this.properties = new PropertyList();
            }
            this.properties.put(string, string2);
        }
    }

    public String getProperty(String string) {
        String string2 = null;
        if (this.properties != null) {
            string2 = this.properties.get(string);
        }
        return string2;
    }

    public NotificationProperty[] getAllProperties() {
        if (this.properties != null) {
            return this.properties.getAll();
        }
        return null;
    }

    public byte[] body() {
        return this.body;
    }

    public void setLocalOnly() {
        this.localonly = true;
    }

    public void setClusterOnly() {
        this.clusteronly = true;
    }

    public boolean getLocalOnly() {
        return this.localonly;
    }

    public boolean getClusterOnly() {
        return this.clusteronly;
    }

    public void print() {
        ONS.outstream.println("Notification Type:         " + this.type);
        ONS.outstream.println("Affected Components:       " + this.affectedComponents);
        ONS.outstream.println("Affected Nodes:            " + this.affectedNodes);
        ONS.outstream.println("Delivery Time:             " + this.deliveryTime);
        ONS.outstream.println("Generating Component:      " + this.generatingComponent);
        ONS.outstream.println("Generating Node:           " + this.generatingNode);
        ONS.outstream.println("Generating Process:        " + this.generatingProcess);
        ONS.outstream.println("Notification ID:           " + this.id);
        ONS.outstream.println("Notification Creation Time:" + this.creationTime);
        ONS.outstream.println("Cluster ID:                " + this.clusterId);
        ONS.outstream.println("Cluster Name:              " + this.clusterName);
        ONS.outstream.println("Instance ID:               " + this.instanceId);
        ONS.outstream.println("Instance Name:             " + this.instanceName);
        if (this.localonly) {
            ONS.outstream.println("Local Only Flag:           TRUE");
        } else {
            ONS.outstream.println("Local Only Flag:           FALSE");
        }
        if (this.clusteronly) {
            ONS.outstream.println("Cluster Only Flag:         TRUE");
        } else {
            ONS.outstream.println("Cluster Only Flag:         FALSE");
        }
        if (this.properties != null) {
            this.properties.print();
        }
        ONS.outstream.println("Body:                      " + this.body);
    }

    static {
        crlf = new byte[2];
        Notification.crlf[0] = 13;
        Notification.crlf[1] = 10;
        eventmessageline = new byte[22];
        System.arraycopy(new String("POST /event HTTP/1.1").getBytes(), 0, eventmessageline, 0, 20);
        System.arraycopy(crlf, 0, eventmessageline, 20, 2);
        poststring = new String("POST ").getBytes();
        headerseparator = new String(": ").getBytes();
        versionheader = new String("Version: ").getBytes();
        versionheaderid = new String("3").getBytes();
        typeheader = new String("eventType: ").getBytes();
        affectedcomponentsheader = new String("affectedComponents: ").getBytes();
        affectednodesheader = new String("affectedNodes: ").getBytes();
        generatingcomponentheader = new String("generatingComponent: ").getBytes();
        generatingnodeheader = new String("generatingNode: ").getBytes();
        generatingprocessheader = new String("generatingProcess: ").getBytes();
        idheader = new String("eventId: ").getBytes();
        clusteridheader = new String("clusterId: ").getBytes();
        clusternameheader = new String("clusterName: ").getBytes();
        instanceidheader = new String("instanceId: ").getBytes();
        instancenameheader = new String("instanceName: ").getBytes();
        creationtimeheader = new String("creationTime: ").getBytes();
        contentlengthheader = new String("Content-Length: ").getBytes();
        numpropertiesheader = new String("numberOfProperties: ").getBytes();
        localonlyheader = new String("LocalOnly: ").getBytes();
        clusteronlyheader = new String("ClusterOnly: ").getBytes();
        stampheader = new String("stamp: ").getBytes();
        hostname = new String("hostName: ").getBytes();
        truestring = new String("true").getBytes();
        falsestring = new String("false").getBytes();
    }
}

