/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.io.InputStream;
import oracle.ons.ONS;

public class InputBuffer {
    private static final int BUFFERSIZE = 1024;
    private InputStream istr;
    private byte[] buffer;
    private int dataleft;
    private int position;

    protected InputBuffer(InputStream inputStream) {
        this.istr = inputStream;
        this.buffer = new byte[1024];
        this.position = 0;
        this.dataleft = 0;
    }

    protected int getBytes(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        if (this.dataleft >= n) {
            System.arraycopy(this.buffer, this.position, byArray, 0, n);
            this.dataleft -= n;
            this.position += n;
            n2 = n;
        } else if (n > 1024) {
            int n3 = 0;
            int n4 = n;
            if (this.dataleft > 0) {
                System.arraycopy(this.buffer, this.position, byArray, 0, this.dataleft);
                n3 = this.dataleft;
                n4 -= this.dataleft;
            }
            this.position = 0;
            this.dataleft = 0;
            while (n2 != -1 && n4 > 0) {
                int n5 = this.istr.read(byArray, n3, n4);
                if (n5 > 0) {
                    n3 += n5;
                    n4 -= n5;
                    continue;
                }
                n2 = -1;
            }
            if (n2 != -1) {
                n2 = n;
            }
        } else {
            while (this.dataleft < n) {
                this.readMoreData();
            }
            System.arraycopy(this.buffer, this.position, byArray, 0, n);
            this.dataleft -= n;
            this.position += n;
            n2 = n;
        }
        return n2;
    }

    protected byte getByte() throws IOException {
        boolean bl = false;
        while (this.dataleft == 0) {
            this.readMoreData();
        }
        byte by = this.buffer[this.position];
        --this.dataleft;
        ++this.position;
        return by;
    }

    protected int skipBytes(int n) throws IOException {
        int n2 = 0;
        if (this.dataleft >= n) {
            this.dataleft -= n;
            this.position += n;
            n2 = n;
        } else {
            while (this.dataleft < n) {
                this.readMoreData();
            }
            this.dataleft -= n;
            this.position += n;
            n2 = n;
        }
        return n2;
    }

    protected String getNextString() throws IOException {
        String string;
        int n;
        for (n = 0; n < this.dataleft && this.buffer[this.position + n] != 13; ++n) {
        }
        if (n == this.dataleft) {
            this.readMoreData();
            return this.getNextString();
        }
        if (n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.position, byArray, 0, n);
            string = new String(byArray);
        } else {
            string = null;
        }
        this.skipBytes(n + 2);
        return string;
    }

    private void readMoreData() throws IOException {
        if (this.position > 0 && this.dataleft > 0) {
            byte[] byArray = new byte[this.dataleft];
            System.arraycopy(this.buffer, this.position, byArray, 0, this.dataleft);
            System.arraycopy(byArray, 0, this.buffer, 0, this.dataleft);
        }
        this.position = 0;
        int n = this.istr.read(this.buffer, this.dataleft, 1024 - this.dataleft);
        if (n > 0) {
            this.dataleft += n;
        } else if (n == -1) {
            throw new IOException("End of stream encountered");
        }
    }

    protected void print() {
        for (int i = 0; i < this.dataleft; ++i) {
            ONS.outstream.println("buffer[" + (this.position + i) + "] = " + (char)this.buffer[this.position + i]);
        }
    }

    protected String getNextLine() throws IOException {
        String string;
        int n;
        for (n = 0; n < this.dataleft && this.buffer[this.position + n] != 10; ++n) {
        }
        if (n == this.dataleft) {
            this.readMoreData();
            return this.getNextLine();
        }
        if (n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.position, byArray, 0, n);
            string = new String(byArray);
        } else {
            string = new String("");
        }
        this.skipBytes(n + 1);
        return string;
    }
}

