/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.scheduling.service.impl;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import net.wenzuo.atom.scheduling.config.Task;
import net.wenzuo.atom.scheduling.service.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.StringUtils;

public class TaskServiceImpl
implements TaskService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private final Validator validator;
    private final ApplicationContext applicationContext;
    private final TaskScheduler taskScheduler;
    private final ConcurrentMap<String, ScheduledFuture<?>> jobMap = new ConcurrentHashMap();

    @Override
    public void setTask(Task task) {
        this.clear();
        this.internalAddTask(task);
    }

    @Override
    public void setTasks(List<Task> tasks) {
        this.clear();
        for (Task task : tasks) {
            this.internalAddTask(task);
        }
    }

    @Override
    public void addTask(Task task) {
        this.internalAddTask(task);
    }

    @Override
    public void addTasks(List<Task> tasks) {
        for (Task task : tasks) {
            this.internalAddTask(task);
        }
    }

    @Override
    public void removeTask(String taskId) {
        this.internalRemoveTask(taskId);
    }

    @Override
    public void removeTasks(List<String> taskIds) {
        for (String taskId : taskIds) {
            this.internalRemoveTask(taskId);
        }
    }

    @Override
    public void removeTasksPrefix(String prefix) {
        this.internalRemoveTasks(key -> key.startsWith(prefix));
    }

    @Override
    public void removeTasksSuffix(String suffix) {
        this.internalRemoveTasks(key -> key.endsWith(suffix));
    }

    @Override
    public void removeTasksContains(String contains) {
        this.internalRemoveTasks(key -> key.contains(contains));
    }

    @Override
    public void removeTasksRegex(String regex) {
        Pattern pattern = Pattern.compile(regex);
        this.internalRemoveTasks(key -> pattern.matcher((CharSequence)key).matches());
    }

    @Override
    public void clear() {
        this.jobMap.values().forEach(future -> future.cancel(true));
        this.jobMap.clear();
    }

    @Override
    public Map<String, ScheduledFuture<?>> getJobMap() {
        return this.jobMap;
    }

    private void internalRemoveTasks(Predicate<String> filter) {
        this.jobMap.entrySet().removeIf(entry -> {
            if (filter.test((String)entry.getKey())) {
                ((ScheduledFuture)entry.getValue()).cancel(true);
                return true;
            }
            return false;
        });
    }

    private void internalAddTask(Task task) {
        try {
            this.validateTask(task);
            TaskAction taskAction = this.resolveTaskAction(task);
            Runnable runnable = this.createRunnable(task, taskAction);
            CronTrigger trigger = this.createCronTrigger(task);
            this.internalRemoveTask(task.getId());
            ScheduledFuture future = this.taskScheduler.schedule(runnable, (Trigger)trigger);
            this.jobMap.put(task.getId(), future);
        }
        catch (ConstraintViolationException | IllegalArgumentException e) {
            log.error("Failed to schedule task '{}': Validation or configuration error - {}", (Object)task.getId(), (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected error scheduling task '{}': {}", new Object[]{task.getId(), e.getMessage(), e});
        }
    }

    private void validateTask(Task task) {
        Set violations = this.validator.validate((Object)task, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException("Task validation failed for id '" + task.getId() + "'", violations);
        }
    }

    private TaskAction resolveTaskAction(Task task) throws IllegalArgumentException {
        Class<?> clazz;
        try {
            clazz = Class.forName(task.getClazz());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Task class not found: " + task.getClazz(), e);
        }
        Object bean = this.applicationContext.getBean(clazz);
        String methodName = task.getMethod();
        boolean expectsParam = StringUtils.hasText((String)task.getParam());
        try {
            Method methodToCall = bean.getClass().getMethod(methodName, String.class);
            return new TaskAction(bean, methodToCall, true);
        }
        catch (NoSuchMethodException e) {
            try {
                Method methodToCall = bean.getClass().getMethod(methodName, new Class[0]);
                if (expectsParam) {
                    throw new IllegalArgumentException(String.format("Task '%s' provided parameter '%s', but method '%s' in class '%s' only exists without parameters.", task.getId(), task.getParam(), methodName, task.getClazz()));
                }
                return new TaskAction(bean, methodToCall, false);
            }
            catch (NoSuchMethodException ex) {
                String errorMsg = String.format("Task method '%s' not found in class '%s' compatible with %s.", methodName, task.getClazz(), expectsParam ? "String parameter" : "no parameters");
                throw new IllegalArgumentException(errorMsg, ex);
            }
        }
    }

    private Runnable createRunnable(Task task, TaskAction taskAction) {
        return () -> {
            try {
                if (taskAction.requiresParam) {
                    taskAction.method.invoke(taskAction.bean, task.getParam());
                } else {
                    taskAction.method.invoke(taskAction.bean, new Object[0]);
                }
            }
            catch (InvocationTargetException e) {
                log.error("Exception occurred during execution of task: {} - Method: {}#{}", new Object[]{task.getId(), task.getClazz(), task.getMethod(), e.getTargetException()});
            }
            catch (IllegalAccessException e) {
                log.error("Illegal access during execution of task: {} - Method: {}#{}", new Object[]{task.getId(), task.getClazz(), task.getMethod(), e});
            }
            catch (Exception e) {
                log.error("Unexpected error during execution logic of task: {} - Method: {}#{}", new Object[]{task.getId(), task.getClazz(), task.getMethod(), e});
            }
        };
    }

    private CronTrigger createCronTrigger(Task task) throws IllegalArgumentException {
        try {
            return new CronTrigger(task.getCron(), ZoneId.systemDefault());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid cron expression '" + task.getCron() + "' for task '" + task.getId() + "'", e);
        }
    }

    private void internalRemoveTask(String taskId) {
        ScheduledFuture future = (ScheduledFuture)this.jobMap.remove(taskId);
        if (future != null) {
            future.cancel(true);
        }
    }

    @Generated
    public TaskServiceImpl(Validator validator, ApplicationContext applicationContext, TaskScheduler taskScheduler) {
        this.validator = validator;
        this.applicationContext = applicationContext;
        this.taskScheduler = taskScheduler;
    }

    private record TaskAction(Object bean, Method method, boolean requiresParam) {
    }
}

