/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.scheduling.service.impl;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.regex.Pattern;
import lombok.Generated;
import net.wenzuo.atom.scheduling.config.Task;
import net.wenzuo.atom.scheduling.service.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements TaskService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private final Validator validator;
    private final ApplicationContext applicationContext;
    private final TaskScheduler taskScheduler;
    private final Map<String, ScheduledFuture<?>> jobMap;

    public TaskServiceImpl(Validator validator, ApplicationContext applicationContext, TaskScheduler taskScheduler) {
        this.validator = validator;
        this.applicationContext = applicationContext;
        this.taskScheduler = taskScheduler;
        this.jobMap = new HashMap();
    }

    @Override
    public void setTask(Task task) {
        for (ScheduledFuture<?> future : this.jobMap.values()) {
            future.cancel(true);
        }
        this.jobMap.clear();
        this.check(task);
        ScheduledFuture future = this.taskScheduler.schedule(this.getRunnable(task), (Trigger)this.getCronTrigger(task));
        this.jobMap.put(task.getId(), future);
    }

    @Override
    public void setTasks(List<Task> tasks) {
        for (ScheduledFuture<?> future : this.jobMap.values()) {
            future.cancel(true);
        }
        this.jobMap.clear();
        for (Task task : tasks) {
            this.check(task);
            ScheduledFuture future = this.taskScheduler.schedule(this.getRunnable(task), (Trigger)this.getCronTrigger(task));
            this.jobMap.put(task.getId(), future);
        }
    }

    @Override
    public void addTask(Task task) {
        this.check(task);
        this.removeTask(task.getId());
        ScheduledFuture future = this.taskScheduler.schedule(this.getRunnable(task), (Trigger)this.getCronTrigger(task));
        this.jobMap.put(task.getId(), future);
    }

    @Override
    public void addTasks(List<Task> tasks) {
        for (Task task : tasks) {
            this.check(task);
            this.removeTask(task.getId());
            ScheduledFuture future = this.taskScheduler.schedule(this.getRunnable(task), (Trigger)this.getCronTrigger(task));
            this.jobMap.put(task.getId(), future);
        }
    }

    @Override
    public void removeTask(String taskId) {
        ScheduledFuture<?> future = this.jobMap.get(taskId);
        if (future != null) {
            future.cancel(true);
            this.jobMap.remove(taskId);
        }
    }

    @Override
    public void removeTasks(List<String> taskIds) {
        for (String taskId : taskIds) {
            ScheduledFuture<?> future = this.jobMap.get(taskId);
            if (future == null) continue;
            future.cancel(true);
            this.jobMap.remove(taskId);
        }
    }

    @Override
    public void removeTasksPrefix(String prefix) {
        Iterator<Map.Entry<String, ScheduledFuture<?>>> iterator = this.jobMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ScheduledFuture<?>> next = iterator.next();
            if (!next.getKey().startsWith(prefix)) continue;
            next.getValue().cancel(true);
            iterator.remove();
        }
    }

    @Override
    public void removeTasksSuffix(String suffix) {
        Iterator<Map.Entry<String, ScheduledFuture<?>>> iterator = this.jobMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ScheduledFuture<?>> next = iterator.next();
            if (!next.getKey().endsWith(suffix)) continue;
            next.getValue().cancel(true);
            iterator.remove();
        }
    }

    @Override
    public void removeTasksContains(String contains) {
        Iterator<Map.Entry<String, ScheduledFuture<?>>> iterator = this.jobMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ScheduledFuture<?>> next = iterator.next();
            if (!next.getKey().contains(contains)) continue;
            next.getValue().cancel(true);
            iterator.remove();
        }
    }

    @Override
    public void removeTasksRegex(String regex) {
        Pattern pattern = Pattern.compile(regex);
        Iterator<Map.Entry<String, ScheduledFuture<?>>> iterator = this.jobMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ScheduledFuture<?>> next = iterator.next();
            if (!pattern.matcher(next.getKey()).matches()) continue;
            next.getValue().cancel(true);
            iterator.remove();
        }
    }

    @Override
    public void clear() {
        for (ScheduledFuture<?> future : this.jobMap.values()) {
            future.cancel(true);
        }
        this.jobMap.clear();
    }

    @Override
    public Map<String, ScheduledFuture<?>> getJobMap() {
        return this.jobMap;
    }

    private Runnable getRunnable(Task task) {
        return () -> {
            Class<?> clazz;
            try {
                clazz = Class.forName(task.getClazz());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Object bean = this.applicationContext.getBean(clazz);
            try {
                Method method = bean.getClass().getMethod(task.getMethod(), String.class);
                method.invoke(bean, task.getParam());
            }
            catch (NoSuchMethodException e) {
                if (task.getParam() != null && !task.getParam().isEmpty()) {
                    throw new RuntimeException(e);
                }
                try {
                    Method method = bean.getClass().getMethod(task.getMethod(), new Class[0]);
                    method.invoke(bean, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private CronTrigger getCronTrigger(Task task) {
        return new CronTrigger(task.getCron(), ZoneId.systemDefault());
    }

    private void check(Task task) {
        Class<?> clazz;
        Set constraintViolations = this.validator.validate((Object)task, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        try {
            clazz = Class.forName(task.getClazz());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Object bean = this.applicationContext.getBean(clazz);
        try {
            bean.getClass().getMethod(task.getMethod(), String.class);
        }
        catch (NoSuchMethodException e) {
            if (task.getParam() != null && !task.getParam().isEmpty()) {
                throw new RuntimeException(e);
            }
            try {
                bean.getClass().getMethod(task.getMethod(), new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

