/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.base.ResourceLoader;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZoneProvider;
import net.time4j.tz.other.WindowsZone;
import net.time4j.tz.spi.WinZoneID;

public class WinZoneProviderSPI
implements ZoneProvider {
    private static final Map<String, Map<String, String>> REPOSITORY;
    private static final Map<String, Set<String>> PREFERRED_KEYS;
    public static final Map<String, Map<String, Set<TZID>>> NAME_BASED_MAP;
    public static final String WIN_NAME_VERSION;
    private static final String VKEY = "VERSION";

    public Set<String> getAvailableIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (TZID tZID : Timezone.getAvailableIDs((String)"DEFAULT")) {
            hashSet.add("WINDOWS~" + tZID.canonical());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Map<String, String> getAliases() {
        return Collections.emptyMap();
    }

    public String getFallback() {
        return "DEFAULT";
    }

    public String getName() {
        return "WINDOWS";
    }

    public String getLocation() {
        return "";
    }

    public String getVersion() {
        return "";
    }

    public TransitionHistory load(String string) {
        return null;
    }

    public Set<String> getPreferredIDs(Locale locale, boolean bl) {
        return WinZoneProviderSPI.getPreferredIDs(locale.getCountry(), bl);
    }

    public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
        if (string.isEmpty()) {
            return "";
        }
        Map<String, String> map = WinZoneProviderSPI.idsToNames(locale.getCountry());
        String string2 = map.get("WINDOWS~" + string);
        return string2 == null ? "" : string2;
    }

    private static Map<String, String> idsToNames(String string) {
        Map<String, String> map = REPOSITORY.get(string);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    private static Set<String> getPreferredIDs(String string, boolean bl) {
        return bl ? WinZoneProviderSPI.getPreferences(string) : WinZoneProviderSPI.idsToNames(string).keySet();
    }

    private static Set<String> getPreferences(String string) {
        Set<String> set = PREFERRED_KEYS.get(string);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    private static Map<String, Map<String, String>> loadData() {
        ObjectInputStream objectInputStream = null;
        try {
            String string = "data/winzone.ser";
            URI uRI = ResourceLoader.getInstance().locate("misc", WindowsZone.class, string);
            InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
            objectInputStream = new ObjectInputStream(inputStream);
            String string2 = objectInputStream.readUTF();
            Map map = (Map)WinZoneProviderSPI.cast(objectInputStream.readObject());
            HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>(map);
            hashMap.put(VKEY, Collections.singletonMap(string2, string2));
            HashMap<String, Map<String, String>> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static Map<String, Set<String>> prepareSmartMode() {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (String string : REPOSITORY.keySet()) {
            Map<String, String> map = WinZoneProviderSPI.idsToNames(string);
            Set<String> set = map.keySet();
            if (set.size() >= 2) {
                set = new HashSet<String>();
                HashSet<String> hashSet = new HashSet<String>(map.values());
                for (String string2 : hashSet) {
                    for (Map.Entry<String, String> entry : WinZoneProviderSPI.getFallbackSet()) {
                        if (!entry.getValue().equals(string2)) continue;
                        set.add(entry.getKey());
                    }
                }
            }
            hashMap.put(string, set);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static Set<Map.Entry<String, String>> getFallbackSet() {
        return WinZoneProviderSPI.idsToNames("001").entrySet();
    }

    private static Map<String, Map<String, Set<TZID>>> prepareResolvers() {
        HashMap hashMap = new HashMap();
        for (String string : REPOSITORY.keySet()) {
            Map<String, String> map = REPOSITORY.get(string);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                HashSet<WinZoneID> hashSet;
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                HashMap<String, HashSet<WinZoneID>> hashMap2 = (HashMap<String, HashSet<WinZoneID>>)hashMap.get(string3);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<String, HashSet<WinZoneID>>();
                    hashMap.put(string3, hashMap2);
                }
                if ((hashSet = (HashSet<WinZoneID>)hashMap2.get(string)) == null) {
                    hashSet = new HashSet<WinZoneID>();
                    hashMap2.put(string, hashSet);
                }
                hashSet.add(new WinZoneID(string2));
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    static {
        Map<String, Map<String, String>> map = WinZoneProviderSPI.loadData();
        WIN_NAME_VERSION = map.get(VKEY).keySet().iterator().next();
        map.remove(VKEY);
        REPOSITORY = Collections.unmodifiableMap(map);
        PREFERRED_KEYS = WinZoneProviderSPI.prepareSmartMode();
        NAME_BASED_MAP = WinZoneProviderSPI.prepareResolvers();
    }
}

