/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.io.IOException;
import net.time4j.Moment;
import net.time4j.SystemClock;
import net.time4j.scale.TimeScale;

public final class SntpMessage {
    private static final long OFFSET_1900 = 2208988800000000L;
    private static final long OFFSET_2036 = -2085978496000000L;
    private static final int MIO = 1000000;
    private static final double MIO_AS_DOUBLE = 1000000.0;
    private static final byte[] NULL_REF_ID = new byte[]{0, 0, 0, 0};
    private static final double BIT08 = 256.0;
    private static final double BIT16 = 65536.0;
    private final byte leapIndicator;
    private final byte version;
    private final byte mode;
    private final short stratum;
    private final short pollInterval;
    private final byte precision;
    private final double rootDelay;
    private final double rootDispersion;
    private final byte[] refID;
    private final double referenceTimestamp;
    private final double originateTimestamp;
    private final double receiveTimestamp;
    private final double transmitTimestamp;

    SntpMessage(boolean bl) {
        this.leapIndicator = 0;
        this.version = (byte)(bl ? 4 : 3);
        this.mode = (byte)3;
        this.stratum = 0;
        this.pollInterval = 0;
        this.precision = 0;
        this.rootDelay = 0.0;
        this.rootDispersion = 0.0;
        this.refID = NULL_REF_ID;
        this.referenceTimestamp = 0.0;
        this.originateTimestamp = 0.0;
        this.receiveTimestamp = 0.0;
        this.transmitTimestamp = SntpMessage.getLocalTimestamp();
    }

    SntpMessage(byte[] byArray, double d, byte by) throws IOException {
        this.leapIndicator = (byte)(byArray[0] >> 6 & 3);
        this.version = (byte)(byArray[0] >> 3 & 7);
        this.mode = (byte)(byArray[0] & 7);
        this.stratum = SntpMessage.toUnsigned(byArray[1]);
        this.pollInterval = SntpMessage.toUnsigned(byArray[2]);
        this.precision = byArray[3];
        this.rootDelay = (double)byArray[4] * 256.0 + (double)SntpMessage.toUnsigned(byArray[5]) + (double)SntpMessage.toUnsigned(byArray[6]) / 256.0 + (double)SntpMessage.toUnsigned(byArray[7]) / 65536.0;
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = byArray[i + 8] & 0xFF;
            n |= n2 << 24 - i * 8;
        }
        this.rootDispersion = (double)n / 65536.0;
        byte[] byArray2 = new byte[]{byArray[12], byArray[13], byArray[14], byArray[15]};
        this.refID = byArray2;
        this.referenceTimestamp = SntpMessage.decode(byArray, 16);
        this.originateTimestamp = SntpMessage.decode(byArray, 24);
        this.receiveTimestamp = SntpMessage.decode(byArray, 32);
        this.transmitTimestamp = SntpMessage.decode(byArray, 40);
        if (this.transmitTimestamp == 0.0) {
            throw new IOException("Server hasn't sent any transmit timestamp.");
        }
        if (Math.abs(d - this.originateTimestamp) >= 0.001 && this.mode == 4) {
            throw new IOException("Originate timestamp does not match sent timestamp: " + this.originateTimestamp + " (expected = " + d + ")");
        }
        if (this.mode != 4 && this.mode != 5) {
            throw new IOException("Unexpected server mode: " + this.mode);
        }
        if (this.leapIndicator < 0 || this.leapIndicator > 3) {
            throw new IOException("Unexpected leap indicator: " + this.leapIndicator);
        }
        if (this.version < 1 || this.version > 4 || this.mode == 4 && this.version != by) {
            throw new IOException("Unexpected ntp version: " + this.version);
        }
        if (this.stratum < 0 || this.stratum > 15) {
            throw new IOException("Unexpected stratum: " + this.stratum);
        }
    }

    public byte getLeapIndicator() {
        return this.leapIndicator;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getMode() {
        return this.mode;
    }

    public short getStratum() {
        return this.stratum;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public int getPrecision() {
        return this.precision;
    }

    public double getRootDelay() {
        return this.rootDelay;
    }

    public double getRootDispersion() {
        return this.rootDispersion;
    }

    public String getReferenceIdentifier() {
        return this.getRefIDAsString();
    }

    public double getReferenceTimestamp() {
        return this.referenceTimestamp;
    }

    public double getOriginateTimestamp() {
        return this.originateTimestamp;
    }

    public double getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public double getTransmitTimestamp() {
        return this.transmitTimestamp;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[version=");
        stringBuilder.append(this.version);
        stringBuilder.append(", mode=");
        switch (this.mode) {
            case 3: {
                stringBuilder.append("client");
                break;
            }
            case 4: {
                stringBuilder.append("server");
                break;
            }
            case 5: {
                stringBuilder.append("broadcast");
                break;
            }
            default: {
                stringBuilder.append(this.mode);
            }
        }
        stringBuilder.append(", leap-indicator=");
        stringBuilder.append(this.leapIndicator);
        stringBuilder.append(", stratum=");
        stringBuilder.append(this.stratum);
        stringBuilder.append(", poll-interval=");
        stringBuilder.append(this.pollInterval);
        stringBuilder.append(", precision=");
        stringBuilder.append(this.precision);
        stringBuilder.append(", root-delay=");
        stringBuilder.append(this.rootDelay);
        stringBuilder.append(", root-dispersion=");
        stringBuilder.append(this.rootDispersion);
        stringBuilder.append(", reference-identifier=");
        stringBuilder.append(this.getRefIDAsString());
        stringBuilder.append(", reference-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.referenceTimestamp));
        stringBuilder.append(", originate-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.originateTimestamp));
        stringBuilder.append(", receive-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.receiveTimestamp));
        stringBuilder.append(", transmit-timestamp=");
        stringBuilder.append(SntpMessage.toString(this.transmitTimestamp));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static long convert(double d) {
        return (long)(d * 1000000.0 - 2.2089888E15);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[48];
        byArray[0] = (byte)(this.leapIndicator << 6 | this.version << 3 | this.mode);
        if (this.mode != 3) {
            byArray[1] = (byte)this.stratum;
            byArray[2] = (byte)this.pollInterval;
            byArray[3] = this.precision;
            int n = (int)(this.rootDelay * 65536.0);
            byArray[4] = (byte)(n >> 24 & 0xFF);
            byArray[5] = (byte)(n >> 16 & 0xFF);
            byArray[6] = (byte)(n >> 8 & 0xFF);
            byArray[7] = (byte)(n & 0xFF);
            long l = (long)(this.rootDispersion * 65536.0);
            byArray[8] = (byte)(l >> 24 & 0xFFL);
            byArray[9] = (byte)(l >> 16 & 0xFFL);
            byArray[10] = (byte)(l >> 8 & 0xFFL);
            byArray[11] = (byte)(l & 0xFFL);
            for (int i = 0; i < 4; ++i) {
                byArray[12 + i] = this.refID[i];
            }
            SntpMessage.encode(byArray, 16, this.referenceTimestamp);
            SntpMessage.encode(byArray, 24, this.originateTimestamp);
            SntpMessage.encode(byArray, 32, this.receiveTimestamp);
        }
        SntpMessage.encode(byArray, 40, this.transmitTimestamp);
        return byArray;
    }

    static double getLocalTimestamp() {
        long l = SystemClock.MONOTONIC.currentTimeInMicros();
        return (double)(l + 2208988800000000L) / 1000000.0;
    }

    private String getRefIDAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.stratum == 0 || this.stratum == 1) {
            char c;
            for (int i = 0; i < 4 && (c = (char)this.refID[i]) != '\u0000'; ++i) {
                stringBuilder.append(c);
            }
        } else if (this.version == 3) {
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[0]));
            stringBuilder.append('.');
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[1]));
            stringBuilder.append('.');
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[2]));
            stringBuilder.append('.');
            stringBuilder.append(SntpMessage.toUnsigned(this.refID[3]));
        } else {
            if (this.version == 4) {
                int n = 0;
                for (int i = 0; i < 4; ++i) {
                    int n2 = this.refID[i] & 0xFF;
                    n |= n2 << 24 - i * 8;
                }
                return Integer.toHexString(n);
            }
            stringBuilder.append('?');
        }
        return stringBuilder.toString();
    }

    private static String toString(double d) {
        long l = SntpMessage.convert(d);
        Moment moment = Moment.of((long)(l / 1000000L), (int)((int)(l % 1000000L * 1000L)), (TimeScale)TimeScale.POSIX);
        return moment.toString();
    }

    private static double decode(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            long l2 = byArray[i + n] & 0xFF;
            l |= l2 << 56 - i * 8;
        }
        long l3 = l >>> 32 & 0xFFFFFFFFL;
        long l4 = (l & 0xFFFFFFFFL) * 1000000L >>> 32;
        long l5 = (l3 & 0x80000000L) == 0L ? -2085978496000000L : 2208988800000000L;
        long l6 = l3 * 1000000L + l4 - l5;
        return (double)(l6 + 2208988800000000L) / 1000000.0;
    }

    private static void encode(byte[] byArray, int n, double d) {
        long l = SntpMessage.convert(d);
        boolean bl = l + -2085978496000000L < 0L;
        long l2 = bl ? l + 2208988800000000L : l + -2085978496000000L;
        long l3 = l2 / 1000000L;
        long l4 = (l2 % 1000000L << 32) / 1000000L;
        if (bl) {
            l3 |= 0x80000000L;
        }
        long l5 = l3 << 32 | l4;
        for (int i = 7; i >= 0; --i) {
            byArray[i + n] = (byte)(l5 & 0xFFL);
            l5 >>>= 8;
        }
        byArray[7 + n] = (byte)(Math.random() * 256.0);
    }

    private static short toUnsigned(byte by) {
        short s = by;
        if ((by & 0x80) == 128) {
            s = (short)(128 + (by & 0x7F));
        }
        return s;
    }
}

