/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ServiceLoader;
import net.time4j.Moment;
import net.time4j.SI;
import net.time4j.SystemClock;
import net.time4j.clock.AbstractClock;
import net.time4j.clock.NetTimeConfiguration;
import net.time4j.scale.TimeScale;

public abstract class NetTimeConnector<C extends NetTimeConfiguration>
extends AbstractClock {
    private static final int MIO = 1000000;
    private final Moment startMoment;
    private final C defaultNTC;
    private volatile ConnectionResult result;
    private volatile PrintWriter writer;
    private volatile C ntc;

    protected NetTimeConnector(C c) {
        if (c == null) {
            throw new NullPointerException("Missing configuration parameters.");
        }
        this.startMoment = SystemClock.MONOTONIC.currentTime();
        this.defaultNTC = c;
        this.result = null;
        this.writer = null;
        this.ntc = c;
    }

    public Moment currentTime() {
        ConnectionResult connectionResult = this.result;
        if (connectionResult == null) {
            return this.startMoment;
        }
        long l = SystemClock.MONOTONIC.realTimeInMicros();
        long l2 = l + connectionResult.getActualOffset(l) - NetTimeConnector.extractMicros(connectionResult.lastMoment);
        return connectionResult.lastMoment.plus(l2 * 1000L, SI.NANOSECONDS);
    }

    public boolean isRunning() {
        return this.result != null;
    }

    public final void connect() throws IOException {
        try {
            Moment moment = this.doConnect();
            long l = SystemClock.MONOTONIC.realTimeInMicros();
            ConnectionResult connectionResult = this.result;
            long l2 = connectionResult == null ? Long.MIN_VALUE : connectionResult.getActualOffset(l);
            this.result = new ConnectionResult(moment, l, l2, this.getNetTimeConfiguration().getClockShiftWindow());
        }
        catch (ParseException parseException) {
            throw new IOException("Cannot read server reply.", parseException);
        }
    }

    public final boolean reconfigure() {
        try {
            this.ntc = this.loadNetTimeConfiguration();
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace(System.err);
            return false;
        }
    }

    public C getNetTimeConfiguration() {
        return this.ntc;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public boolean isLogEnabled() {
        return this.writer != null;
    }

    public Moment getLastConnectionTime() {
        ConnectionResult connectionResult = this.result;
        return connectionResult == null ? null : connectionResult.lastMoment;
    }

    public long getLastOffsetInMicros() {
        return this.getLastOffset(SystemClock.MONOTONIC.realTimeInMicros());
    }

    protected abstract Moment doConnect() throws IOException, ParseException;

    protected synchronized C loadNetTimeConfiguration() {
        ServiceLoader<NetTimeConfiguration> serviceLoader = ServiceLoader.load(this.getConfigurationType());
        NetTimeConfiguration netTimeConfiguration = null;
        for (NetTimeConfiguration netTimeConfiguration2 : serviceLoader) {
            if (netTimeConfiguration2 == null) continue;
            netTimeConfiguration = netTimeConfiguration2;
            break;
        }
        if (netTimeConfiguration == null) {
            netTimeConfiguration = this.defaultNTC;
        }
        String string = netTimeConfiguration.getTimeServerAddress();
        int n = netTimeConfiguration.getTimeServerPort();
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalStateException("Missing time server address.");
        }
        if (netTimeConfiguration.getConnectionTimeout() < 0) {
            throw new IllegalStateException("Negative time out.");
        }
        if (n < 0 || n > 65536) {
            throw new IllegalStateException("Port out of range: " + n);
        }
        if (netTimeConfiguration.getClockShiftWindow() < 0) {
            throw new IllegalStateException("Clock shift window is negative.");
        }
        return (C)netTimeConfiguration;
    }

    protected void log(String string, String string2) {
        PrintWriter printWriter = this.writer;
        if (printWriter != null) {
            if (string == null) {
                printWriter.println(string2);
            } else {
                printWriter.println(string + string2);
            }
        }
    }

    protected abstract Class<C> getConfigurationType();

    long getLastOffset(long l) {
        ConnectionResult connectionResult = this.result;
        return connectionResult == null ? 0L : connectionResult.getActualOffset(l);
    }

    private static long extractMicros(Moment moment) {
        return moment.getElapsedTime(TimeScale.UTC) * 1000000L + (long)(moment.getNanosecond(TimeScale.UTC) / 1000);
    }

    private static class ConnectionResult {
        private final Moment lastMoment;
        private final long startTime;
        private final long startOffset;
        private final long endOffset;
        private final int window;

        ConnectionResult(Moment moment, long l, long l2, int n) {
            this.lastMoment = moment;
            this.startTime = l;
            this.startOffset = l2;
            this.endOffset = NetTimeConnector.extractMicros(moment) - l;
            this.window = n * 1000000;
        }

        long getActualOffset(long l) {
            if (this.window == 0 || this.startOffset <= this.endOffset || l - this.startTime >= (long)this.window) {
                return this.endOffset;
            }
            double d = Math.max(0.0, (double)(l - this.startTime));
            double d2 = (1.0 + Math.cos(Math.PI * d / (double)this.window)) / 2.0;
            return Math.round((double)this.endOffset + d2 * (double)(this.startOffset - this.endOffset));
        }
    }
}

