/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.sql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.TemporalType;
import net.time4j.base.GregorianDate;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.EpochDays;
import net.time4j.scale.TimeScale;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public abstract class JDBCAdapter<S, T>
extends TemporalType<S, T> {
    private static final boolean WITH_SQL_UTC_CONVERSION = Boolean.getBoolean("net.time4j.sql.utc.conversion");
    private static final PlainDate UNIX_DATE = PlainDate.of((long)0L, (EpochDays)EpochDays.UNIX);
    public static final JDBCAdapter<Date, PlainDate> SQL_DATE = new SqlDateRule();
    public static final JDBCAdapter<Time, PlainTime> SQL_TIME = new SqlTimeRule();
    public static final JDBCAdapter<Timestamp, PlainTimestamp> SQL_TIMESTAMP = new SqlTimestampRule();

    private JDBCAdapter() {
    }

    private static class SqlTimestampRule
    extends JDBCAdapter<Timestamp, PlainTimestamp> {
        private SqlTimestampRule() {
        }

        public PlainTimestamp translate(Timestamp timestamp) {
            ZonalOffset zonalOffset;
            Moment moment;
            long l = timestamp.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                moment = Moment.of((long)MathUtils.floorDivide((long)l, (int)1000), (TimeScale)TimeScale.POSIX);
                zonalOffset = Timezone.ofSystem().getOffset((UnixTime)moment);
                l += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            moment = PlainDate.of((long)MathUtils.floorDivide((long)l, (int)86400000), (EpochDays)EpochDays.UNIX);
            zonalOffset = (PlainTime)PlainTime.of((int)0).plus((long)MathUtils.floorModulo((long)l, (int)86400000), (Object)ClockUnit.MILLIS);
            PlainTimestamp plainTimestamp = PlainTimestamp.of((PlainDate)moment, (PlainTime)zonalOffset);
            return (PlainTimestamp)plainTimestamp.with((ChronoElement)PlainTime.NANO_OF_SECOND, timestamp.getNanos());
        }

        public Timestamp from(PlainTimestamp plainTimestamp) {
            Object object;
            long l = MathUtils.safeMultiply((long)((Long)plainTimestamp.getCalendarDate().get((ChronoElement)EpochDays.UNIX)), (long)86400000L);
            long l2 = ((Integer)plainTimestamp.get((ChronoElement)PlainTime.MILLI_OF_DAY)).intValue();
            if (!WITH_SQL_UTC_CONVERSION) {
                object = Timezone.ofSystem().getOffset((GregorianDate)plainTimestamp, (WallTime)plainTimestamp);
                l2 -= (long)(object.getIntegralAmount() * 1000);
            }
            object = new Timestamp(MathUtils.safeAdd((long)l, (long)l2));
            ((Timestamp)object).setNanos((Integer)plainTimestamp.get((ChronoElement)PlainTime.NANO_OF_SECOND));
            return object;
        }
    }

    private static class SqlTimeRule
    extends JDBCAdapter<Time, PlainTime> {
        private SqlTimeRule() {
        }

        public PlainTime translate(Time time) {
            long l = time.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of((long)MathUtils.floorDivide((long)l, (int)1000), (TimeScale)TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset((UnixTime)moment);
                l += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return (PlainTime)PlainTime.midnightAtStartOfDay().with((ChronoElement)PlainTime.MILLI_OF_DAY, MathUtils.floorModulo((long)l, (int)86400000));
        }

        public Time from(PlainTime plainTime) {
            long l = ((Integer)plainTime.get((ChronoElement)PlainTime.MILLI_OF_DAY)).intValue();
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset((GregorianDate)UNIX_DATE, (WallTime)plainTime);
                l -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Time(l);
        }
    }

    private static class SqlDateRule
    extends JDBCAdapter<Date, PlainDate> {
        private SqlDateRule() {
        }

        public PlainDate translate(Date date) {
            long l = date.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of((long)MathUtils.floorDivide((long)l, (int)1000), (TimeScale)TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset((UnixTime)moment);
                l += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return (PlainDate)PlainDate.axis().getCalendarSystem().transform(MathUtils.floorDivide((long)l, (int)86400000) - 730L);
        }

        public Date from(PlainDate plainDate) {
            int n = plainDate.getYear();
            if (n < 1900 || n > 9999) {
                throw new ChronoException("SQL-Date is only defined in year range of 1900-9999.");
            }
            long l = MathUtils.safeMultiply((long)((Long)plainDate.get((ChronoElement)EpochDays.UNIX)), (long)86400000L);
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset((GregorianDate)plainDate, (WallTime)PlainTime.of((int)0));
                l -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Date(l);
        }
    }
}

