/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.RuleNotFoundException;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;

public final class TimeAxis<U, T extends TimePoint<U, T>>
extends Chronology<T>
implements Comparator<U> {
    private final Class<U> unitType;
    private final Map<U, UnitRule<T>> unitRules;
    private final Map<U, Double> unitLengths;
    private final Map<U, Set<U>> convertibleUnits;
    private final Map<ChronoElement<?>, U> baseUnits;
    private final T min;
    private final T max;
    private final CalendarSystem<T> calendarSystem;
    private final ChronoElement<T> self;

    private TimeAxis(Class<T> clazz, Class<U> clazz2, ChronoMerger<T> chronoMerger, Map<ChronoElement<?>, ElementRule<T, ?>> map, Map<U, UnitRule<T>> map2, Map<U, Double> map3, Map<U, Set<U>> map4, List<ChronoExtension> list, Map<ChronoElement<?>, U> map5, T t, T t2, CalendarSystem<T> calendarSystem) {
        super(clazz, chronoMerger, map, list);
        this.unitType = clazz2;
        this.unitRules = Collections.unmodifiableMap(map2);
        this.unitLengths = Collections.unmodifiableMap(map3);
        this.convertibleUnits = Collections.unmodifiableMap(map4);
        this.baseUnits = Collections.unmodifiableMap(map5);
        this.min = t;
        this.max = t2;
        this.calendarSystem = calendarSystem;
        this.self = new SelfElement<T>(clazz, t, t2);
    }

    public Class<U> getUnitType() {
        return this.unitType;
    }

    public Set<U> getRegisteredUnits() {
        return this.unitRules.keySet();
    }

    public boolean isRegistered(U u) {
        return this.unitRules.containsKey(u);
    }

    public boolean isSupported(U u) {
        if (this.isRegistered(u)) {
            return true;
        }
        if (u instanceof UnitRule.Source) {
            return ((UnitRule.Source)UnitRule.Source.class.cast(u)).derive(this) != null;
        }
        return false;
    }

    public double getLength(U u) {
        Double d = this.unitLengths.get(u);
        if (d == null) {
            if (u instanceof ChronoUnit) {
                return ((ChronoUnit)ChronoUnit.class.cast(u)).getLength();
            }
            return Double.NaN;
        }
        return d;
    }

    public boolean isConvertible(U u, U u2) {
        Set<U> set = this.convertibleUnits.get(u);
        return set != null && set.contains(u2);
    }

    @Override
    public int compare(U u, U u2) {
        return Double.compare(this.getLength(u2), this.getLength(u));
    }

    public boolean hasBaseUnit(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            return false;
        }
        boolean bl = this.baseUnits.containsKey(chronoElement);
        if (!bl && chronoElement instanceof BasicElement) {
            ChronoElement<?> chronoElement2 = ((BasicElement)chronoElement).getParent();
            bl = chronoElement2 != null && this.baseUnits.containsKey(chronoElement2);
        }
        return bl;
    }

    public U getBaseUnit(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        U u = this.baseUnits.get(chronoElement);
        if (u == null && chronoElement instanceof BasicElement) {
            ChronoElement<?> chronoElement2 = ((BasicElement)chronoElement).getParent();
            u = this.baseUnits.get(chronoElement2);
        }
        if (u == null) {
            throw new ChronoException("Base unit not found for: " + chronoElement.name());
        }
        return u;
    }

    public T getMinimum() {
        return this.min;
    }

    public T getMaximum() {
        return this.max;
    }

    @Override
    public boolean hasCalendarSystem() {
        return this.calendarSystem != null;
    }

    @Override
    public CalendarSystem<T> getCalendarSystem() {
        if (this.calendarSystem == null) {
            return super.getCalendarSystem();
        }
        return this.calendarSystem;
    }

    public ChronoElement<T> element() {
        return this.self;
    }

    UnitRule<T> getRule(U u) {
        UnitRule unitRule;
        if (u == null) {
            throw new NullPointerException("Missing chronological unit.");
        }
        if (this.isRegistered(u)) {
            return this.unitRules.get(u);
        }
        if (u instanceof UnitRule.Source && (unitRule = ((UnitRule.Source)UnitRule.Source.class.cast(u)).derive(this)) != null) {
            return unitRule;
        }
        throw new RuleNotFoundException(this, u);
    }

    /* synthetic */ TimeAxis(Class clazz, Class clazz2, ChronoMerger chronoMerger, Map map, Map map2, Map map3, Map map4, List list, Map map5, TimePoint timePoint, TimePoint timePoint2, CalendarSystem calendarSystem, 1 var13_13) {
        this(clazz, clazz2, chronoMerger, map, map2, map3, map4, list, map5, timePoint, timePoint2, calendarSystem);
    }

    static class 1 {
    }

    private static class SelfElement<T extends TimePoint<?, T>>
    extends BasicElement<T>
    implements ElementRule<T, T> {
        private static final long serialVersionUID = 4777240530511579802L;
        private final Class<T> type;
        private final T min;
        private final T max;

        SelfElement(Class<T> clazz, T t, T t2) {
            super(clazz.getName() + "-AXIS");
            this.type = clazz;
            this.min = t;
            this.max = t2;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
            TimePoint timePoint = (TimePoint)chronoEntity.get(this);
            TimePoint timePoint2 = (TimePoint)chronoEntity2.get(this);
            return timePoint.compareTo(timePoint2);
        }

        @Override
        public T getDefaultMinimum() {
            return this.min;
        }

        @Override
        public T getDefaultMaximum() {
            return this.max;
        }

        @Override
        public boolean isDateElement() {
            return false;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public T getValue(T t) {
            return t;
        }

        @Override
        public T getMinimum(T t) {
            return (T)this.getDefaultMinimum();
        }

        @Override
        public T getMaximum(T t) {
            return (T)this.getDefaultMaximum();
        }

        @Override
        public boolean isValid(T t, T t2) {
            return t2 != null;
        }

        @Override
        public T withValue(T t, T t2, boolean bl) {
            if (t2 == null) {
                throw new NullPointerException("Missing value.");
            }
            return t2;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected <X extends ChronoEntity<X>> ElementRule<X, T> derive(Chronology<X> chronology) {
            if (chronology.getChronoType().equals(this.type)) {
                return this;
            }
            return null;
        }
    }

    public static final class Builder<U, T extends TimePoint<U, T>>
    extends Chronology.Builder<T> {
        private final Class<U> unitType;
        private final Map<U, UnitRule<T>> unitRules;
        private final Map<U, Double> unitLengths;
        private final Map<U, Set<U>> convertibleUnits;
        private final Map<ChronoElement<?>, U> baseUnits;
        private final T min;
        private final T max;
        private final CalendarSystem<T> calendarSystem;

        private Builder(Class<U> clazz, Class<T> clazz2, ChronoMerger<T> chronoMerger, T t, T t2, CalendarSystem<T> calendarSystem) {
            super(clazz2, chronoMerger);
            if (clazz == null) {
                throw new NullPointerException("Missing unit type.");
            }
            if (t == null) {
                throw new NullPointerException("Missing minimum of range.");
            }
            if (t2 == null) {
                throw new NullPointerException("Missing maximum of range.");
            }
            if (Calendrical.class.isAssignableFrom(clazz2) && calendarSystem == null) {
                throw new NullPointerException("Missing calendar system.");
            }
            this.unitType = clazz;
            this.unitRules = new HashMap<U, UnitRule<T>>();
            this.unitLengths = new HashMap<U, Double>();
            this.convertibleUnits = new HashMap<U, Set<U>>();
            this.baseUnits = new HashMap();
            this.min = t;
            this.max = t2;
            this.calendarSystem = calendarSystem;
        }

        public static <U, T extends TimePoint<U, T>> Builder<U, T> setUp(Class<U> clazz, Class<T> clazz2, ChronoMerger<T> chronoMerger, T t, T t2) {
            return new Builder<U, T>(clazz, clazz2, chronoMerger, t, t2, null);
        }

        public static <U, D extends Calendrical<U, D>> Builder<U, D> setUp(Class<U> clazz, Class<D> clazz2, ChronoMerger<D> chronoMerger, CalendarSystem<D> calendarSystem) {
            CalendarSystem<D> calendarSystem2 = calendarSystem;
            Builder<U, TimePoint> builder = new Builder<U, TimePoint>(clazz, clazz2, chronoMerger, (TimePoint)calendarSystem2.transform(calendarSystem2.getMinimumSinceUTC()), (TimePoint)calendarSystem2.transform(calendarSystem2.getMaximumSinceUTC()), calendarSystem2);
            for (EpochDays epochDays : EpochDays.values()) {
                builder.appendElement((ChronoElement)epochDays, epochDays.derive(calendarSystem2));
            }
            return builder;
        }

        public <V> Builder<U, T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule) {
            super.appendElement(chronoElement, elementRule);
            return this;
        }

        public <V> Builder<U, T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule, U u) {
            if (u == null) {
                throw new NullPointerException("Missing base unit.");
            }
            super.appendElement(chronoElement, elementRule);
            this.baseUnits.put(chronoElement, u);
            return this;
        }

        public Builder<U, T> appendUnit(U u, UnitRule<T> unitRule, double d) {
            Set set = Collections.emptySet();
            return this.appendUnit(u, unitRule, d, set);
        }

        public Builder<U, T> appendUnit(U u, UnitRule<T> unitRule, double d, Set<? extends U> set) {
            this.checkUnitDuplicates(u);
            if (set.contains(null)) {
                throw new NullPointerException("Found convertible unit which is null.");
            }
            if (Double.isNaN(d)) {
                throw new IllegalArgumentException("Not a number: " + d);
            }
            if (Double.isInfinite(d)) {
                throw new IllegalArgumentException("Infinite: " + d);
            }
            this.unitRules.put(u, unitRule);
            this.unitLengths.put(u, d);
            HashSet<U> hashSet = new HashSet<U>(set);
            hashSet.remove(u);
            this.convertibleUnits.put(u, hashSet);
            return this;
        }

        public Builder<U, T> appendExtension(ChronoExtension chronoExtension) {
            super.appendExtension(chronoExtension);
            return this;
        }

        public TimeAxis<U, T> build() {
            TimeAxis timeAxis = new TimeAxis(this.chronoType, this.unitType, this.merger, this.ruleMap, this.unitRules, this.unitLengths, this.convertibleUnits, this.extensions, this.baseUnits, (TimePoint)this.min, (TimePoint)this.max, this.calendarSystem, null);
            Chronology.register(timeAxis);
            return timeAxis;
        }

        private void checkUnitDuplicates(U u) {
            for (Object object : this.unitRules.keySet()) {
                if (!object.equals(u)) continue;
                throw new IllegalArgumentException("Unit duplicate found: " + u.toString());
            }
            if (u instanceof Enum) {
                String string = ((Enum)Enum.class.cast(u)).name();
                for (Object e : this.unitRules.keySet()) {
                    if (!(e instanceof Enum) || !((Enum)Enum.class.cast(e)).name().equals(string)) continue;
                    throw new IllegalArgumentException("Unit duplicate found: " + (String)string);
                }
            }
        }
    }
}

