/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.time4j.base.MathUtils;
import net.time4j.engine.AbstractDuration;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;

public abstract class AbstractMetric<U extends ChronoUnit, P extends AbstractDuration<U>>
implements TimeMetric<U, P>,
Comparator<U> {
    private static final int MIO = 1000000;
    private final List<U> sortedUnits;
    private final boolean normalizing;

    public AbstractMetric(boolean bl, U ... UArray) {
        for (int i = 0; i < UArray.length - 1; ++i) {
            for (int j = i + 1; j < UArray.length; ++j) {
                if (!UArray[i].equals(UArray[j])) continue;
                throw new IllegalArgumentException("Duplicate unit: " + UArray[i]);
            }
        }
        Arrays.sort(UArray, this);
        this.sortedUnits = Collections.unmodifiableList(Arrays.asList(UArray));
        this.normalizing = bl;
    }

    public AbstractMetric(boolean bl, Set<U> set) {
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Missing units.");
        }
        ArrayList<U> arrayList = new ArrayList<U>(set);
        Collections.sort(arrayList, this);
        this.sortedUnits = Collections.unmodifiableList(arrayList);
        this.normalizing = bl;
    }

    @Override
    public int compare(U u, U u2) {
        return Double.compare(u2.getLength(), u.getLength());
    }

    @Override
    public <T extends TimePoint<? super U, T>> P between(T t, T t2) {
        Object object;
        if (t2.equals(t)) {
            return this.createEmptyTimeSpan();
        }
        T t3 = t;
        T t4 = t2;
        boolean bl = false;
        if (t3.compareTo(t4) > 0) {
            object = t3;
            t3 = t2;
            t4 = object;
            bl = true;
        }
        object = new ArrayList(10);
        Chronology chronology = t.getChronology();
        ChronoUnit chronoUnit = null;
        long l = 0L;
        int n = this.sortedUnits.size();
        for (int i = 0; i < n; ++i) {
            ChronoUnit chronoUnit2;
            int n2;
            if (l != 0L) {
                t3 = t3.plus(l, chronoUnit);
            }
            if (this.getLength((TimeAxis<? super U, T>)chronology, (U)(chronoUnit = (ChronoUnit)this.sortedUnits.get(i))) < 1.0 && i < n - 1) {
                l = 0L;
                continue;
            }
            long l2 = 1L;
            for (n2 = i + 1; n2 < n && (l2 *= this.getFactor((TimeAxis<? super U, T>)chronology, (U)chronoUnit, (U)(chronoUnit2 = (ChronoUnit)this.sortedUnits.get(n2)))) < 1000000L && ((TimeAxis)chronology).isConvertible(chronoUnit, chronoUnit2); ++n2) {
                chronoUnit = chronoUnit2;
            }
            i = n2 - 1;
            l = t3.until(t4, (ChronoUnit)chronoUnit);
            if (l > 0L) {
                object.add(TimeSpan.Item.of(l, chronoUnit));
                continue;
            }
            if (l >= 0L) continue;
            throw new IllegalStateException("Implementation error: Cannot compute timespan due to illegal negative timespan amounts.");
        }
        if (this.normalizing) {
            this.normalize((TimeAxis<? super U, T>)chronology, this.sortedUnits, (List<TimeSpan.Item<U>>)object);
        }
        return this.createTimeSpan((List<TimeSpan.Item<U>>)object, bl);
    }

    protected abstract P createEmptyTimeSpan();

    protected abstract P createTimeSpan(List<TimeSpan.Item<U>> var1, boolean var2);

    private <T extends TimePoint<? super U, T>> void normalize(TimeAxis<? super U, T> timeAxis, List<U> list, List<TimeSpan.Item<U>> list2) {
        for (int i = list.size() - 1; i >= 0; --i) {
            long l;
            long l2;
            TimeSpan.Item<ChronoUnit> item;
            if (i <= 0) continue;
            ChronoUnit chronoUnit = (ChronoUnit)list.get(i);
            ChronoUnit chronoUnit2 = (ChronoUnit)list.get(i - 1);
            long l3 = this.getFactor(timeAxis, chronoUnit2, chronoUnit);
            if (l3 >= 1000000L || !timeAxis.isConvertible(chronoUnit2, chronoUnit) || (item = AbstractMetric.getItem(list2, chronoUnit)) == null || (l2 = (l = item.getAmount()) / l3) <= 0L) continue;
            long l4 = l % l3;
            if (l4 == 0L) {
                AbstractMetric.removeItem(list2, chronoUnit);
            } else {
                AbstractMetric.putItem(list2, timeAxis, l4, chronoUnit);
            }
            TimeSpan.Item<ChronoUnit> item2 = AbstractMetric.getItem(list2, chronoUnit2);
            if (item2 == null) {
                AbstractMetric.putItem(list2, timeAxis, l2, chronoUnit2);
                continue;
            }
            AbstractMetric.putItem(list2, timeAxis, MathUtils.safeAdd(item2.getAmount(), l2), chronoUnit2);
        }
    }

    private static <U> TimeSpan.Item<U> getItem(List<TimeSpan.Item<U>> list, U u) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            TimeSpan.Item<U> item = list.get(i);
            if (!item.getUnit().equals(u)) continue;
            return item;
        }
        return null;
    }

    private static <U> void putItem(List<TimeSpan.Item<U>> list, Comparator<? super U> comparator, long l, U u) {
        TimeSpan.Item<U> item = TimeSpan.Item.of(l, u);
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            U u2 = list.get(i).getUnit();
            if (u2.equals(u)) {
                list.set(i, item);
                return;
            }
            if (n != i || comparator.compare(u2, u) >= 0) continue;
            ++n;
        }
        list.add(n, item);
    }

    private static <U> void removeItem(List<TimeSpan.Item<U>> list, U u) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!list.get(i).getUnit().equals(u)) continue;
            list.remove(i);
            return;
        }
    }

    private <T extends TimePoint<? super U, T>> long getFactor(TimeAxis<? super U, T> timeAxis, U u, U u2) {
        double d = this.getLength(timeAxis, u);
        double d2 = this.getLength(timeAxis, u2);
        return Math.round(d / d2);
    }

    private <T extends TimePoint<? super U, T>> double getLength(TimeAxis<? super U, T> timeAxis, U u) {
        return timeAxis.getLength(u);
    }
}

