/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.Moment;
import net.time4j.ZonalClock;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;

public final class SystemClock
implements TimeSource<Moment> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final long CALIBRATED_OFFSET;
    private static final boolean HIGH_PRECISION;
    public static final SystemClock INSTANCE;
    private final Clock source = HIGH_PRECISION ? Clock.PRECISION : Clock.STANDARD;

    private SystemClock() {
    }

    @Override
    public Moment currentTime() {
        return this.source.getTime();
    }

    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }

    public long currentTimeInMicros() {
        return this.source.getMicros();
    }

    public static ZonalClock inLocalView() {
        return ZonalClock.ofSystem();
    }

    public static ZonalClock inZonalView(TZID tZID) {
        return new ZonalClock(INSTANCE, tZID);
    }

    public static ZonalClock inZonalView(String string) {
        return new ZonalClock(INSTANCE, string);
    }

    static {
        HIGH_PRECISION = Boolean.getBoolean("net.time4j.systemclock.nanoTime");
        if (HIGH_PRECISION) {
            long l = System.currentTimeMillis();
            long l2 = 0L;
            for (int i = 0; i < 10; ++i) {
                l2 = System.nanoTime();
                long l3 = System.currentTimeMillis();
                if (l == l3) break;
                l = l3;
            }
            CALIBRATED_OFFSET = MathUtils.safeSubtract(MathUtils.safeMultiply(l, 1000000L), l2);
        } else {
            CALIBRATED_OFFSET = 0L;
        }
        INSTANCE = new SystemClock();
    }

    private static enum Clock {
        STANDARD{

            @Override
            Moment getTime() {
                long l = System.currentTimeMillis();
                int n = (int)(l % 1000L) * 1000000;
                return Moment.of(l / 1000L, n, TimeScale.POSIX);
            }

            @Override
            long getMicros() {
                return MathUtils.safeMultiply(System.currentTimeMillis(), 1000L);
            }
        }
        ,
        PRECISION{

            @Override
            Moment getTime() {
                long l = this.getNanos();
                return Moment.of(l / 1000000000L, (int)(l % 1000000000L), TimeScale.POSIX);
            }

            @Override
            long getMicros() {
                return this.getNanos() / 1000L;
            }

            private long getNanos() {
                return MathUtils.safeAdd(System.nanoTime(), CALIBRATED_OFFSET);
            }
        };


        abstract Moment getTime();

        abstract long getMicros();
    }
}

