/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import net.time4j.AbstractDateElement;
import net.time4j.PlainDate;
import net.time4j.ProportionalElement;
import net.time4j.ProportionalFunction;
import net.time4j.RoundingOperator;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.NumericalElement;

final class IntegerDateElement
extends AbstractDateElement<Integer>
implements ProportionalElement<Integer, PlainDate>,
NumericalElement<Integer> {
    static final int YEAR = 14;
    static final int MONTH = 15;
    static final int DAY_OF_MONTH = 16;
    static final int DAY_OF_YEAR = 17;
    static final int DAY_OF_QUARTER = 18;
    static final int YEAR_OF_ERA = 19;
    private static final long serialVersionUID = -1337148214680014674L;
    private final transient int index;
    private final transient Integer defaultMin;
    private final transient Integer defaultMax;
    private final transient char symbol;
    private final transient ChronoFunction<ChronoEntity<?>, BigDecimal> rf;

    private IntegerDateElement(String string, int n, Integer n2, Integer n3, char c) {
        super(string);
        this.index = n;
        this.defaultMin = n2;
        this.defaultMax = n3;
        this.symbol = c;
        this.rf = new ProportionalFunction(this, false);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public Integer getDefaultMinimum() {
        return this.defaultMin;
    }

    @Override
    public Integer getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public int numerical(Integer n) {
        return n;
    }

    @Override
    public ChronoFunction<ChronoEntity<?>, BigDecimal> ratio() {
        return this.rf;
    }

    @Override
    public ChronoOperator<PlainDate> roundedUp(int n) {
        return new RoundingOperator<PlainDate>(this, Boolean.TRUE, n);
    }

    @Override
    public ChronoOperator<PlainDate> roundedHalf(int n) {
        return new RoundingOperator<PlainDate>(this, null, n);
    }

    @Override
    public ChronoOperator<PlainDate> roundedDown(int n) {
        return new RoundingOperator<PlainDate>(this, Boolean.FALSE, n);
    }

    @Override
    protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
        if (this.index == 19 && chronology.isRegistered(PlainDate.CALENDAR_DATE)) {
            return new ElementRule<T, Integer>(){

                @Override
                public Integer getValue(T t) {
                    int n = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE).getYear();
                    return n <= 0 ? 1 - n : n;
                }

                @Override
                public Integer getMinimum(T t) {
                    return 1;
                }

                @Override
                public Integer getMaximum(T t) {
                    return 999999999;
                }

                @Override
                public boolean isValid(T t, Integer n) {
                    return n != null && n.compareTo(this.getMaximum((T)t)) <= 0 && n.compareTo(this.getMinimum((T)t)) >= 0;
                }

                @Override
                public T withValue(T t, Integer n, boolean bl) {
                    if (n == null) {
                        throw new NullPointerException("Missing year of era.");
                    }
                    if (!this.isValid(t, n)) {
                        throw new IllegalArgumentException("Invalid year of era: " + n);
                    }
                    PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
                    if (plainDate.getYear() <= 0) {
                        int n2 = 1 - n;
                        plainDate = (PlainDate)plainDate.with((ChronoElement<Integer>)PlainDate.YEAR, n2);
                    } else {
                        plainDate = (PlainDate)plainDate.with(PlainDate.YEAR, n);
                    }
                    return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
                }

                @Override
                public ChronoElement<?> getChildAtFloor(T t) {
                    return PlainDate.MONTH_AS_NUMBER;
                }

                @Override
                public ChronoElement<?> getChildAtCeiling(T t) {
                    return PlainDate.MONTH_AS_NUMBER;
                }
            };
        }
        return null;
    }

    int getIndex() {
        return this.index;
    }

    static IntegerDateElement create(String string, int n, int n2, int n3, char c) {
        return new IntegerDateElement(string, n, n2, n3, c);
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainDate.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

