/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ElementOperator;
import net.time4j.LenientOperator;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.engine.AdvancedElement;
import net.time4j.engine.ChronoOperator;

final class DateOperator
extends ElementOperator<PlainDate> {
    private final ChronoOperator<PlainDate> opCache;
    private final ChronoOperator<PlainTimestamp> tsCache;
    private final ChronoOperator<Moment> moCache;

    DateOperator(AdvancedElement<?> advancedElement, int n) {
        this(advancedElement, n, null);
    }

    DateOperator(AdvancedElement<?> advancedElement, int n, Object object) {
        super(advancedElement, n);
        switch (n) {
            case 0: {
                this.opCache = advancedElement.minimized(PlainDate.class);
                this.tsCache = advancedElement.minimized(PlainTimestamp.class);
                break;
            }
            case 1: {
                this.opCache = advancedElement.maximized(PlainDate.class);
                this.tsCache = advancedElement.maximized(PlainTimestamp.class);
                break;
            }
            case 2: {
                this.opCache = advancedElement.decremented(PlainDate.class);
                this.tsCache = advancedElement.decremented(PlainTimestamp.class);
                break;
            }
            case 3: {
                this.opCache = advancedElement.incremented(PlainDate.class);
                this.tsCache = advancedElement.incremented(PlainTimestamp.class);
                break;
            }
            case 4: {
                this.opCache = advancedElement.atFloor(PlainDate.class);
                this.tsCache = advancedElement.atFloor(PlainTimestamp.class);
                break;
            }
            case 5: {
                this.opCache = advancedElement.atCeiling(PlainDate.class);
                this.tsCache = advancedElement.atCeiling(PlainTimestamp.class);
                break;
            }
            case 6: {
                this.opCache = DateOperator.lenient(advancedElement, object);
                this.tsCache = DateOperator.lenientTS(advancedElement, object);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + this.getType()));
            }
        }
        this.moCache = new Moment.Operator(this.tsCache, advancedElement, n);
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        return this.opCache.apply(plainDate);
    }

    @Override
    public ChronoOperator<Moment> inStdTimezone() {
        return this.moCache;
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return this.tsCache;
    }

    private static <V extends Comparable<V>> ChronoOperator<PlainDate> lenient(AdvancedElement<V> advancedElement, Object object) {
        return advancedElement.setLenient((Comparable)advancedElement.getType().cast(object), PlainDate.class);
    }

    private static <V extends Comparable<V>> ChronoOperator<PlainTimestamp> lenientTS(AdvancedElement<V> advancedElement, Object object) {
        return new LenientOperator(advancedElement.setLenient((Comparable)advancedElement.getType().cast(object), PlainTimestamp.class), Number.class.cast(object));
    }
}

