/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.compile.properties.PropertyList;
import net.officefloor.compile.section.SectionLoader;
import net.officefloor.compile.section.SectionType;
import net.officefloor.compile.spi.section.source.SectionSource;
import net.officefloor.eclipse.configurer.ChoiceBuilder;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.ConfigurationBuilder;
import net.officefloor.eclipse.configurer.PropertiesBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.osgi.OfficeFloorOsgiBridge;
import net.officefloor.eclipse.woof.WoofEditor;
import net.officefloor.eclipse.woof.WoofSectionInputItem;
import net.officefloor.eclipse.woof.WoofSectionOutputItem;
import net.officefloor.plugin.managedfunction.clazz.FlowInterface;
import net.officefloor.plugin.section.clazz.ClassSectionSource;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofSectionModel;

public class WoofSectionItem
extends AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, WoofSectionModel, WoofSectionModel.WoofSectionEvent, WoofSectionItem> {
    private static final int CHOICE_CLASS = 0;
    private String name;
    private Integer choice = null;
    private String sourceClassName;
    private String location;
    private PropertyList properties = OfficeFloorCompiler.newPropertyList();
    private SectionType sectionType;
    private Map<String, String> inputNameMapping;
    private Map<String, String> outputNameMapping;

    public static void main(String[] args) {
        WoofEditor.launchConfigurer(new WoofSectionItem(), model -> {
            model.setWoofSectionName("Section");
            model.setSectionSourceClassName(ClassSectionSource.class.getName());
            model.setSectionLocation(MockSection.class.getName());
        });
    }

    public static SectionType loadSectionType(WoofSectionItem item, OfficeFloorOsgiBridge osgiBridge) throws Exception {
        SectionLoader loader = osgiBridge.getOfficeFloorCompiler().getSectionLoader();
        Class sourceClass = osgiBridge.loadClass(item.sourceClassName, SectionSource.class);
        return loader.loadSectionType(sourceClass, item.location, item.properties);
    }

    public WoofSectionModel prototype() {
        return new WoofSectionModel("Section", null, null);
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, root -> root.getWoofSections(), (Enum[])new WoofModel.WoofEvent[]{WoofModel.WoofEvent.ADD_WOOF_SECTION, WoofModel.WoofEvent.REMOVE_WOOF_SECTION});
    }

    public void loadToParent(WoofModel parentModel, WoofSectionModel itemModel) {
        parentModel.addWoofSection(itemModel);
    }

    public Pane visual(WoofSectionModel model, AdaptedModelVisualFactoryContext<WoofSectionModel> context) {
        VBox container = new VBox();
        context.label((Pane)container);
        HBox children = (HBox)context.addNode((Pane)container, (Node)new HBox());
        VBox inputs = (VBox)context.addNode((Pane)children, (Node)new VBox());
        context.childGroup(WoofSectionInputItem.class.getSimpleName(), (Pane)inputs);
        VBox outputs = (VBox)context.addNode((Pane)children, (Node)new VBox());
        context.childGroup(WoofSectionOutputItem.class.getSimpleName(), (Pane)outputs);
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getWoofSectionName(), (Enum[])new WoofSectionModel.WoofSectionEvent[]{WoofSectionModel.WoofSectionEvent.CHANGE_WOOF_SECTION_NAME});
    }

    protected void loadStyles(List<AbstractItem.IdeStyle> styles) {
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 100.0%, green, mediumseagreen)"));
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .label").rule("-fx-text-fill", "honeydew"));
    }

    protected WoofSectionItem item(WoofSectionModel model) {
        WoofSectionItem item = new WoofSectionItem();
        if (model != null) {
            item.name = model.getWoofSectionName();
            item.sourceClassName = model.getSectionSourceClassName();
            item.location = model.getSectionLocation();
            item.properties = this.translateToPropertyList(model.getProperties(), p -> p.getName(), p -> p.getValue());
            if (ClassSectionSource.class.getName().equals(item.sourceClassName)) {
                item.choice = 0;
            }
        }
        return item;
    }

    protected void children(List<AbstractItem.IdeChildrenGroup> childGroups) {
        childGroups.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new WoofSectionInputItem()));
        childGroups.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new WoofSectionOutputItem()));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Section");
            ((TextBuilder)((TextBuilder)builder.text("Name").init(item -> item.name)).validate(ValueValidator.notEmptyString((String)"Must provide name"))).setValue((item, value) -> {
                String string = item.name = value;
            });
            ChoiceBuilder choices = (ChoiceBuilder)((ChoiceBuilder)((ChoiceBuilder)builder.choices("").init(item -> item.choice)).validate(ValueValidator.notNull((String)"Must select"))).setValue((item, value) -> {
                if (value == 0) {
                    item.sourceClassName = ClassSectionSource.class.getName();
                }
            });
            ConfigurationBuilder classBuilder = choices.choice("Class");
            ((ClassBuilder)((ClassBuilder)classBuilder.clazz("Class").init(item -> item.location)).validate(ValueValidator.notEmptyString((String)"Must specify class"))).setValue((item, value) -> {
                String string = item.location = value;
            });
            ConfigurationBuilder sourceBuilder = choices.choice("Source");
            ((ClassBuilder)((ClassBuilder)sourceBuilder.clazz("Source").init(item -> item.sourceClassName)).superType(SectionSource.class).validate(ValueValidator.notEmptyString((String)"Must specify source"))).setValue((item, value) -> {
                String string = item.sourceClassName = value;
            });
            ((TextBuilder)sourceBuilder.text("Location").init(item -> item.location)).setValue((item, value) -> {
                String string = item.location = value;
            });
            ((PropertiesBuilder)sourceBuilder.properties("Properties").init(item -> item.properties)).setValue((item, value) -> {
                PropertyList propertyList = item.properties = value;
            });
            builder.validate(ctx -> {
                OfficeFloorOsgiBridge osgiBridge = this.getConfigurableContext().getOsgiBridge();
                WoofSectionItem item = (WoofSectionItem)((Object)((Object)((Object)ctx.getModel())));
                item.sectionType = WoofSectionItem.loadSectionType(item, osgiBridge);
                item.inputNameMapping = this.translateToNameMappings(item.sectionType.getSectionInputTypes(), input -> input.getSectionInputName());
                item.outputNameMapping = this.translateToNameMappings(item.sectionType.getSectionOutputTypes(), output -> output.getSectionOutputName());
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((WoofChanges)context.getOperations()).addSection(item.name, item.sourceClassName, item.location, item.properties, item.sectionType)))).refactor((builder, context) -> builder.apply("Refactor", item -> context.execute(((WoofChanges)context.getOperations()).refactorSection((WoofSectionModel)context.getModel(), item.name, item.sourceClassName, item.location, item.properties, item.sectionType, item.inputNameMapping, item.outputNameMapping)))).delete(context -> context.execute(((WoofChanges)context.getOperations()).removeSection((WoofSectionModel)context.getModel())));
    }

    public static class MockSection {
        public void input(Flows flows) {
        }

        @FlowInterface
        public static interface Flows {
            public void flow();
        }
    }
}

