/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.util.List;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.configurer.FlagBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.woof.WoofEditor;
import net.officefloor.model.ConnectionModel;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofHttpInputModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofSectionInputModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofResourceModel;
import net.officefloor.woof.model.woof.WoofSectionInputModel;
import net.officefloor.woof.model.woof.WoofSecurityModel;
import net.officefloor.woof.model.woof.WoofTemplateModel;

public class WoofHttpInputItem
extends AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, WoofHttpInputModel, WoofHttpInputModel.WoofHttpInputEvent, WoofHttpInputItem> {
    private String httpMethod = "POST";
    private String applicationPath;
    private boolean isHttps = false;

    public static void main(String[] args) {
        WoofEditor.launchConfigurer(new WoofHttpInputItem(), model -> {
            model.setHttpMethod("POST");
            model.setApplicationPath("/path");
            model.setIsSecure(true);
        });
    }

    public WoofHttpInputModel prototype() {
        return new WoofHttpInputModel(false, "HTTP", "Input");
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getWoofHttpInputs(), (Enum[])new WoofModel.WoofEvent[]{WoofModel.WoofEvent.ADD_WOOF_HTTP_INPUT, WoofModel.WoofEvent.REMOVE_WOOF_HTTP_INPUT});
    }

    public Pane visual(WoofHttpInputModel model, AdaptedModelVisualFactoryContext<WoofHttpInputModel> context) {
        HBox container = new HBox();
        context.label((Pane)container);
        context.addNode((Pane)container, context.connector(DefaultConnectors.FLOW, new Class[0]).target(new Class[]{WoofHttpInputToWoofSectionInputModel.class, WoofHttpInputToWoofTemplateModel.class, WoofHttpInputToWoofResourceModel.class, WoofHttpInputToWoofSecurityModel.class, WoofHttpInputToWoofHttpContinuationModel.class}).getNode());
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> String.valueOf(model.getHttpMethod()) + " " + model.getApplicationPath(), (Enum[])new WoofHttpInputModel.WoofHttpInputEvent[]{WoofHttpInputModel.WoofHttpInputEvent.CHANGE_HTTP_METHOD, WoofHttpInputModel.WoofHttpInputEvent.CHANGE_APPLICATION_PATH});
    }

    public void loadToParent(WoofModel parentModel, WoofHttpInputModel itemModel) {
        parentModel.addWoofHttpInput(itemModel);
    }

    protected WoofHttpInputItem item(WoofHttpInputModel model) {
        WoofHttpInputItem item = new WoofHttpInputItem();
        if (model != null) {
            item.httpMethod = model.getHttpMethod();
            item.applicationPath = model.getApplicationPath();
            item.isHttps = model.getIsSecure();
        }
        return item;
    }

    protected void loadStyles(List<AbstractItem.IdeStyle> styles) {
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 50.0%, dodgerblue, lightskyblue)"));
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .label").rule("-fx-text-fill", "blue"));
    }

    protected void connections(List<AbstractItem.IdeConnectionTarget<? extends ConnectionModel, ?, ?>> connections) {
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpInputToWoofSectionInputModel.class).connectOne(s -> s.getWoofSectionInput(), c -> c.getWoofHttpInput(), (Enum[])new WoofHttpInputModel.WoofHttpInputEvent[]{WoofHttpInputModel.WoofHttpInputEvent.CHANGE_WOOF_SECTION_INPUT}).to(WoofSectionInputModel.class).many(t -> t.getWoofHttpInputs(), c -> c.getWoofSectionInput(), new Enum[]{WoofSectionInputModel.WoofSectionInputEvent.ADD_WOOF_HTTP_INPUT, WoofSectionInputModel.WoofSectionInputEvent.REMOVE_WOOF_HTTP_INPUT}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpInputToSectionInput(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpInputToSectionInput((WoofHttpInputToWoofSectionInputModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpInputToWoofTemplateModel.class).connectOne(s -> s.getWoofTemplate(), c -> c.getWoofHttpInput(), (Enum[])new WoofHttpInputModel.WoofHttpInputEvent[]{WoofHttpInputModel.WoofHttpInputEvent.CHANGE_WOOF_TEMPLATE}).to(WoofTemplateModel.class).many(t -> t.getWoofHttpInputs(), c -> c.getWoofTemplate(), new Enum[]{WoofTemplateModel.WoofTemplateEvent.ADD_WOOF_HTTP_INPUT, WoofTemplateModel.WoofTemplateEvent.REMOVE_WOOF_HTTP_INPUT}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpInputToTemplate(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpInputToTemplate((WoofHttpInputToWoofTemplateModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpInputToWoofResourceModel.class).connectOne(s -> s.getWoofResource(), c -> c.getWoofHttpInput(), (Enum[])new WoofHttpInputModel.WoofHttpInputEvent[]{WoofHttpInputModel.WoofHttpInputEvent.CHANGE_WOOF_RESOURCE}).to(WoofResourceModel.class).many(t -> t.getWoofHttpInputs(), c -> c.getWoofResource(), new Enum[]{WoofResourceModel.WoofResourceEvent.ADD_WOOF_HTTP_INPUT, WoofResourceModel.WoofResourceEvent.REMOVE_WOOF_HTTP_INPUT}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpInputToResource(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpInputToResource((WoofHttpInputToWoofResourceModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpInputToWoofSecurityModel.class).connectOne(s -> s.getWoofSecurity(), c -> c.getWoofHttpInput(), (Enum[])new WoofHttpInputModel.WoofHttpInputEvent[]{WoofHttpInputModel.WoofHttpInputEvent.CHANGE_WOOF_SECURITY}).to(WoofSecurityModel.class).many(t -> t.getWoofHttpInputs(), c -> c.getWoofSecurity(), new Enum[]{WoofSecurityModel.WoofSecurityEvent.ADD_WOOF_HTTP_INPUT, WoofSecurityModel.WoofSecurityEvent.REMOVE_WOOF_HTTP_INPUT}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpInputToSecurity(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpInputToSecurity((WoofHttpInputToWoofSecurityModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpInputToWoofHttpContinuationModel.class).connectOne(s -> s.getWoofHttpContinuation(), c -> c.getWoofHttpInput(), (Enum[])new WoofHttpInputModel.WoofHttpInputEvent[]{WoofHttpInputModel.WoofHttpInputEvent.CHANGE_WOOF_HTTP_CONTINUATION}).to(WoofHttpContinuationModel.class).many(t -> t.getWoofHttpInputs(), c -> c.getWoofHttpContinuation(), new Enum[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.ADD_WOOF_HTTP_INPUT, WoofHttpContinuationModel.WoofHttpContinuationEvent.REMOVE_WOOF_HTTP_INPUT}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpInputToHttpContinuation(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpInputToHttpContinuation((WoofHttpInputToWoofHttpContinuationModel)ctx.getModel()))));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("HTTP Input");
            ((TextBuilder)((TextBuilder)builder.text("HTTP Method").init(item -> item.httpMethod)).validate(ValueValidator.notEmptyString((String)"Must specify HTTP method"))).setValue((item, value) -> {
                String string = item.httpMethod = value;
            });
            ((TextBuilder)((TextBuilder)builder.text("Path").init(item -> item.applicationPath)).validate(ValueValidator.notEmptyString((String)"Must specify application path"))).setValue((item, value) -> {
                String string = item.applicationPath = value;
            });
            ((FlagBuilder)builder.flag("https").init(item -> item.isHttps)).setValue((item, value) -> {
                boolean bl = item.isHttps = value.booleanValue();
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((WoofChanges)context.getOperations()).addHttpInput(item.applicationPath, item.httpMethod, item.isHttps)))).refactor((builder, context) -> builder.apply("Refactor", item -> context.execute(((WoofChanges)context.getOperations()).refactorHttpInput((WoofHttpInputModel)context.getModel(), item.applicationPath, item.httpMethod, item.isHttps)))).delete(context -> context.execute(((WoofChanges)context.getOperations()).removeHttpInput((WoofHttpInputModel)context.getModel())));
    }
}

