/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.util.List;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.configurer.FlagBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.woof.WoofEditor;
import net.officefloor.model.ConnectionModel;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofExceptionToWoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofSectionInputModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofResourceModel;
import net.officefloor.woof.model.woof.WoofSectionInputModel;
import net.officefloor.woof.model.woof.WoofSectionOutputToWoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofSecurityModel;
import net.officefloor.woof.model.woof.WoofSecurityOutputToWoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofTemplateModel;
import net.officefloor.woof.model.woof.WoofTemplateOutputToWoofHttpContinuationModel;

public class WoofHttpContinuationItem
extends AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, WoofHttpContinuationModel, WoofHttpContinuationModel.WoofHttpContinuationEvent, WoofHttpContinuationItem> {
    private String applicationPath;
    private boolean isHttps = false;

    public static void main(String[] args) {
        WoofEditor.launchConfigurer(new WoofHttpContinuationItem(), model -> {
            model.setApplicationPath("/path");
            model.setIsSecure(true);
        });
    }

    public WoofHttpContinuationModel prototype() {
        return new WoofHttpContinuationModel(false, "HTTP Continuation");
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getWoofHttpContinuations(), (Enum[])new WoofModel.WoofEvent[]{WoofModel.WoofEvent.ADD_WOOF_HTTP_CONTINUATION, WoofModel.WoofEvent.REMOVE_WOOF_HTTP_CONTINUATION});
    }

    public Pane visual(WoofHttpContinuationModel model, AdaptedModelVisualFactoryContext<WoofHttpContinuationModel> context) {
        HBox container = new HBox();
        context.addNode((Pane)container, context.connector(DefaultConnectors.FLOW, new Class[0]).target(new Class[]{WoofHttpContinuationToWoofHttpContinuationModel.class, WoofHttpInputToWoofHttpContinuationModel.class, WoofTemplateOutputToWoofHttpContinuationModel.class, WoofSecurityOutputToWoofHttpContinuationModel.class, WoofSectionOutputToWoofHttpContinuationModel.class, WoofExceptionToWoofHttpContinuationModel.class}).getNode());
        context.label((Pane)container);
        context.addNode((Pane)container, context.connector(DefaultConnectors.FLOW, new Class[]{WoofHttpContinuationToWoofSectionInputModel.class, WoofHttpContinuationToWoofTemplateModel.class, WoofHttpContinuationToWoofResourceModel.class, WoofHttpContinuationToWoofSecurityModel.class}).source(new Class[]{WoofHttpContinuationToWoofHttpContinuationModel.class}).getNode());
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getApplicationPath(), (Enum[])new WoofHttpContinuationModel.WoofHttpContinuationEvent[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.CHANGE_APPLICATION_PATH});
    }

    public void loadToParent(WoofModel parentModel, WoofHttpContinuationModel itemModel) {
        parentModel.addWoofHttpContinuation(itemModel);
    }

    protected WoofHttpContinuationItem item(WoofHttpContinuationModel model) {
        WoofHttpContinuationItem item = new WoofHttpContinuationItem();
        if (model != null) {
            item.applicationPath = model.getApplicationPath();
            item.isHttps = model.getIsSecure();
        }
        return item;
    }

    protected void loadStyles(List<AbstractItem.IdeStyle> styles) {
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 50.0%, dodgerblue, lightskyblue)"));
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .label").rule("-fx-text-fill", "blue"));
    }

    protected void connections(List<AbstractItem.IdeConnectionTarget<? extends ConnectionModel, ?, ?>> connections) {
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpContinuationToWoofSectionInputModel.class).connectOne(s -> s.getWoofSectionInput(), c -> c.getWoofHttpContinuation(), (Enum[])new WoofHttpContinuationModel.WoofHttpContinuationEvent[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.CHANGE_WOOF_SECTION_INPUT}).to(WoofSectionInputModel.class).many(t -> t.getWoofHttpContinuations(), c -> c.getWoofSectionInput(), new Enum[]{WoofSectionInputModel.WoofSectionInputEvent.ADD_WOOF_HTTP_CONTINUATION, WoofSectionInputModel.WoofSectionInputEvent.REMOVE_WOOF_HTTP_CONTINUATION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpContinuationToSectionInput(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpContinuationToSectionInput((WoofHttpContinuationToWoofSectionInputModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpContinuationToWoofTemplateModel.class).connectOne(s -> s.getWoofTemplate(), c -> c.getWoofHttpContinuation(), (Enum[])new WoofHttpContinuationModel.WoofHttpContinuationEvent[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.CHANGE_WOOF_TEMPLATE}).to(WoofTemplateModel.class).many(t -> t.getWoofHttpContinuations(), c -> c.getWoofTemplate(), new Enum[]{WoofTemplateModel.WoofTemplateEvent.ADD_WOOF_HTTP_CONTINUATION, WoofTemplateModel.WoofTemplateEvent.REMOVE_WOOF_HTTP_CONTINUATION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpContinuationToTemplate(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpContinuationToTemplate((WoofHttpContinuationToWoofTemplateModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpContinuationToWoofResourceModel.class).connectOne(s -> s.getWoofResource(), c -> c.getWoofHttpContinuation(), (Enum[])new WoofHttpContinuationModel.WoofHttpContinuationEvent[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.CHANGE_WOOF_RESOURCE}).to(WoofResourceModel.class).many(t -> t.getWoofHttpContinuations(), c -> c.getWoofResource(), new Enum[]{WoofResourceModel.WoofResourceEvent.ADD_WOOF_HTTP_CONTINUATION, WoofResourceModel.WoofResourceEvent.REMOVE_WOOF_HTTP_CONTINUATION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpContinuationToResource(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpContinuationToResource((WoofHttpContinuationToWoofResourceModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpContinuationToWoofSecurityModel.class).connectOne(s -> s.getWoofSecurity(), c -> c.getWoofHttpContinuation(), (Enum[])new WoofHttpContinuationModel.WoofHttpContinuationEvent[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.CHANGE_WOOF_SECURITY}).to(WoofSecurityModel.class).many(t -> t.getWoofHttpContinuations(), c -> c.getWoofSecurity(), new Enum[]{WoofSecurityModel.WoofSecurityEvent.ADD_WOOF_HTTP_CONTINUATION, WoofSecurityModel.WoofSecurityEvent.REMOVE_WOOF_HTTP_CONTINUATION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpContinuationToSecurity(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpContinuationToSecurity((WoofHttpContinuationToWoofSecurityModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofHttpContinuationToWoofHttpContinuationModel.class).connectOne(s -> s.getWoofRedirect(), c -> c.getWoofHttpContinuation(), (Enum[])new WoofHttpContinuationModel.WoofHttpContinuationEvent[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.CHANGE_WOOF_REDIRECT}).to(WoofHttpContinuationModel.class).many(t -> t.getWoofHttpContinuations(), c -> c.getWoofRedirect(), new Enum[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.ADD_WOOF_HTTP_CONTINUATION, WoofHttpContinuationModel.WoofHttpContinuationEvent.REMOVE_WOOF_HTTP_CONTINUATION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkHttpContinuationToHttpContinuation(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeHttpContinuationToHttpContinuation((WoofHttpContinuationToWoofHttpContinuationModel)ctx.getModel()))));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("HTTP Continuation");
            ((TextBuilder)((TextBuilder)builder.text("Path").init(item -> item.applicationPath)).validate(ValueValidator.notEmptyString((String)"Must specify application path"))).setValue((item, value) -> {
                String string = item.applicationPath = value;
            });
            ((FlagBuilder)builder.flag("https").init(item -> item.isHttps)).setValue((item, value) -> {
                boolean bl = item.isHttps = value.booleanValue();
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((WoofChanges)context.getOperations()).addHttpContinuation(item.applicationPath, item.isHttps)))).refactor((builder, context) -> builder.apply("Refactor", item -> context.execute(((WoofChanges)context.getOperations()).refactorHttpContinuation((WoofHttpContinuationModel)context.getModel(), item.applicationPath, item.isHttps)))).delete(context -> context.execute(((WoofChanges)context.getOperations()).removeHttpContinuation((WoofHttpContinuationModel)context.getModel())));
    }
}

