/*
 * OfficeFloor - http://www.officefloor.net
 * Copyright (C) 2005-2018 Daniel Sagenschneider
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package net.officefloor.eclipse.editor;

import javafx.beans.property.Property;
import net.officefloor.model.Model;

/**
 * Styler of the {@link AdaptedModel}.
 * 
 * @author Daniel Sagenschneider
 */
public interface AdaptedModelStyler {

	/**
	 * Obtains the {@link Model}.
	 * 
	 * @return {@link Model}.
	 */
	Model getModel();

	/**
	 * Obtains the {@link Property} to style the {@link AdaptedModel}.
	 * 
	 * @return {@link Property} to style the {@link AdaptedModel}.
	 */
	Property<String> style();

}