/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.common.javafx.structure;

import java.io.IOException;
import javafx.css.CssMetaData;
import javafx.scene.Node;
import javafx.scene.Parent;

public class StructureLogger {
    public static void logFull(Node node, Appendable output) throws IOException {
        StructureLogger.log((Node)node.getScene().getRoot(), output);
    }

    public static void log(Node node, Appendable output) throws IOException {
        StructureLogger.log(node, 0, -1, false, output);
    }

    public static void logCss(Node node, int maxDepth, Appendable output) throws IOException {
        StructureLogger.log(node, 0, maxDepth, true, output);
    }

    private static void log(Node node, int depth, int maxDepth, boolean isIncludeCss, Appendable output) throws IOException {
        if (maxDepth >= 0 && depth >= maxDepth) {
            StructureLogger.indent(depth, output);
            output.append("...");
            output.append(System.lineSeparator());
            return;
        }
        StructureLogger.indent(depth, output);
        output.append(node.toString());
        output.append(System.lineSeparator());
        if (isIncludeCss) {
            for (CssMetaData metaData : node.getCssMetaData()) {
                StructureLogger.indent(depth, output);
                output.append("-");
                output.append(metaData.toString());
                output.append(System.lineSeparator());
            }
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : parent.getChildrenUnmodifiable()) {
                StructureLogger.log(child, depth + 1, maxDepth, isIncludeCss, output);
            }
        }
    }

    private static void indent(int depth, Appendable output) throws IOException {
        int i = 0;
        while (i < depth * 2) {
            output.append(" ");
            ++i;
        }
    }

    private StructureLogger() {
    }
}

