/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.common.javafx.resize;

import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class DragResizer {
    private static final int RESIZE_MARGIN = 5;
    private final Region region;
    private final Orientation orientation;
    private boolean dragging;

    public static void makeResizable(Region region, Orientation orientation) {
        DragResizer resizer = new DragResizer(region, orientation);
        region.setOnMouseMoved(event -> resizer.mouseOver((MouseEvent)event));
        region.setOnMousePressed(event -> resizer.mousePressed((MouseEvent)event));
        region.setOnMouseDragged(event -> resizer.mouseDragged((MouseEvent)event));
        region.setOnMouseReleased(event -> resizer.mouseReleased((MouseEvent)event));
    }

    private DragResizer(Region region, Orientation orientation) {
        this.region = region;
        this.orientation = orientation;
    }

    protected boolean isInDraggableZone(MouseEvent event) {
        switch (this.orientation) {
            case HORIZONTAL: {
                return event.getX() > this.region.getWidth() - 5.0;
            }
        }
        return event.getY() > this.region.getHeight() - 5.0;
    }

    protected void mouseOver(MouseEvent event) {
        if (this.isInDraggableZone(event) || this.dragging) {
            this.region.setCursor(Cursor.S_RESIZE);
        } else {
            this.region.setCursor(Cursor.DEFAULT);
        }
    }

    protected void mousePressed(MouseEvent event) {
        if (!this.isInDraggableZone(event)) {
            return;
        }
        this.dragging = true;
    }

    protected void mouseDragged(MouseEvent event) {
        if (!this.dragging) {
            return;
        }
        switch (this.orientation) {
            case HORIZONTAL: {
                this.region.setPrefWidth(event.getX());
                break;
            }
            default: {
                this.region.setPrefHeight(event.getY());
            }
        }
    }

    protected void mouseReleased(MouseEvent event) {
        this.dragging = false;
        this.region.setCursor(Cursor.DEFAULT);
    }
}

