/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.tool.demo;

import java.awt.Rectangle;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroSource;
import net.officefloor.demo.macro.MacroSourceContext;
import net.officefloor.demo.macro.MacroTask;
import net.officefloor.demo.macro.MacroTaskContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class MoveActiveShellMacro
implements MacroSource,
Macro {
    public static final int TITLE_BAR_HEIGHT = 20;
    public static final int MENU_BAR_HEIGHT = 20;
    public static final int MOUSE_OFFSET_WIDTH = 30;
    private java.awt.Point moveLocation;

    public String getDisplayName() {
        return "Move active window";
    }

    public void sourceMacro(MacroSourceContext context) {
        MoveActiveShellMacro macro = new MoveActiveShellMacro();
        macro.moveLocation = context.getLocation();
        context.setNewMacro((Macro)macro);
    }

    public String getDisplayLabel() {
        return null;
    }

    public java.awt.Point getStartingMouseLocation() {
        return null;
    }

    public void setConfigurationMemento(String memento) {
        String[] coordinates = memento.split(",");
        int x = Integer.parseInt(coordinates[0]);
        int y = Integer.parseInt(coordinates[1]);
        this.moveLocation = new java.awt.Point(x, y);
    }

    public String getConfigurationMemento() {
        return String.valueOf(String.valueOf(this.moveLocation.x)) + "," + String.valueOf(this.moveLocation.y);
    }

    public MacroTask[] getMacroTasks() {
        return new MacroTask[]{new MoveMouseToShellTitleBarMacroTask(), new MouseClickMacroTask(true), new MoveShellToLocationMacroTask(), new MouseClickMacroTask(false)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getActiveShellBounds(final Display display) {
        final Rectangle[] activeShellBounds = new Rectangle[1];
        display.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Shell activeShell = display.getActiveShell();
                Point location = activeShell.toDisplay(0, 0);
                Point size = activeShell.getSize();
                int y = location.y - 20;
                int height = size.y + 20;
                Menu menuBar = activeShell.getMenuBar();
                if (menuBar != null) {
                    y -= 20;
                    height += 20;
                }
                Rectangle[] rectangleArray = activeShellBounds;
                synchronized (activeShellBounds) {
                    activeShellBounds[0] = new Rectangle(location.x, y, size.x, height);
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return;
                }
            }
        });
        Rectangle[] rectangleArray = activeShellBounds;
        synchronized (activeShellBounds) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return activeShellBounds[0];
        }
    }

    private class MouseClickMacroTask
    implements MacroTask {
        private final boolean isPressNotRelease;

        public MouseClickMacroTask(boolean isPressNotRelease) {
            this.isPressNotRelease = isPressNotRelease;
        }

        public void runMacroTask(MacroTaskContext context) {
            if (this.isPressNotRelease) {
                context.mousePress(16);
            } else {
                context.mouseRelease(16);
            }
        }

        public long getPostRunWaitTime() {
            return 0L;
        }
    }

    private class MoveMouseToShellTitleBarMacroTask
    implements MacroTask {
        private MoveMouseToShellTitleBarMacroTask() {
        }

        public void runMacroTask(MacroTaskContext context) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            Rectangle bounds = MoveActiveShellMacro.this.getActiveShellBounds(display);
            int x = bounds.x + 30;
            int y = bounds.y + 10;
            java.awt.Point relativeLocation = context.getRelativeLocation(new java.awt.Point(x, y));
            context.mouseMove(relativeLocation.x, relativeLocation.y);
        }

        public long getPostRunWaitTime() {
            return 0L;
        }
    }

    public class MoveShellToLocationMacroTask
    implements MacroTask {
        public void runMacroTask(MacroTaskContext context) {
            int x = ((MoveActiveShellMacro)MoveActiveShellMacro.this).moveLocation.x - 30;
            int y = ((MoveActiveShellMacro)MoveActiveShellMacro.this).moveLocation.y - 10;
            context.mouseMove(x, y);
        }

        public long getPostRunWaitTime() {
            return 0L;
        }
    }
}

