/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.ovh.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.minidev.ovh.api.complextype.OvhRange;
import net.minidev.ovh.api.ip.OvhAntiphishing;
import net.minidev.ovh.api.ip.OvhAntiphishingStateEnum;
import net.minidev.ovh.api.ip.OvhArpBlockedIp;
import net.minidev.ovh.api.ip.OvhArpStateEnum;
import net.minidev.ovh.api.ip.OvhBlockedIp;
import net.minidev.ovh.api.ip.OvhBlockedIpStateEnum;
import net.minidev.ovh.api.ip.OvhDestinations;
import net.minidev.ovh.api.ip.OvhFirewallActionEnum;
import net.minidev.ovh.api.ip.OvhFirewallIp;
import net.minidev.ovh.api.ip.OvhFirewallNetworkRule;
import net.minidev.ovh.api.ip.OvhFirewallOptionTCP;
import net.minidev.ovh.api.ip.OvhFirewallProtocolEnum;
import net.minidev.ovh.api.ip.OvhFirewallRuleStateEnum;
import net.minidev.ovh.api.ip.OvhFirewallSequenceRangeEnum;
import net.minidev.ovh.api.ip.OvhFirewallStateEnum;
import net.minidev.ovh.api.ip.OvhGameMitigation;
import net.minidev.ovh.api.ip.OvhGameMitigationRule;
import net.minidev.ovh.api.ip.OvhGameMitigationRuleProtocolEnum;
import net.minidev.ovh.api.ip.OvhIp;
import net.minidev.ovh.api.ip.OvhIpMigrationToken;
import net.minidev.ovh.api.ip.OvhIpTask;
import net.minidev.ovh.api.ip.OvhIpTypeEnum;
import net.minidev.ovh.api.ip.OvhLoadBalancingAdditionalPortEnum;
import net.minidev.ovh.api.ip.OvhLoadBalancingBackendIp;
import net.minidev.ovh.api.ip.OvhLoadBalancingBackendProbeEnum;
import net.minidev.ovh.api.ip.OvhLoadBalancingIp;
import net.minidev.ovh.api.ip.OvhLoadBalancingStickinessEnum;
import net.minidev.ovh.api.ip.OvhLoadBalancingTask;
import net.minidev.ovh.api.ip.OvhLoadBalancingZoneEnum;
import net.minidev.ovh.api.ip.OvhMitigationDetailedStats;
import net.minidev.ovh.api.ip.OvhMitigationIp;
import net.minidev.ovh.api.ip.OvhMitigationProfile;
import net.minidev.ovh.api.ip.OvhMitigationProfileAutoMitigationTimeOutEnum;
import net.minidev.ovh.api.ip.OvhMitigationStateEnum;
import net.minidev.ovh.api.ip.OvhMitigationStats;
import net.minidev.ovh.api.ip.OvhMitigationStatsScaleEnum;
import net.minidev.ovh.api.ip.OvhReverseDelegation;
import net.minidev.ovh.api.ip.OvhReverseIp;
import net.minidev.ovh.api.ip.OvhRipeInfos;
import net.minidev.ovh.api.ip.OvhServiceIp;
import net.minidev.ovh.api.ip.OvhSpamIp;
import net.minidev.ovh.api.ip.OvhSpamStateEnum;
import net.minidev.ovh.api.ip.OvhSpamStats;
import net.minidev.ovh.api.ip.OvhTaskFunctionEnum;
import net.minidev.ovh.api.ip.OvhTaskStatusEnum;
import net.minidev.ovh.api.ip.loadbalancingip.OvhLoadBalancingPort;
import net.minidev.ovh.api.iploadbalancing.task.OvhTask;
import net.minidev.ovh.api.service.OvhTerminationReasonEnum;
import net.minidev.ovh.api.services.OvhNonExpiringService;
import net.minidev.ovh.api.services.OvhService;
import net.minidev.ovh.core.ApiOvhBase;
import net.minidev.ovh.core.ApiOvhCore;

public class ApiOvhIp
extends ApiOvhBase {
    private static TypeReference<ArrayList<String>> t1 = new TypeReference<ArrayList<String>>(){};
    private static TypeReference<ArrayList<OvhSpamStats>> t2 = new TypeReference<ArrayList<OvhSpamStats>>(){};
    private static TypeReference<ArrayList<Long>> t3 = new TypeReference<ArrayList<Long>>(){};
    private static TypeReference<ArrayList<OvhMitigationStats>> t4 = new TypeReference<ArrayList<OvhMitigationStats>>(){};
    private static TypeReference<ArrayList<OvhMitigationDetailedStats>> t5 = new TypeReference<ArrayList<OvhMitigationDetailedStats>>(){};
    private static TypeReference<ArrayList<OvhLoadBalancingAdditionalPortEnum>> t6 = new TypeReference<ArrayList<OvhLoadBalancingAdditionalPortEnum>>(){};

    public ApiOvhIp(ApiOvhCore core) {
        super(core);
    }

    public ArrayList<String> GET(String description, String ip, String routedTo_serviceName, OvhIpTypeEnum type) throws IOException {
        String qPath = "/ip";
        StringBuilder sb = this.path(qPath, new Object[0]);
        this.query(sb, "description", description);
        this.query(sb, "ip", ip);
        this.query(sb, "routedTo.serviceName", routedTo_serviceName);
        this.query(sb, "type", (Object)type);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhIp ip_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhIp)this.convertTo(resp, OvhIp.class);
    }

    public void ip_PUT(String ip, OvhIp body) throws IOException {
        String qPath = "/ip/{ip}";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhIpTask ip_move_POST(String ip, String nexthop, String to) throws IOException {
        String qPath = "/ip/{ip}/move";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "nexthop", nexthop);
        this.addBody(o, "to", to);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhIpTask)this.convertTo(resp, OvhIpTask.class);
    }

    public OvhDestinations ip_move_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}/move";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhDestinations)this.convertTo(resp, OvhDestinations.class);
    }

    public ArrayList<String> ip_arp_GET(String ip, OvhArpStateEnum state) throws IOException {
        String qPath = "/ip/{ip}/arp";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "state", (Object)state);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhArpBlockedIp ip_arp_ipBlocked_GET(String ip, String ipBlocked) throws IOException {
        String qPath = "/ip/{ip}/arp/{ipBlocked}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipBlocked});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhArpBlockedIp)this.convertTo(resp, OvhArpBlockedIp.class);
    }

    public void ip_arp_ipBlocked_unblock_POST(String ip, String ipBlocked) throws IOException {
        String qPath = "/ip/{ip}/arp/{ipBlocked}/unblock";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipBlocked});
        this.exec(qPath, "POST", sb.toString(), null);
    }

    public OvhRipeInfos ip_ripe_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}/ripe";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhRipeInfos)this.convertTo(resp, OvhRipeInfos.class);
    }

    public void ip_ripe_PUT(String ip, OvhRipeInfos body) throws IOException {
        String qPath = "/ip/{ip}/ripe";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhIpTask ip_terminate_POST(String ip) throws IOException {
        String qPath = "/ip/{ip}/terminate";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "POST", sb.toString(), null);
        return (OvhIpTask)this.convertTo(resp, OvhIpTask.class);
    }

    public OvhIpTask ip_changeOrg_POST(String ip, String organisation) throws IOException {
        String qPath = "/ip/{ip}/changeOrg";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "organisation", organisation);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhIpTask)this.convertTo(resp, OvhIpTask.class);
    }

    public OvhIpTask ip_park_POST(String ip) throws IOException {
        String qPath = "/ip/{ip}/park";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "POST", sb.toString(), null);
        return (OvhIpTask)this.convertTo(resp, OvhIpTask.class);
    }

    public ArrayList<String> ip_spam_GET(String ip, OvhSpamStateEnum state) throws IOException {
        String qPath = "/ip/{ip}/spam";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "state", (Object)state);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhSpamIp ip_spam_ipSpamming_GET(String ip, String ipSpamming) throws IOException {
        String qPath = "/ip/{ip}/spam/{ipSpamming}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipSpamming});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhSpamIp)this.convertTo(resp, OvhSpamIp.class);
    }

    public OvhSpamIp ip_spam_ipSpamming_unblock_POST(String ip, String ipSpamming) throws IOException {
        String qPath = "/ip/{ip}/spam/{ipSpamming}/unblock";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipSpamming});
        String resp = this.exec(qPath, "POST", sb.toString(), null);
        return (OvhSpamIp)this.convertTo(resp, OvhSpamIp.class);
    }

    public ArrayList<OvhSpamStats> ip_spam_ipSpamming_stats_GET(String ip, String ipSpamming, Date from, Date to) throws IOException {
        String qPath = "/ip/{ip}/spam/{ipSpamming}/stats";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipSpamming});
        this.query(sb, "from", from);
        this.query(sb, "to", to);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t2);
    }

    public ArrayList<String> ip_delegation_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}/delegation";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhReverseDelegation ip_delegation_POST(String ip, String target) throws IOException {
        String qPath = "/ip/{ip}/delegation";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "target", target);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhReverseDelegation)this.convertTo(resp, OvhReverseDelegation.class);
    }

    public OvhReverseDelegation ip_delegation_target_GET(String ip, String target) throws IOException {
        String qPath = "/ip/{ip}/delegation/{target}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, target});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhReverseDelegation)this.convertTo(resp, OvhReverseDelegation.class);
    }

    public void ip_delegation_target_DELETE(String ip, String target) throws IOException {
        String qPath = "/ip/{ip}/delegation/{target}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, target});
        this.exec(qPath, "DELETE", sb.toString(), null);
    }

    public OvhIpMigrationToken ip_migrationToken_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}/migrationToken";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhIpMigrationToken)this.convertTo(resp, OvhIpMigrationToken.class);
    }

    public OvhIpMigrationToken ip_migrationToken_POST(String ip, String customerId) throws IOException {
        String qPath = "/ip/{ip}/migrationToken";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "customerId", customerId);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhIpMigrationToken)this.convertTo(resp, OvhIpMigrationToken.class);
    }

    public ArrayList<String> ip_mitigationProfiles_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}/mitigationProfiles";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhMitigationProfile ip_mitigationProfiles_POST(String ip, String ipMitigationProfile, OvhMitigationProfileAutoMitigationTimeOutEnum autoMitigationTimeOut) throws IOException {
        String qPath = "/ip/{ip}/mitigationProfiles";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "ipMitigationProfile", ipMitigationProfile);
        this.addBody(o, "autoMitigationTimeOut", (Object)autoMitigationTimeOut);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhMitigationProfile)this.convertTo(resp, OvhMitigationProfile.class);
    }

    public OvhMitigationProfile ip_mitigationProfiles_ipMitigationProfile_GET(String ip, String ipMitigationProfile) throws IOException {
        String qPath = "/ip/{ip}/mitigationProfiles/{ipMitigationProfile}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipMitigationProfile});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhMitigationProfile)this.convertTo(resp, OvhMitigationProfile.class);
    }

    public void ip_mitigationProfiles_ipMitigationProfile_PUT(String ip, String ipMitigationProfile, OvhMitigationProfile body) throws IOException {
        String qPath = "/ip/{ip}/mitigationProfiles/{ipMitigationProfile}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipMitigationProfile});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public void ip_mitigationProfiles_ipMitigationProfile_DELETE(String ip, String ipMitigationProfile) throws IOException {
        String qPath = "/ip/{ip}/mitigationProfiles/{ipMitigationProfile}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipMitigationProfile});
        this.exec(qPath, "DELETE", sb.toString(), null);
    }

    public ArrayList<Long> ip_task_GET(String ip, OvhTaskFunctionEnum function, OvhTaskStatusEnum status) throws IOException {
        String qPath = "/ip/{ip}/task";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "function", (Object)function);
        this.query(sb, "status", (Object)status);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public OvhIpTask ip_task_taskId_GET(String ip, Long taskId) throws IOException {
        String qPath = "/ip/{ip}/task/{taskId}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, taskId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhIpTask)this.convertTo(resp, OvhIpTask.class);
    }

    public ArrayList<String> ip_license_worklight_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/worklight";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_license_cloudLinux_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/cloudLinux";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_license_directadmin_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/directadmin";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_license_windows_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/windows";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_license_virtuozzo_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/virtuozzo";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_license_cpanel_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/cpanel";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_license_sqlserver_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/sqlserver";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_license_plesk_GET(String ip, String ipAddress) throws IOException {
        String qPath = "/ip/{ip}/license/plesk";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipAddress", ipAddress);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_mitigation_GET(String ip, Boolean auto, OvhMitigationStateEnum state) throws IOException {
        String qPath = "/ip/{ip}/mitigation";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "auto", auto);
        this.query(sb, "state", (Object)state);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhMitigationIp ip_mitigation_POST(String ip, String ipOnMitigation) throws IOException {
        String qPath = "/ip/{ip}/mitigation";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "ipOnMitigation", ipOnMitigation);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhMitigationIp)this.convertTo(resp, OvhMitigationIp.class);
    }

    public OvhMitigationIp ip_mitigation_ipOnMitigation_GET(String ip, String ipOnMitigation) throws IOException {
        String qPath = "/ip/{ip}/mitigation/{ipOnMitigation}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnMitigation});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhMitigationIp)this.convertTo(resp, OvhMitigationIp.class);
    }

    public void ip_mitigation_ipOnMitigation_PUT(String ip, String ipOnMitigation, OvhMitigationIp body) throws IOException {
        String qPath = "/ip/{ip}/mitigation/{ipOnMitigation}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnMitigation});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhMitigationIp ip_mitigation_ipOnMitigation_DELETE(String ip, String ipOnMitigation) throws IOException {
        String qPath = "/ip/{ip}/mitigation/{ipOnMitigation}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnMitigation});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhMitigationIp)this.convertTo(resp, OvhMitigationIp.class);
    }

    public ArrayList<OvhMitigationStats> ip_mitigation_ipOnMitigation_stats_GET(String ip, String ipOnMitigation, Date from, OvhMitigationStatsScaleEnum scale, Date to) throws IOException {
        String qPath = "/ip/{ip}/mitigation/{ipOnMitigation}/stats";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnMitigation});
        this.query(sb, "from", from);
        this.query(sb, "scale", (Object)scale);
        this.query(sb, "to", to);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t4);
    }

    public ArrayList<OvhMitigationDetailedStats> ip_mitigation_ipOnMitigation_topStream_GET(String ip, String ipOnMitigation, Date date, OvhMitigationStatsScaleEnum scale) throws IOException {
        String qPath = "/ip/{ip}/mitigation/{ipOnMitigation}/topStream";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnMitigation});
        this.query(sb, "date", date);
        this.query(sb, "scale", (Object)scale);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t5);
    }

    public ArrayList<String> ip_reverse_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}/reverse";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhReverseIp ip_reverse_POST(String ip, String ipReverse, String reverse) throws IOException {
        String qPath = "/ip/{ip}/reverse";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "ipReverse", ipReverse);
        this.addBody(o, "reverse", reverse);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhReverseIp)this.convertTo(resp, OvhReverseIp.class);
    }

    public OvhReverseIp ip_reverse_ipReverse_GET(String ip, String ipReverse) throws IOException {
        String qPath = "/ip/{ip}/reverse/{ipReverse}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipReverse});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhReverseIp)this.convertTo(resp, OvhReverseIp.class);
    }

    public void ip_reverse_ipReverse_DELETE(String ip, String ipReverse) throws IOException {
        String qPath = "/ip/{ip}/reverse/{ipReverse}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipReverse});
        this.exec(qPath, "DELETE", sb.toString(), null);
    }

    public ArrayList<String> ip_antihack_GET(String ip, OvhBlockedIpStateEnum state) throws IOException {
        String qPath = "/ip/{ip}/antihack";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "state", (Object)state);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhBlockedIp ip_antihack_ipBlocked_GET(String ip, String ipBlocked) throws IOException {
        String qPath = "/ip/{ip}/antihack/{ipBlocked}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipBlocked});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhBlockedIp)this.convertTo(resp, OvhBlockedIp.class);
    }

    public void ip_antihack_ipBlocked_unblock_POST(String ip, String ipBlocked) throws IOException {
        String qPath = "/ip/{ip}/antihack/{ipBlocked}/unblock";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipBlocked});
        this.exec(qPath, "POST", sb.toString(), null);
    }

    public ArrayList<Long> ip_phishing_GET(String ip, String ipOnAntiphishing, OvhAntiphishingStateEnum state) throws IOException {
        String qPath = "/ip/{ip}/phishing";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "ipOnAntiphishing", ipOnAntiphishing);
        this.query(sb, "state", (Object)state);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public OvhAntiphishing ip_phishing_id_GET(String ip, Long id) throws IOException {
        String qPath = "/ip/{ip}/phishing/{id}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, id});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhAntiphishing)this.convertTo(resp, OvhAntiphishing.class);
    }

    public OvhGameMitigation ip_game_ipOnGame_GET(String ip, String ipOnGame) throws IOException {
        String qPath = "/ip/{ip}/game/{ipOnGame}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnGame});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhGameMitigation)this.convertTo(resp, OvhGameMitigation.class);
    }

    public void ip_game_ipOnGame_PUT(String ip, String ipOnGame, OvhGameMitigation body) throws IOException {
        String qPath = "/ip/{ip}/game/{ipOnGame}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnGame});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public ArrayList<Long> ip_game_ipOnGame_rule_GET(String ip, String ipOnGame) throws IOException {
        String qPath = "/ip/{ip}/game/{ipOnGame}/rule";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnGame});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public OvhGameMitigationRule ip_game_ipOnGame_rule_POST(String ip, String ipOnGame, OvhGameMitigationRuleProtocolEnum protocol, OvhRange<Long> ports) throws IOException {
        String qPath = "/ip/{ip}/game/{ipOnGame}/rule";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnGame});
        HashMap o = new HashMap();
        this.addBody(o, "protocol", (Object)protocol);
        this.addBody(o, "ports", ports);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhGameMitigationRule)this.convertTo(resp, OvhGameMitigationRule.class);
    }

    public OvhGameMitigationRule ip_game_ipOnGame_rule_id_GET(String ip, String ipOnGame, Long id) throws IOException {
        String qPath = "/ip/{ip}/game/{ipOnGame}/rule/{id}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnGame, id});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhGameMitigationRule)this.convertTo(resp, OvhGameMitigationRule.class);
    }

    public OvhGameMitigationRule ip_game_ipOnGame_rule_id_DELETE(String ip, String ipOnGame, Long id) throws IOException {
        String qPath = "/ip/{ip}/game/{ipOnGame}/rule/{id}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnGame, id});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhGameMitigationRule)this.convertTo(resp, OvhGameMitigationRule.class);
    }

    public ArrayList<String> ip_game_GET(String ip) throws IOException {
        String qPath = "/ip/{ip}/game";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<String> ip_firewall_GET(String ip, Boolean enabled, OvhFirewallStateEnum state) throws IOException {
        String qPath = "/ip/{ip}/firewall";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        this.query(sb, "enabled", enabled);
        this.query(sb, "state", (Object)state);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhFirewallIp ip_firewall_POST(String ip, String ipOnFirewall) throws IOException {
        String qPath = "/ip/{ip}/firewall";
        StringBuilder sb = this.path(qPath, new Object[]{ip});
        HashMap o = new HashMap();
        this.addBody(o, "ipOnFirewall", ipOnFirewall);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhFirewallIp)this.convertTo(resp, OvhFirewallIp.class);
    }

    public OvhFirewallIp ip_firewall_ipOnFirewall_GET(String ip, String ipOnFirewall) throws IOException {
        String qPath = "/ip/{ip}/firewall/{ipOnFirewall}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnFirewall});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhFirewallIp)this.convertTo(resp, OvhFirewallIp.class);
    }

    public void ip_firewall_ipOnFirewall_PUT(String ip, String ipOnFirewall, OvhFirewallIp body) throws IOException {
        String qPath = "/ip/{ip}/firewall/{ipOnFirewall}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnFirewall});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public String ip_firewall_ipOnFirewall_DELETE(String ip, String ipOnFirewall) throws IOException {
        String qPath = "/ip/{ip}/firewall/{ipOnFirewall}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnFirewall});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (String)this.convertTo(resp, String.class);
    }

    public ArrayList<Long> ip_firewall_ipOnFirewall_rule_GET(String ip, String ipOnFirewall, OvhFirewallRuleStateEnum state) throws IOException {
        String qPath = "/ip/{ip}/firewall/{ipOnFirewall}/rule";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnFirewall});
        this.query(sb, "state", (Object)state);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public OvhFirewallNetworkRule ip_firewall_ipOnFirewall_rule_POST(String ip, String ipOnFirewall, OvhFirewallOptionTCP tcpOption, String source, OvhFirewallProtocolEnum protocol, Long destinationPort, OvhFirewallSequenceRangeEnum sequence, OvhFirewallActionEnum action, Long sourcePort) throws IOException {
        String qPath = "/ip/{ip}/firewall/{ipOnFirewall}/rule";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnFirewall});
        HashMap o = new HashMap();
        this.addBody(o, "tcpOption", tcpOption);
        this.addBody(o, "source", source);
        this.addBody(o, "protocol", (Object)protocol);
        this.addBody(o, "destinationPort", destinationPort);
        this.addBody(o, "sequence", (Object)sequence);
        this.addBody(o, "action", (Object)action);
        this.addBody(o, "sourcePort", sourcePort);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhFirewallNetworkRule)this.convertTo(resp, OvhFirewallNetworkRule.class);
    }

    public OvhFirewallNetworkRule ip_firewall_ipOnFirewall_rule_sequence_GET(String ip, String ipOnFirewall, Long sequence) throws IOException {
        String qPath = "/ip/{ip}/firewall/{ipOnFirewall}/rule/{sequence}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnFirewall, sequence});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhFirewallNetworkRule)this.convertTo(resp, OvhFirewallNetworkRule.class);
    }

    public OvhFirewallNetworkRule ip_firewall_ipOnFirewall_rule_sequence_DELETE(String ip, String ipOnFirewall, Long sequence) throws IOException {
        String qPath = "/ip/{ip}/firewall/{ipOnFirewall}/rule/{sequence}";
        StringBuilder sb = this.path(qPath, new Object[]{ip, ipOnFirewall, sequence});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhFirewallNetworkRule)this.convertTo(resp, OvhFirewallNetworkRule.class);
    }

    public OvhService loadBalancing_serviceName_serviceInfos_GET(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/serviceInfos";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhService)this.convertTo(resp, OvhService.class);
    }

    public void loadBalancing_serviceName_serviceInfos_PUT(String serviceName, OvhService body) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/serviceInfos";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_importCustomSsl_POST(String serviceName, String chain, String certificate, String key) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/importCustomSsl";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "chain", chain);
        this.addBody(o, "certificate", certificate);
        this.addBody(o, "key", key);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public OvhLoadBalancingIp loadBalancing_serviceName_GET(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhLoadBalancingIp)this.convertTo(resp, OvhLoadBalancingIp.class);
    }

    public ArrayList<String> loadBalancing_serviceName_allowedBackends_GET(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/allowedBackends";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public String loadBalancing_serviceName_internalNatIp_GET(String serviceName, OvhLoadBalancingZoneEnum zone) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/internalNatIp";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        this.query(sb, "zone", (Object)zone);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (String)this.convertTo(resp, String.class);
    }

    public ArrayList<String> loadBalancing_serviceName_backend_GET(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/backend";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_backend_POST(String serviceName, Long weight, String ipBackend, OvhLoadBalancingBackendProbeEnum probe) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/backend";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "weight", weight);
        this.addBody(o, "ipBackend", ipBackend);
        this.addBody(o, "probe", (Object)probe);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public OvhLoadBalancingBackendIp loadBalancing_serviceName_backend_backend_GET(String serviceName, String backend) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/backend/{backend}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, backend});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhLoadBalancingBackendIp)this.convertTo(resp, OvhLoadBalancingBackendIp.class);
    }

    public void loadBalancing_serviceName_backend_backend_PUT(String serviceName, String backend, OvhLoadBalancingBackendIp body) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/backend/{backend}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, backend});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_backend_backend_DELETE(String serviceName, String backend) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/backend/{backend}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, backend});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_backend_backend_backupState_POST(String serviceName, String backend, String mainBackendIp, Boolean backupStateSet) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/backend/{backend}/backupState";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, backend});
        HashMap o = new HashMap();
        this.addBody(o, "mainBackendIp", mainBackendIp);
        this.addBody(o, "backupStateSet", backupStateSet);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_backend_backend_setWeight_POST(String serviceName, String backend, Long weight) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/backend/{backend}/setWeight";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, backend});
        HashMap o = new HashMap();
        this.addBody(o, "weight", weight);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public ArrayList<Long> loadBalancing_serviceName_task_GET(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/task";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_task_taskId_GET(String serviceName, Long taskId) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/task/{taskId}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, taskId});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_restoreSsl_POST(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/restoreSsl";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "POST", sb.toString(), null);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_stickiness_POST(String serviceName, OvhLoadBalancingStickinessEnum stickiness) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/stickiness";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "stickiness", (Object)stickiness);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public ArrayList<OvhLoadBalancingAdditionalPortEnum> loadBalancing_serviceName_portsRedirection_GET(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/portsRedirection";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t6);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_portsRedirection_POST(String serviceName, OvhLoadBalancingPort body) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/portsRedirection";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "POST", sb.toString(), body);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public OvhLoadBalancingPort loadBalancing_serviceName_portsRedirection_srcPort_GET(String serviceName, OvhLoadBalancingAdditionalPortEnum srcPort) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/portsRedirection/{srcPort}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, srcPort});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhLoadBalancingPort)this.convertTo(resp, OvhLoadBalancingPort.class);
    }

    public OvhLoadBalancingTask loadBalancing_serviceName_portsRedirection_srcPort_DELETE(String serviceName, OvhLoadBalancingAdditionalPortEnum srcPort) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/portsRedirection/{srcPort}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName, srcPort});
        String resp = this.exec(qPath, "DELETE", sb.toString(), null);
        return (OvhLoadBalancingTask)this.convertTo(resp, OvhLoadBalancingTask.class);
    }

    public ArrayList<String> loadBalancing_serviceName_probeIp_GET(String serviceName, OvhLoadBalancingZoneEnum zone) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/probeIp";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        this.query(sb, "zone", (Object)zone);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhTask loadBalancing_serviceName_switchToIplbNextGenerationApi_POST(String serviceName) throws IOException {
        String qPath = "/ip/loadBalancing/{serviceName}/switchToIplbNextGenerationApi";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "POST", sb.toString(), null);
        return (OvhTask)this.convertTo(resp, OvhTask.class);
    }

    public ArrayList<String> loadBalancing_GET() throws IOException {
        String qPath = "/ip/loadBalancing";
        StringBuilder sb = this.path(qPath, new Object[0]);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public OvhNonExpiringService service_serviceName_serviceInfos_GET(String serviceName) throws IOException {
        String qPath = "/ip/service/{serviceName}/serviceInfos";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhNonExpiringService)this.convertTo(resp, OvhNonExpiringService.class);
    }

    public OvhServiceIp service_serviceName_GET(String serviceName) throws IOException {
        String qPath = "/ip/service/{serviceName}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhServiceIp)this.convertTo(resp, OvhServiceIp.class);
    }

    public void service_serviceName_PUT(String serviceName, OvhServiceIp body) throws IOException {
        String qPath = "/ip/service/{serviceName}";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        this.exec(qPath, "PUT", sb.toString(), body);
    }

    public String service_serviceName_confirmTermination_POST(String serviceName, OvhTerminationReasonEnum reason, String commentary, String token) throws IOException {
        String qPath = "/ip/service/{serviceName}/confirmTermination";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "reason", (Object)reason);
        this.addBody(o, "commentary", commentary);
        this.addBody(o, "token", token);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (String)this.convertTo(resp, String.class);
    }

    public String service_serviceName_terminate_POST(String serviceName) throws IOException {
        String qPath = "/ip/service/{serviceName}/terminate";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        String resp = this.exec(qPath, "POST", sb.toString(), null);
        return (String)this.convertTo(resp, String.class);
    }

    public ArrayList<Long> service_serviceName_changeContact_POST(String serviceName, String contactAdmin, String contactTech, String contactBilling) throws IOException {
        String qPath = "/ip/service/{serviceName}/changeContact";
        StringBuilder sb = this.path(qPath, new Object[]{serviceName});
        HashMap o = new HashMap();
        this.addBody(o, "contactAdmin", contactAdmin);
        this.addBody(o, "contactTech", contactTech);
        this.addBody(o, "contactBilling", contactBilling);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public ArrayList<String> service_GET() throws IOException {
        String qPath = "/ip/service";
        StringBuilder sb = this.path(qPath, new Object[0]);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }
}

